// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



/**
 * The structure holding all the information returned by AnalyzeExpense
 */
class ExpenseDocument private constructor(builder: Builder) {
    /**
     * Denotes which invoice or receipt in the document the information is coming from. First document will be 1, the second 2, and so on.
     */
    val expenseIndex: kotlin.Int? = builder.expenseIndex
    /**
     * Information detected on each table of a document, seperated into `LineItems`.
     */
    val lineItemGroups: List<LineItemGroup>? = builder.lineItemGroups
    /**
     * Any information found outside of a table by Amazon Textract.
     */
    val summaryFields: List<ExpenseField>? = builder.summaryFields

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.ExpenseDocument = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExpenseDocument(")
        append("expenseIndex=$expenseIndex,")
        append("lineItemGroups=$lineItemGroups,")
        append("summaryFields=$summaryFields)")
    }

    override fun hashCode(): kotlin.Int {
        var result = expenseIndex ?: 0
        result = 31 * result + (lineItemGroups?.hashCode() ?: 0)
        result = 31 * result + (summaryFields?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExpenseDocument

        if (expenseIndex != other.expenseIndex) return false
        if (lineItemGroups != other.lineItemGroups) return false
        if (summaryFields != other.summaryFields) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.ExpenseDocument = Builder(this).apply(block).build()

    class Builder {
        /**
         * Denotes which invoice or receipt in the document the information is coming from. First document will be 1, the second 2, and so on.
         */
        var expenseIndex: kotlin.Int? = null
        /**
         * Information detected on each table of a document, seperated into `LineItems`.
         */
        var lineItemGroups: List<LineItemGroup>? = null
        /**
         * Any information found outside of a table by Amazon Textract.
         */
        var summaryFields: List<ExpenseField>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.ExpenseDocument) : this() {
            this.expenseIndex = x.expenseIndex
            this.lineItemGroups = x.lineItemGroups
            this.summaryFields = x.summaryFields
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.ExpenseDocument = ExpenseDocument(this)
    }
}
