// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



/**
 * The bounding box around the detected page, text, key-value pair, table, table cell, or selection element on a document page. The `left` (x-coordinate) and `top` (y-coordinate) are coordinates that represent the top and left sides of the bounding box. Note that the upper-left corner of the image is the origin (0,0).
 *
 * The `top` and `left` values returned are ratios of the overall document page size. For example, if the input image is 700 x 200 pixels, and the top-left coordinate of the bounding box is 350 x 50 pixels, the API returns a `left` value of 0.5 (350/700) and a `top` value of 0.25 (50/200).
 *
 * The `width` and `height` values represent the dimensions of the bounding box as a ratio of the overall document page dimension. For example, if the document page size is 700 x 200 pixels, and the bounding box width is 70 pixels, the width returned is 0.1.
 */
class BoundingBox private constructor(builder: Builder) {
    /**
     * The height of the bounding box as a ratio of the overall document page height.
     */
    val height: kotlin.Float = builder.height
    /**
     * The left coordinate of the bounding box as a ratio of overall document page width.
     */
    val left: kotlin.Float = builder.left
    /**
     * The top coordinate of the bounding box as a ratio of overall document page height.
     */
    val top: kotlin.Float = builder.top
    /**
     * The width of the bounding box as a ratio of the overall document page width.
     */
    val width: kotlin.Float = builder.width

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.BoundingBox = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BoundingBox(")
        append("height=$height,")
        append("left=$left,")
        append("top=$top,")
        append("width=$width)")
    }

    override fun hashCode(): kotlin.Int {
        var result = height.hashCode()
        result = 31 * result + (left.hashCode())
        result = 31 * result + (top.hashCode())
        result = 31 * result + (width.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BoundingBox

        if (height != other.height) return false
        if (left != other.left) return false
        if (top != other.top) return false
        if (width != other.width) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.BoundingBox = Builder(this).apply(block).build()

    class Builder {
        /**
         * The height of the bounding box as a ratio of the overall document page height.
         */
        var height: kotlin.Float = 0.0f
        /**
         * The left coordinate of the bounding box as a ratio of overall document page width.
         */
        var left: kotlin.Float = 0.0f
        /**
         * The top coordinate of the bounding box as a ratio of overall document page height.
         */
        var top: kotlin.Float = 0.0f
        /**
         * The width of the bounding box as a ratio of the overall document page width.
         */
        var width: kotlin.Float = 0.0f

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.BoundingBox) : this() {
            this.height = x.height
            this.left = x.left
            this.top = x.top
            this.width = x.width
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.BoundingBox = BoundingBox(this)
    }
}
