// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



/**
 * A `Block` represents items that are recognized in a document within a group of pixels close to each other. The information returned in a `Block` object depends on the type of operation. In text detection for documents (for example DetectDocumentText), you get information about the detected words and lines of text. In text analysis (for example AnalyzeDocument), you can also get information about the fields, tables, and selection elements that are detected in the document.
 *
 * An array of `Block` objects is returned by both synchronous and asynchronous operations. In synchronous operations, such as DetectDocumentText, the array of `Block` objects is the entire set of results. In asynchronous operations, such as GetDocumentAnalysis, the array is returned over one or more responses.
 *
 * For more information, see [How Amazon Textract Works](https://docs.aws.amazon.com/textract/latest/dg/how-it-works.html).
 */
class Block private constructor(builder: Builder) {
    /**
     * The type of text item that's recognized. In operations for text detection, the following types are returned:
     * + *PAGE* - Contains a list of the LINE `Block` objects that are detected on a document page.
     * + *WORD* - A word detected on a document page. A word is one or more ISO basic Latin script characters that aren't separated by spaces.
     * + *LINE* - A string of tab-delimited, contiguous words that are detected on a document page.
     *
     * In text analysis operations, the following types are returned:
     * + *PAGE* - Contains a list of child `Block` objects that are detected on a document page.
     * + *KEY_VALUE_SET* - Stores the KEY and VALUE `Block` objects for linked text that's detected on a document page. Use the `EntityType` field to determine if a KEY_VALUE_SET object is a KEY `Block` object or a VALUE `Block` object.
     * + *WORD* - A word that's detected on a document page. A word is one or more ISO basic Latin script characters that aren't separated by spaces.
     * + *LINE* - A string of tab-delimited, contiguous words that are detected on a document page.
     * + *TABLE* - A table that's detected on a document page. A table is grid-based information with two or more rows or columns, with a cell span of one row and one column each.
     * + *CELL* - A cell within a detected table. The cell is the parent of the block that contains the text in the cell.
     * + *SELECTION_ELEMENT* - A selection element such as an option button (radio button) or a check box that's detected on a document page. Use the value of `SelectionStatus` to determine the status of the selection element.
     * + *QUERY* - A question asked during the call of AnalyzeDocument. Contains an alias and an ID that attachs it to its answer.
     * + *QUERY_RESULT* - A response to a question asked during the call of analyze document. Comes with an alias and ID for ease of locating in a response. Also contains location and confidence score.
     */
    val blockType: aws.sdk.kotlin.services.textract.model.BlockType? = builder.blockType
    /**
     * The column in which a table cell appears. The first column position is 1. `ColumnIndex` isn't returned by `DetectDocumentText` and `GetDocumentTextDetection`.
     */
    val columnIndex: kotlin.Int? = builder.columnIndex
    /**
     * The number of columns that a table cell spans. Currently this value is always 1, even if the number of columns spanned is greater than 1. `ColumnSpan` isn't returned by `DetectDocumentText` and `GetDocumentTextDetection`.
     */
    val columnSpan: kotlin.Int? = builder.columnSpan
    /**
     * The confidence score that Amazon Textract has in the accuracy of the recognized text and the accuracy of the geometry points around the recognized text.
     */
    val confidence: kotlin.Float? = builder.confidence
    /**
     * The type of entity. The following can be returned:
     * + *KEY* - An identifier for a field on the document.
     * + *VALUE* - The field text.
     *
     * `EntityTypes` isn't returned by `DetectDocumentText` and `GetDocumentTextDetection`.
     */
    val entityTypes: List<EntityType>? = builder.entityTypes
    /**
     * The location of the recognized text on the image. It includes an axis-aligned, coarse bounding box that surrounds the text, and a finer-grain polygon for more accurate spatial information.
     */
    val geometry: aws.sdk.kotlin.services.textract.model.Geometry? = builder.geometry
    /**
     * The identifier for the recognized text. The identifier is only unique for a single operation.
     */
    val id: kotlin.String? = builder.id
    /**
     * The page on which a block was detected. `Page` is returned by asynchronous operations. Page values greater than 1 are only returned for multipage documents that are in PDF or TIFF format. A scanned image (JPEG/PNG), even if it contains multiple document pages, is considered to be a single-page document. The value of `Page` is always 1. Synchronous operations don't return `Page` because every input document is considered to be a single-page document.
     */
    val page: kotlin.Int? = builder.page
    /**
     *
     */
    val query: aws.sdk.kotlin.services.textract.model.Query? = builder.query
    /**
     * A list of child blocks of the current block. For example, a LINE object has child blocks for each WORD block that's part of the line of text. There aren't Relationship objects in the list for relationships that don't exist, such as when the current block has no child blocks. The list size can be the following:
     * + 0 - The block has no child blocks.
     * + 1 - The block has child blocks.
     */
    val relationships: List<Relationship>? = builder.relationships
    /**
     * The row in which a table cell is located. The first row position is 1. `RowIndex` isn't returned by `DetectDocumentText` and `GetDocumentTextDetection`.
     */
    val rowIndex: kotlin.Int? = builder.rowIndex
    /**
     * The number of rows that a table cell spans. Currently this value is always 1, even if the number of rows spanned is greater than 1. `RowSpan` isn't returned by `DetectDocumentText` and `GetDocumentTextDetection`.
     */
    val rowSpan: kotlin.Int? = builder.rowSpan
    /**
     * The selection status of a selection element, such as an option button or check box.
     */
    val selectionStatus: aws.sdk.kotlin.services.textract.model.SelectionStatus? = builder.selectionStatus
    /**
     * The word or line of text that's recognized by Amazon Textract.
     */
    val text: kotlin.String? = builder.text
    /**
     * The kind of text that Amazon Textract has detected. Can check for handwritten text and printed text.
     */
    val textType: aws.sdk.kotlin.services.textract.model.TextType? = builder.textType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.Block = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Block(")
        append("blockType=$blockType,")
        append("columnIndex=$columnIndex,")
        append("columnSpan=$columnSpan,")
        append("confidence=$confidence,")
        append("entityTypes=$entityTypes,")
        append("geometry=$geometry,")
        append("id=$id,")
        append("page=$page,")
        append("query=$query,")
        append("relationships=$relationships,")
        append("rowIndex=$rowIndex,")
        append("rowSpan=$rowSpan,")
        append("selectionStatus=$selectionStatus,")
        append("text=$text,")
        append("textType=$textType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockType?.hashCode() ?: 0
        result = 31 * result + (columnIndex ?: 0)
        result = 31 * result + (columnSpan ?: 0)
        result = 31 * result + (confidence?.hashCode() ?: 0)
        result = 31 * result + (entityTypes?.hashCode() ?: 0)
        result = 31 * result + (geometry?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (page ?: 0)
        result = 31 * result + (query?.hashCode() ?: 0)
        result = 31 * result + (relationships?.hashCode() ?: 0)
        result = 31 * result + (rowIndex ?: 0)
        result = 31 * result + (rowSpan ?: 0)
        result = 31 * result + (selectionStatus?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        result = 31 * result + (textType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Block

        if (blockType != other.blockType) return false
        if (columnIndex != other.columnIndex) return false
        if (columnSpan != other.columnSpan) return false
        if (confidence != other.confidence) return false
        if (entityTypes != other.entityTypes) return false
        if (geometry != other.geometry) return false
        if (id != other.id) return false
        if (page != other.page) return false
        if (query != other.query) return false
        if (relationships != other.relationships) return false
        if (rowIndex != other.rowIndex) return false
        if (rowSpan != other.rowSpan) return false
        if (selectionStatus != other.selectionStatus) return false
        if (text != other.text) return false
        if (textType != other.textType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.Block = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of text item that's recognized. In operations for text detection, the following types are returned:
         * + *PAGE* - Contains a list of the LINE `Block` objects that are detected on a document page.
         * + *WORD* - A word detected on a document page. A word is one or more ISO basic Latin script characters that aren't separated by spaces.
         * + *LINE* - A string of tab-delimited, contiguous words that are detected on a document page.
         *
         * In text analysis operations, the following types are returned:
         * + *PAGE* - Contains a list of child `Block` objects that are detected on a document page.
         * + *KEY_VALUE_SET* - Stores the KEY and VALUE `Block` objects for linked text that's detected on a document page. Use the `EntityType` field to determine if a KEY_VALUE_SET object is a KEY `Block` object or a VALUE `Block` object.
         * + *WORD* - A word that's detected on a document page. A word is one or more ISO basic Latin script characters that aren't separated by spaces.
         * + *LINE* - A string of tab-delimited, contiguous words that are detected on a document page.
         * + *TABLE* - A table that's detected on a document page. A table is grid-based information with two or more rows or columns, with a cell span of one row and one column each.
         * + *CELL* - A cell within a detected table. The cell is the parent of the block that contains the text in the cell.
         * + *SELECTION_ELEMENT* - A selection element such as an option button (radio button) or a check box that's detected on a document page. Use the value of `SelectionStatus` to determine the status of the selection element.
         * + *QUERY* - A question asked during the call of AnalyzeDocument. Contains an alias and an ID that attachs it to its answer.
         * + *QUERY_RESULT* - A response to a question asked during the call of analyze document. Comes with an alias and ID for ease of locating in a response. Also contains location and confidence score.
         */
        var blockType: aws.sdk.kotlin.services.textract.model.BlockType? = null
        /**
         * The column in which a table cell appears. The first column position is 1. `ColumnIndex` isn't returned by `DetectDocumentText` and `GetDocumentTextDetection`.
         */
        var columnIndex: kotlin.Int? = null
        /**
         * The number of columns that a table cell spans. Currently this value is always 1, even if the number of columns spanned is greater than 1. `ColumnSpan` isn't returned by `DetectDocumentText` and `GetDocumentTextDetection`.
         */
        var columnSpan: kotlin.Int? = null
        /**
         * The confidence score that Amazon Textract has in the accuracy of the recognized text and the accuracy of the geometry points around the recognized text.
         */
        var confidence: kotlin.Float? = null
        /**
         * The type of entity. The following can be returned:
         * + *KEY* - An identifier for a field on the document.
         * + *VALUE* - The field text.
         *
         * `EntityTypes` isn't returned by `DetectDocumentText` and `GetDocumentTextDetection`.
         */
        var entityTypes: List<EntityType>? = null
        /**
         * The location of the recognized text on the image. It includes an axis-aligned, coarse bounding box that surrounds the text, and a finer-grain polygon for more accurate spatial information.
         */
        var geometry: aws.sdk.kotlin.services.textract.model.Geometry? = null
        /**
         * The identifier for the recognized text. The identifier is only unique for a single operation.
         */
        var id: kotlin.String? = null
        /**
         * The page on which a block was detected. `Page` is returned by asynchronous operations. Page values greater than 1 are only returned for multipage documents that are in PDF or TIFF format. A scanned image (JPEG/PNG), even if it contains multiple document pages, is considered to be a single-page document. The value of `Page` is always 1. Synchronous operations don't return `Page` because every input document is considered to be a single-page document.
         */
        var page: kotlin.Int? = null
        /**
         *
         */
        var query: aws.sdk.kotlin.services.textract.model.Query? = null
        /**
         * A list of child blocks of the current block. For example, a LINE object has child blocks for each WORD block that's part of the line of text. There aren't Relationship objects in the list for relationships that don't exist, such as when the current block has no child blocks. The list size can be the following:
         * + 0 - The block has no child blocks.
         * + 1 - The block has child blocks.
         */
        var relationships: List<Relationship>? = null
        /**
         * The row in which a table cell is located. The first row position is 1. `RowIndex` isn't returned by `DetectDocumentText` and `GetDocumentTextDetection`.
         */
        var rowIndex: kotlin.Int? = null
        /**
         * The number of rows that a table cell spans. Currently this value is always 1, even if the number of rows spanned is greater than 1. `RowSpan` isn't returned by `DetectDocumentText` and `GetDocumentTextDetection`.
         */
        var rowSpan: kotlin.Int? = null
        /**
         * The selection status of a selection element, such as an option button or check box.
         */
        var selectionStatus: aws.sdk.kotlin.services.textract.model.SelectionStatus? = null
        /**
         * The word or line of text that's recognized by Amazon Textract.
         */
        var text: kotlin.String? = null
        /**
         * The kind of text that Amazon Textract has detected. Can check for handwritten text and printed text.
         */
        var textType: aws.sdk.kotlin.services.textract.model.TextType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.Block) : this() {
            this.blockType = x.blockType
            this.columnIndex = x.columnIndex
            this.columnSpan = x.columnSpan
            this.confidence = x.confidence
            this.entityTypes = x.entityTypes
            this.geometry = x.geometry
            this.id = x.id
            this.page = x.page
            this.query = x.query
            this.relationships = x.relationships
            this.rowIndex = x.rowIndex
            this.rowSpan = x.rowSpan
            this.selectionStatus = x.selectionStatus
            this.text = x.text
            this.textType = x.textType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.Block = Block(this)

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.Geometry] inside the given [block]
         */
        fun geometry(block: aws.sdk.kotlin.services.textract.model.Geometry.Builder.() -> kotlin.Unit) {
            this.geometry = aws.sdk.kotlin.services.textract.model.Geometry.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.Query] inside the given [block]
         */
        fun query(block: aws.sdk.kotlin.services.textract.model.Query.Builder.() -> kotlin.Unit) {
            this.query = aws.sdk.kotlin.services.textract.model.Query.invoke(block)
        }
    }
}
