// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.textract.model.*
import aws.sdk.kotlin.services.textract.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Textract"
const val ServiceApiVersion: String = "2018-06-27"
const val SdkVersion: String = "0.16.2-beta"

internal class DefaultTextractClient(override val config: TextractClient.Config) : TextractClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Analyzes an input document for relationships between detected items.
     *
     * The types of information returned are as follows:
     * + Form data (key-value pairs). The related information is returned in two Block objects, each of type `KEY_VALUE_SET`: a KEY `Block` object and a VALUE `Block` object. For example, *Name: Ana Silva Carolina* contains a key and value. *Name:* is the key. *Ana Silva Carolina* is the value.
     * + Table and table cell data. A TABLE `Block` object contains information about a detected table. A CELL `Block` object is returned for each cell in a table.
     * + Lines and words of text. A LINE `Block` object contains one or more WORD `Block` objects. All lines and words that are detected in the document are returned (including text that doesn't have a relationship with the value of `FeatureTypes`).
     * + Queries.A QUERIES_RESULT Block object contains the answer to the query, the alias associated and an ID that connect it to the query asked. This Block also contains a location and attached confidence score.
     *
     * Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in tables. A SELECTION_ELEMENT `Block` object contains information about a selection element, including the selection status.
     *
     * You can choose which type of analysis to perform by specifying the `FeatureTypes` list.
     *
     * The output is returned in a list of `Block` objects.
     *
     * `AnalyzeDocument` is a synchronous operation. To analyze documents asynchronously, use StartDocumentAnalysis.
     *
     * For more information, see [Document Text Analysis](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
     */
    override suspend fun analyzeDocument(input: AnalyzeDocumentRequest): AnalyzeDocumentResponse {
        val op = SdkHttpOperation.build<AnalyzeDocumentRequest, AnalyzeDocumentResponse> {
            serializer = AnalyzeDocumentOperationSerializer()
            deserializer = AnalyzeDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AnalyzeDocument"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Textract", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "textract"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * `AnalyzeExpense` synchronously analyzes an input document for financially related relationships between text.
     *
     * Information is returned as `ExpenseDocuments` and seperated as follows.
     * + `LineItemGroups`- A data set containing `LineItems` which store information about the lines of text, such as an item purchased and its price on a receipt.
     * + `SummaryFields`- Contains all other information a receipt, such as header information or the vendors name.
     */
    override suspend fun analyzeExpense(input: AnalyzeExpenseRequest): AnalyzeExpenseResponse {
        val op = SdkHttpOperation.build<AnalyzeExpenseRequest, AnalyzeExpenseResponse> {
            serializer = AnalyzeExpenseOperationSerializer()
            deserializer = AnalyzeExpenseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AnalyzeExpense"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Textract", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "textract"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Analyzes identity documents for relevant information. This information is extracted and returned as `IdentityDocumentFields`, which records both the normalized field and value of the extracted text.Unlike other Amazon Textract operations, `AnalyzeID` doesn't return any Geometry data.
     */
    override suspend fun analyzeId(input: AnalyzeIdRequest): AnalyzeIdResponse {
        val op = SdkHttpOperation.build<AnalyzeIdRequest, AnalyzeIdResponse> {
            serializer = AnalyzeIDOperationSerializer()
            deserializer = AnalyzeIDOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AnalyzeID"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Textract", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "textract"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detects text in the input document. Amazon Textract can detect lines of text and the words that make up a line of text. The input document must be an image in JPEG, PNG, PDF, or TIFF format. `DetectDocumentText` returns the detected text in an array of Block objects.
     *
     * Each document page has as an associated `Block` of type PAGE. Each PAGE `Block` object is the parent of LINE `Block` objects that represent the lines of detected text on a page. A LINE `Block` object is a parent for each word that makes up the line. Words are represented by `Block` objects of type WORD.
     *
     * `DetectDocumentText` is a synchronous operation. To analyze documents asynchronously, use StartDocumentTextDetection.
     *
     * For more information, see [Document Text Detection](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
     */
    override suspend fun detectDocumentText(input: DetectDocumentTextRequest): DetectDocumentTextResponse {
        val op = SdkHttpOperation.build<DetectDocumentTextRequest, DetectDocumentTextResponse> {
            serializer = DetectDocumentTextOperationSerializer()
            deserializer = DetectDocumentTextOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetectDocumentText"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Textract", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "textract"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the results for an Amazon Textract asynchronous operation that analyzes text in a document.
     *
     * You start asynchronous text analysis by calling StartDocumentAnalysis, which returns a job identifier (`JobId`). When the text analysis operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to `StartDocumentAnalysis`. To get the results of the text-detection operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call `GetDocumentAnalysis`, and pass the job identifier (`JobId`) from the initial call to `StartDocumentAnalysis`.
     *
     * `GetDocumentAnalysis` returns an array of Block objects. The following types of information are returned:
     * + Form data (key-value pairs). The related information is returned in two Block objects, each of type `KEY_VALUE_SET`: a KEY `Block` object and a VALUE `Block` object. For example, *Name: Ana Silva Carolina* contains a key and value. *Name:* is the key. *Ana Silva Carolina* is the value.
     * + Table and table cell data. A TABLE `Block` object contains information about a detected table. A CELL `Block` object is returned for each cell in a table.
     * + Lines and words of text. A LINE `Block` object contains one or more WORD `Block` objects. All lines and words that are detected in the document are returned (including text that doesn't have a relationship with the value of the `StartDocumentAnalysis``FeatureTypes` input parameter).
     * + Queries. A QUERIES_RESULT Block object contains the answer to the query, the alias associated and an ID that connect it to the query asked. This Block also contains a location and attached confidence score
     *
     * Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in tables. A SELECTION_ELEMENT `Block` object contains information about a selection element, including the selection status.
     *
     * Use the `MaxResults` parameter to limit the number of blocks that are returned. If there are more results than specified in `MaxResults`, the value of `NextToken` in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call `GetDocumentAnalysis`, and populate the `NextToken` request parameter with the token value that's returned from the previous call to `GetDocumentAnalysis`.
     *
     * For more information, see [Document Text Analysis](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
     */
    override suspend fun getDocumentAnalysis(input: GetDocumentAnalysisRequest): GetDocumentAnalysisResponse {
        val op = SdkHttpOperation.build<GetDocumentAnalysisRequest, GetDocumentAnalysisResponse> {
            serializer = GetDocumentAnalysisOperationSerializer()
            deserializer = GetDocumentAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDocumentAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Textract", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "textract"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the results for an Amazon Textract asynchronous operation that detects text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.
     *
     * You start asynchronous text detection by calling StartDocumentTextDetection, which returns a job identifier (`JobId`). When the text detection operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to `StartDocumentTextDetection`. To get the results of the text-detection operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call `GetDocumentTextDetection`, and pass the job identifier (`JobId`) from the initial call to `StartDocumentTextDetection`.
     *
     * `GetDocumentTextDetection` returns an array of Block objects.
     *
     * Each document page has as an associated `Block` of type PAGE. Each PAGE `Block` object is the parent of LINE `Block` objects that represent the lines of detected text on a page. A LINE `Block` object is a parent for each word that makes up the line. Words are represented by `Block` objects of type WORD.
     *
     * Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than specified in `MaxResults`, the value of `NextToken` in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call `GetDocumentTextDetection`, and populate the `NextToken` request parameter with the token value that's returned from the previous call to `GetDocumentTextDetection`.
     *
     * For more information, see [Document Text Detection](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
     */
    override suspend fun getDocumentTextDetection(input: GetDocumentTextDetectionRequest): GetDocumentTextDetectionResponse {
        val op = SdkHttpOperation.build<GetDocumentTextDetectionRequest, GetDocumentTextDetectionResponse> {
            serializer = GetDocumentTextDetectionOperationSerializer()
            deserializer = GetDocumentTextDetectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDocumentTextDetection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Textract", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "textract"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the results for an Amazon Textract asynchronous operation that analyzes invoices and receipts. Amazon Textract finds contact information, items purchased, and vendor name, from input invoices and receipts.
     *
     * You start asynchronous invoice/receipt analysis by calling StartExpenseAnalysis, which returns a job identifier (`JobId`). Upon completion of the invoice/receipt analysis, Amazon Textract publishes the completion status to the Amazon Simple Notification Service (Amazon SNS) topic. This topic must be registered in the initial call to `StartExpenseAnalysis`. To get the results of the invoice/receipt analysis operation, first ensure that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call `GetExpenseAnalysis`, and pass the job identifier (`JobId`) from the initial call to `StartExpenseAnalysis`.
     *
     * Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than specified in `MaxResults`, the value of `NextToken` in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call `GetExpenseAnalysis`, and populate the `NextToken` request parameter with the token value that's returned from the previous call to `GetExpenseAnalysis`.
     *
     * For more information, see [Analyzing Invoices and Receipts](https://docs.aws.amazon.com/textract/latest/dg/invoices-receipts.html).
     */
    override suspend fun getExpenseAnalysis(input: GetExpenseAnalysisRequest): GetExpenseAnalysisResponse {
        val op = SdkHttpOperation.build<GetExpenseAnalysisRequest, GetExpenseAnalysisResponse> {
            serializer = GetExpenseAnalysisOperationSerializer()
            deserializer = GetExpenseAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetExpenseAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Textract", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "textract"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts the asynchronous analysis of an input document for relationships between detected items such as key-value pairs, tables, and selection elements.
     *
     * `StartDocumentAnalysis` can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The documents are stored in an Amazon S3 bucket. Use DocumentLocation to specify the bucket name and file name of the document.
     *
     * `StartDocumentAnalysis` returns a job identifier (`JobId`) that you use to get the results of the operation. When text analysis is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you specify in `NotificationChannel`. To get the results of the text analysis operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call GetDocumentAnalysis, and pass the job identifier (`JobId`) from the initial call to `StartDocumentAnalysis`.
     *
     * For more information, see [Document Text Analysis](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
     */
    override suspend fun startDocumentAnalysis(input: StartDocumentAnalysisRequest): StartDocumentAnalysisResponse {
        val op = SdkHttpOperation.build<StartDocumentAnalysisRequest, StartDocumentAnalysisResponse> {
            serializer = StartDocumentAnalysisOperationSerializer()
            deserializer = StartDocumentAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDocumentAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Textract", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "textract"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts the asynchronous detection of text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.
     *
     * `StartDocumentTextDetection` can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The documents are stored in an Amazon S3 bucket. Use DocumentLocation to specify the bucket name and file name of the document.
     *
     * `StartTextDetection` returns a job identifier (`JobId`) that you use to get the results of the operation. When text detection is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you specify in `NotificationChannel`. To get the results of the text detection operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call GetDocumentTextDetection, and pass the job identifier (`JobId`) from the initial call to `StartDocumentTextDetection`.
     *
     * For more information, see [Document Text Detection](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
     */
    override suspend fun startDocumentTextDetection(input: StartDocumentTextDetectionRequest): StartDocumentTextDetectionResponse {
        val op = SdkHttpOperation.build<StartDocumentTextDetectionRequest, StartDocumentTextDetectionResponse> {
            serializer = StartDocumentTextDetectionOperationSerializer()
            deserializer = StartDocumentTextDetectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDocumentTextDetection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Textract", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "textract"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts the asynchronous analysis of invoices or receipts for data like contact information, items purchased, and vendor names.
     *
     * `StartExpenseAnalysis` can analyze text in documents that are in JPEG, PNG, and PDF format. The documents must be stored in an Amazon S3 bucket. Use the DocumentLocation parameter to specify the name of your S3 bucket and the name of the document in that bucket.
     *
     * `StartExpenseAnalysis` returns a job identifier (`JobId`) that you will provide to `GetExpenseAnalysis` to retrieve the results of the operation. When the analysis of the input invoices/receipts is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you provide to the `NotificationChannel`. To obtain the results of the invoice and receipt analysis operation, ensure that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call GetExpenseAnalysis, and pass the job identifier (`JobId`) that was returned by your call to `StartExpenseAnalysis`.
     *
     * For more information, see [Analyzing Invoices and Receipts](https://docs.aws.amazon.com/textract/latest/dg/invoice-receipts.html).
     */
    override suspend fun startExpenseAnalysis(input: StartExpenseAnalysisRequest): StartExpenseAnalysisResponse {
        val op = SdkHttpOperation.build<StartExpenseAnalysisRequest, StartExpenseAnalysisResponse> {
            serializer = StartExpenseAnalysisOperationSerializer()
            deserializer = StartExpenseAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartExpenseAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Textract", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "textract"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "textract")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
