// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.paginators

import aws.sdk.kotlin.services.taxsettings.TaxSettingsClient
import aws.sdk.kotlin.services.taxsettings.model.AccountDetails
import aws.sdk.kotlin.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest
import aws.sdk.kotlin.services.taxsettings.model.ListSupplementalTaxRegistrationsResponse
import aws.sdk.kotlin.services.taxsettings.model.ListTaxExemptionsRequest
import aws.sdk.kotlin.services.taxsettings.model.ListTaxExemptionsResponse
import aws.sdk.kotlin.services.taxsettings.model.ListTaxRegistrationsRequest
import aws.sdk.kotlin.services.taxsettings.model.ListTaxRegistrationsResponse
import aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistration
import aws.sdk.kotlin.services.taxsettings.model.TaxExemptionDetails
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListSupplementalTaxRegistrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSupplementalTaxRegistrationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSupplementalTaxRegistrationsResponse]
 */
public fun TaxSettingsClient.listSupplementalTaxRegistrationsPaginated(initialRequest: ListSupplementalTaxRegistrationsRequest = ListSupplementalTaxRegistrationsRequest { }): Flow<ListSupplementalTaxRegistrationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSupplementalTaxRegistrationsPaginated.listSupplementalTaxRegistrations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSupplementalTaxRegistrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSupplementalTaxRegistrationsResponse]
 */
public fun TaxSettingsClient.listSupplementalTaxRegistrationsPaginated(block: ListSupplementalTaxRegistrationsRequest.Builder.() -> Unit): Flow<ListSupplementalTaxRegistrationsResponse> =
    listSupplementalTaxRegistrationsPaginated(ListSupplementalTaxRegistrationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSupplementalTaxRegistrationsPaginated]
 * to access the nested member [SupplementalTaxRegistration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SupplementalTaxRegistration]
 */
@JvmName("listSupplementalTaxRegistrationsResponseSupplementalTaxRegistration")
public fun Flow<ListSupplementalTaxRegistrationsResponse>.taxRegistrations(): Flow<SupplementalTaxRegistration> =
    transform() { response ->
        response.taxRegistrations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTaxExemptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTaxExemptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaxExemptionsResponse]
 */
public fun TaxSettingsClient.listTaxExemptionsPaginated(initialRequest: ListTaxExemptionsRequest = ListTaxExemptionsRequest { }): Flow<ListTaxExemptionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTaxExemptionsPaginated.listTaxExemptions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTaxExemptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaxExemptionsResponse]
 */
public fun TaxSettingsClient.listTaxExemptionsPaginated(block: ListTaxExemptionsRequest.Builder.() -> Unit): Flow<ListTaxExemptionsResponse> =
    listTaxExemptionsPaginated(ListTaxExemptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTaxExemptionsPaginated]
 * to access the nested member [TaxExemptionDetailsMap]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TaxExemptionDetailsMap]
 */
@JvmName("listTaxExemptionsResponseTaxExemptionDetailsMap")
public fun Flow<ListTaxExemptionsResponse>.taxExemptionDetailsMap(): Flow<Map.Entry<String, TaxExemptionDetails>> =
    transform() { response ->
        response.taxExemptionDetailsMap?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTaxRegistrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTaxRegistrationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaxRegistrationsResponse]
 */
public fun TaxSettingsClient.listTaxRegistrationsPaginated(initialRequest: ListTaxRegistrationsRequest = ListTaxRegistrationsRequest { }): Flow<ListTaxRegistrationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTaxRegistrationsPaginated.listTaxRegistrations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTaxRegistrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaxRegistrationsResponse]
 */
public fun TaxSettingsClient.listTaxRegistrationsPaginated(block: ListTaxRegistrationsRequest.Builder.() -> Unit): Flow<ListTaxRegistrationsResponse> =
    listTaxRegistrationsPaginated(ListTaxRegistrationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTaxRegistrationsPaginated]
 * to access the nested member [AccountDetails]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountDetails]
 */
@JvmName("listTaxRegistrationsResponseAccountDetails")
public fun Flow<ListTaxRegistrationsResponse>.accountDetails(): Flow<AccountDetails> =
    transform() { response ->
        response.accountDetails?.forEach {
            emit(it)
        }
    }
