// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Additional tax information associated with your TRN in Turkey.
 */
public class TurkeyAdditionalInfo private constructor(builder: Builder) {
    /**
     * The industry information that tells the Tax Settings API if you're subject to additional withholding taxes. This information required for business-to-business (B2B) customers. This information is conditionally mandatory for B2B customers who are subject to KDV tax.
     */
    public val industries: aws.sdk.kotlin.services.taxsettings.model.Industries? = builder.industries
    /**
     * The Registered Electronic Mail (REM) that is used to send notarized communication. This parameter is optional for business-to-business (B2B) and business-to-government (B2G) customers. It's not required for business-to-consumer (B2C) customers.
     */
    public val kepEmailId: kotlin.String? = builder.kepEmailId
    /**
     * Secondary tax ID (“harcama birimi VKN”si”). If one isn't provided, we will use your VKN as the secondary ID.
     */
    public val secondaryTaxId: kotlin.String? = builder.secondaryTaxId
    /**
     * The tax office where you're registered. You can enter this information as a string. The Tax Settings API will add this information to your invoice. This parameter is required for business-to-business (B2B) and business-to-government customers. It's not required for business-to-consumer (B2C) customers.
     */
    public val taxOffice: kotlin.String? = builder.taxOffice

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.taxsettings.model.TurkeyAdditionalInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TurkeyAdditionalInfo(")
        append("industries=$industries,")
        append("kepEmailId=$kepEmailId,")
        append("secondaryTaxId=$secondaryTaxId,")
        append("taxOffice=$taxOffice")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = industries?.hashCode() ?: 0
        result = 31 * result + (this.kepEmailId?.hashCode() ?: 0)
        result = 31 * result + (this.secondaryTaxId?.hashCode() ?: 0)
        result = 31 * result + (this.taxOffice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TurkeyAdditionalInfo

        if (industries != other.industries) return false
        if (kepEmailId != other.kepEmailId) return false
        if (secondaryTaxId != other.secondaryTaxId) return false
        if (taxOffice != other.taxOffice) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.taxsettings.model.TurkeyAdditionalInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The industry information that tells the Tax Settings API if you're subject to additional withholding taxes. This information required for business-to-business (B2B) customers. This information is conditionally mandatory for B2B customers who are subject to KDV tax.
         */
        public var industries: aws.sdk.kotlin.services.taxsettings.model.Industries? = null
        /**
         * The Registered Electronic Mail (REM) that is used to send notarized communication. This parameter is optional for business-to-business (B2B) and business-to-government (B2G) customers. It's not required for business-to-consumer (B2C) customers.
         */
        public var kepEmailId: kotlin.String? = null
        /**
         * Secondary tax ID (“harcama birimi VKN”si”). If one isn't provided, we will use your VKN as the secondary ID.
         */
        public var secondaryTaxId: kotlin.String? = null
        /**
         * The tax office where you're registered. You can enter this information as a string. The Tax Settings API will add this information to your invoice. This parameter is required for business-to-business (B2B) and business-to-government customers. It's not required for business-to-consumer (B2C) customers.
         */
        public var taxOffice: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.taxsettings.model.TurkeyAdditionalInfo) : this() {
            this.industries = x.industries
            this.kepEmailId = x.kepEmailId
            this.secondaryTaxId = x.secondaryTaxId
            this.taxOffice = x.taxOffice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.taxsettings.model.TurkeyAdditionalInfo = TurkeyAdditionalInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
