// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Your TRN information with jurisdiction details. This doesn't contain the full legal address associated with the TRN information.
 */
public class TaxRegistrationWithJurisdiction private constructor(builder: Builder) {
    /**
     * Additional tax information associated with your TRN.
     */
    public val additionalTaxInformation: aws.sdk.kotlin.services.taxsettings.model.AdditionalInfoResponse? = builder.additionalTaxInformation
    /**
     * The email address to receive VAT invoices.
     */
    public val certifiedEmailId: kotlin.String? = builder.certifiedEmailId
    /**
     * The jurisdiction associated with your TRN information.
     */
    public val jurisdiction: aws.sdk.kotlin.services.taxsettings.model.Jurisdiction? = builder.jurisdiction
    /**
     * The legal name associated with your TRN information.
     */
    public val legalName: kotlin.String = requireNotNull(builder.legalName) { "A non-null value must be provided for legalName" }
    /**
     * Your tax registration unique identifier.
     */
    public val registrationId: kotlin.String = requireNotNull(builder.registrationId) { "A non-null value must be provided for registrationId" }
    /**
     * The type of your tax registration. This can be either `VAT` or `GST`.
     */
    public val registrationType: aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationType = requireNotNull(builder.registrationType) { "A non-null value must be provided for registrationType" }
    /**
     * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify Government.Note that certain values may not applicable for the request country. Please refer to country specific information in API document.
     */
    public val sector: aws.sdk.kotlin.services.taxsettings.model.Sector? = builder.sector
    /**
     * The status of your TRN. This can be either `Verified`, `Pending`, `Deleted`, or `Rejected`.
     */
    public val status: aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The metadata for your tax document.
     */
    public val taxDocumentMetadatas: List<TaxDocumentMetadata>? = builder.taxDocumentMetadatas

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationWithJurisdiction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaxRegistrationWithJurisdiction(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalTaxInformation?.hashCode() ?: 0
        result = 31 * result + (this.certifiedEmailId?.hashCode() ?: 0)
        result = 31 * result + (this.jurisdiction?.hashCode() ?: 0)
        result = 31 * result + (this.legalName.hashCode())
        result = 31 * result + (this.registrationId.hashCode())
        result = 31 * result + (this.registrationType.hashCode())
        result = 31 * result + (this.sector?.hashCode() ?: 0)
        result = 31 * result + (this.status.hashCode())
        result = 31 * result + (this.taxDocumentMetadatas?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaxRegistrationWithJurisdiction

        if (additionalTaxInformation != other.additionalTaxInformation) return false
        if (certifiedEmailId != other.certifiedEmailId) return false
        if (jurisdiction != other.jurisdiction) return false
        if (legalName != other.legalName) return false
        if (registrationId != other.registrationId) return false
        if (registrationType != other.registrationType) return false
        if (sector != other.sector) return false
        if (status != other.status) return false
        if (taxDocumentMetadatas != other.taxDocumentMetadatas) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationWithJurisdiction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Additional tax information associated with your TRN.
         */
        public var additionalTaxInformation: aws.sdk.kotlin.services.taxsettings.model.AdditionalInfoResponse? = null
        /**
         * The email address to receive VAT invoices.
         */
        public var certifiedEmailId: kotlin.String? = null
        /**
         * The jurisdiction associated with your TRN information.
         */
        public var jurisdiction: aws.sdk.kotlin.services.taxsettings.model.Jurisdiction? = null
        /**
         * The legal name associated with your TRN information.
         */
        public var legalName: kotlin.String? = null
        /**
         * Your tax registration unique identifier.
         */
        public var registrationId: kotlin.String? = null
        /**
         * The type of your tax registration. This can be either `VAT` or `GST`.
         */
        public var registrationType: aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationType? = null
        /**
         * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify Government.Note that certain values may not applicable for the request country. Please refer to country specific information in API document.
         */
        public var sector: aws.sdk.kotlin.services.taxsettings.model.Sector? = null
        /**
         * The status of your TRN. This can be either `Verified`, `Pending`, `Deleted`, or `Rejected`.
         */
        public var status: aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationStatus? = null
        /**
         * The metadata for your tax document.
         */
        public var taxDocumentMetadatas: List<TaxDocumentMetadata>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationWithJurisdiction) : this() {
            this.additionalTaxInformation = x.additionalTaxInformation
            this.certifiedEmailId = x.certifiedEmailId
            this.jurisdiction = x.jurisdiction
            this.legalName = x.legalName
            this.registrationId = x.registrationId
            this.registrationType = x.registrationType
            this.sector = x.sector
            this.status = x.status
            this.taxDocumentMetadatas = x.taxDocumentMetadatas
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationWithJurisdiction = TaxRegistrationWithJurisdiction(this)

        /**
         * construct an [aws.sdk.kotlin.services.taxsettings.model.AdditionalInfoResponse] inside the given [block]
         */
        public fun additionalTaxInformation(block: aws.sdk.kotlin.services.taxsettings.model.AdditionalInfoResponse.Builder.() -> kotlin.Unit) {
            this.additionalTaxInformation = aws.sdk.kotlin.services.taxsettings.model.AdditionalInfoResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.taxsettings.model.Jurisdiction] inside the given [block]
         */
        public fun jurisdiction(block: aws.sdk.kotlin.services.taxsettings.model.Jurisdiction.Builder.() -> kotlin.Unit) {
            this.jurisdiction = aws.sdk.kotlin.services.taxsettings.model.Jurisdiction.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (legalName == null) legalName = ""
            if (registrationId == null) registrationId = ""
            if (registrationType == null) registrationType = TaxRegistrationType.SdkUnknown("no value provided")
            if (status == null) status = TaxRegistrationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
