// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The TRN information you provide when you add a new TRN, or update.
 */
public class TaxRegistrationEntry private constructor(builder: Builder) {
    /**
     * Additional tax information associated with your TRN. You only need to specify this parameter if Amazon Web Services collects any additional information for your country within AdditionalInfoRequest.
     */
    public val additionalTaxInformation: aws.sdk.kotlin.services.taxsettings.model.AdditionalInfoRequest? = builder.additionalTaxInformation
    /**
     * The email address to receive VAT invoices.
     */
    public val certifiedEmailId: kotlin.String? = builder.certifiedEmailId
    /**
     * The legal address associated with your TRN.
     *
     * If you're setting a TRN in Brazil for the CNPJ tax type, you don't need to specify the legal address.
     *
     * For TRNs in other countries and for CPF tax types Brazil, you must specify the legal address.
     */
    public val legalAddress: aws.sdk.kotlin.services.taxsettings.model.Address? = builder.legalAddress
    /**
     * The legal name associated with your TRN.
     *
     * If you're setting a TRN in Brazil, you don't need to specify the legal name. For TRNs in other countries, you must specify the legal name.
     */
    public val legalName: kotlin.String? = builder.legalName
    /**
     * Your tax registration unique identifier.
     */
    public val registrationId: kotlin.String = requireNotNull(builder.registrationId) { "A non-null value must be provided for registrationId" }
    /**
     * Your tax registration type. This can be either `VAT` or `GST`.
     */
    public val registrationType: aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationType = requireNotNull(builder.registrationType) { "A non-null value must be provided for registrationType" }
    /**
     * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify Government.Note that certain values may not applicable for the request country. Please refer to country specific information in API document.
     */
    public val sector: aws.sdk.kotlin.services.taxsettings.model.Sector? = builder.sector
    /**
     * Additional details needed to verify your TRN information in Brazil. You only need to specify this parameter when you set a TRN in Brazil that is the CPF tax type.
     *
     * Don't specify this parameter to set a TRN in Brazil of the CNPJ tax type or to set a TRN for another country.
     */
    public val verificationDetails: aws.sdk.kotlin.services.taxsettings.model.VerificationDetails? = builder.verificationDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaxRegistrationEntry(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalTaxInformation?.hashCode() ?: 0
        result = 31 * result + (this.certifiedEmailId?.hashCode() ?: 0)
        result = 31 * result + (this.legalAddress?.hashCode() ?: 0)
        result = 31 * result + (this.legalName?.hashCode() ?: 0)
        result = 31 * result + (this.registrationId.hashCode())
        result = 31 * result + (this.registrationType.hashCode())
        result = 31 * result + (this.sector?.hashCode() ?: 0)
        result = 31 * result + (this.verificationDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaxRegistrationEntry

        if (additionalTaxInformation != other.additionalTaxInformation) return false
        if (certifiedEmailId != other.certifiedEmailId) return false
        if (legalAddress != other.legalAddress) return false
        if (legalName != other.legalName) return false
        if (registrationId != other.registrationId) return false
        if (registrationType != other.registrationType) return false
        if (sector != other.sector) return false
        if (verificationDetails != other.verificationDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Additional tax information associated with your TRN. You only need to specify this parameter if Amazon Web Services collects any additional information for your country within AdditionalInfoRequest.
         */
        public var additionalTaxInformation: aws.sdk.kotlin.services.taxsettings.model.AdditionalInfoRequest? = null
        /**
         * The email address to receive VAT invoices.
         */
        public var certifiedEmailId: kotlin.String? = null
        /**
         * The legal address associated with your TRN.
         *
         * If you're setting a TRN in Brazil for the CNPJ tax type, you don't need to specify the legal address.
         *
         * For TRNs in other countries and for CPF tax types Brazil, you must specify the legal address.
         */
        public var legalAddress: aws.sdk.kotlin.services.taxsettings.model.Address? = null
        /**
         * The legal name associated with your TRN.
         *
         * If you're setting a TRN in Brazil, you don't need to specify the legal name. For TRNs in other countries, you must specify the legal name.
         */
        public var legalName: kotlin.String? = null
        /**
         * Your tax registration unique identifier.
         */
        public var registrationId: kotlin.String? = null
        /**
         * Your tax registration type. This can be either `VAT` or `GST`.
         */
        public var registrationType: aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationType? = null
        /**
         * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify Government.Note that certain values may not applicable for the request country. Please refer to country specific information in API document.
         */
        public var sector: aws.sdk.kotlin.services.taxsettings.model.Sector? = null
        /**
         * Additional details needed to verify your TRN information in Brazil. You only need to specify this parameter when you set a TRN in Brazil that is the CPF tax type.
         *
         * Don't specify this parameter to set a TRN in Brazil of the CNPJ tax type or to set a TRN for another country.
         */
        public var verificationDetails: aws.sdk.kotlin.services.taxsettings.model.VerificationDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationEntry) : this() {
            this.additionalTaxInformation = x.additionalTaxInformation
            this.certifiedEmailId = x.certifiedEmailId
            this.legalAddress = x.legalAddress
            this.legalName = x.legalName
            this.registrationId = x.registrationId
            this.registrationType = x.registrationType
            this.sector = x.sector
            this.verificationDetails = x.verificationDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationEntry = TaxRegistrationEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.taxsettings.model.AdditionalInfoRequest] inside the given [block]
         */
        public fun additionalTaxInformation(block: aws.sdk.kotlin.services.taxsettings.model.AdditionalInfoRequest.Builder.() -> kotlin.Unit) {
            this.additionalTaxInformation = aws.sdk.kotlin.services.taxsettings.model.AdditionalInfoRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.taxsettings.model.Address] inside the given [block]
         */
        public fun legalAddress(block: aws.sdk.kotlin.services.taxsettings.model.Address.Builder.() -> kotlin.Unit) {
            this.legalAddress = aws.sdk.kotlin.services.taxsettings.model.Address.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.taxsettings.model.VerificationDetails] inside the given [block]
         */
        public fun verificationDetails(block: aws.sdk.kotlin.services.taxsettings.model.VerificationDetails.Builder.() -> kotlin.Unit) {
            this.verificationDetails = aws.sdk.kotlin.services.taxsettings.model.VerificationDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (registrationId == null) registrationId = ""
            if (registrationType == null) registrationType = TaxRegistrationType.SdkUnknown("no value provided")
            return this
        }
    }
}
