// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The metadata for your tax document.
 */
public class TaxDocumentMetadata private constructor(builder: Builder) {
    /**
     * The tax document access token, which contains information that the Tax Settings API uses to locate the tax document.
     *
     * If you update your tax registration, the existing `taxDocumentAccessToken` won't be valid. To get the latest token, call the `GetTaxRegistration` or `ListTaxRegistrations` API operation. This token is valid for 24 hours.
     */
    public val taxDocumentAccessToken: kotlin.String = requireNotNull(builder.taxDocumentAccessToken) { "A non-null value must be provided for taxDocumentAccessToken" }
    /**
     * The name of your tax document.
     */
    public val taxDocumentName: kotlin.String = requireNotNull(builder.taxDocumentName) { "A non-null value must be provided for taxDocumentName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.taxsettings.model.TaxDocumentMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaxDocumentMetadata(")
        append("taxDocumentAccessToken=$taxDocumentAccessToken,")
        append("taxDocumentName=$taxDocumentName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = taxDocumentAccessToken.hashCode()
        result = 31 * result + (this.taxDocumentName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaxDocumentMetadata

        if (taxDocumentAccessToken != other.taxDocumentAccessToken) return false
        if (taxDocumentName != other.taxDocumentName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.taxsettings.model.TaxDocumentMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The tax document access token, which contains information that the Tax Settings API uses to locate the tax document.
         *
         * If you update your tax registration, the existing `taxDocumentAccessToken` won't be valid. To get the latest token, call the `GetTaxRegistration` or `ListTaxRegistrations` API operation. This token is valid for 24 hours.
         */
        public var taxDocumentAccessToken: kotlin.String? = null
        /**
         * The name of your tax document.
         */
        public var taxDocumentName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.taxsettings.model.TaxDocumentMetadata) : this() {
            this.taxDocumentAccessToken = x.taxDocumentAccessToken
            this.taxDocumentName = x.taxDocumentName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.taxsettings.model.TaxDocumentMetadata = TaxDocumentMetadata(this)

        internal fun correctErrors(): Builder {
            if (taxDocumentAccessToken == null) taxDocumentAccessToken = ""
            if (taxDocumentName == null) taxDocumentName = ""
            return this
        }
    }
}
