// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Supplemental TRN details.
 */
public class SupplementalTaxRegistration private constructor(builder: Builder) {
    /**
     * The details of the address associated with the TRN information.
     */
    public val address: aws.sdk.kotlin.services.taxsettings.model.Address? = builder.address
    /**
     * Unique authority ID for the supplemental TRN.
     */
    public val authorityId: kotlin.String = requireNotNull(builder.authorityId) { "A non-null value must be provided for authorityId" }
    /**
     * The legal name associated with your TRN registration.
     */
    public val legalName: kotlin.String = requireNotNull(builder.legalName) { "A non-null value must be provided for legalName" }
    /**
     * The supplemental TRN unique identifier.
     */
    public val registrationId: kotlin.String = requireNotNull(builder.registrationId) { "A non-null value must be provided for registrationId" }
    /**
     * Type of supplemental TRN. Currently, this can only be VAT.
     */
    public val registrationType: aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistrationType = requireNotNull(builder.registrationType) { "A non-null value must be provided for registrationType" }
    /**
     * The status of your TRN.
     */
    public val status: aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SupplementalTaxRegistration(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (this.authorityId.hashCode())
        result = 31 * result + (this.legalName.hashCode())
        result = 31 * result + (this.registrationId.hashCode())
        result = 31 * result + (this.registrationType.hashCode())
        result = 31 * result + (this.status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SupplementalTaxRegistration

        if (address != other.address) return false
        if (authorityId != other.authorityId) return false
        if (legalName != other.legalName) return false
        if (registrationId != other.registrationId) return false
        if (registrationType != other.registrationType) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The details of the address associated with the TRN information.
         */
        public var address: aws.sdk.kotlin.services.taxsettings.model.Address? = null
        /**
         * Unique authority ID for the supplemental TRN.
         */
        public var authorityId: kotlin.String? = null
        /**
         * The legal name associated with your TRN registration.
         */
        public var legalName: kotlin.String? = null
        /**
         * The supplemental TRN unique identifier.
         */
        public var registrationId: kotlin.String? = null
        /**
         * Type of supplemental TRN. Currently, this can only be VAT.
         */
        public var registrationType: aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistrationType? = null
        /**
         * The status of your TRN.
         */
        public var status: aws.sdk.kotlin.services.taxsettings.model.TaxRegistrationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistration) : this() {
            this.address = x.address
            this.authorityId = x.authorityId
            this.legalName = x.legalName
            this.registrationId = x.registrationId
            this.registrationType = x.registrationType
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistration = SupplementalTaxRegistration(this)

        /**
         * construct an [aws.sdk.kotlin.services.taxsettings.model.Address] inside the given [block]
         */
        public fun address(block: aws.sdk.kotlin.services.taxsettings.model.Address.Builder.() -> kotlin.Unit) {
            this.address = aws.sdk.kotlin.services.taxsettings.model.Address.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (authorityId == null) authorityId = ""
            if (legalName == null) legalName = ""
            if (registrationId == null) registrationId = ""
            if (registrationType == null) registrationType = SupplementalTaxRegistrationType.SdkUnknown("no value provided")
            if (status == null) status = TaxRegistrationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
