// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Additional tax information associated with your TRN in Malaysia.
 */
public class MalaysiaAdditionalInfo private constructor(builder: Builder) {
    /**
     * The tax registration number (TRN) in Malaysia.
     *
     * For individual, you can specify the `taxInformationNumber` in `MalaysiaAdditionalInfo` with NRIC type, and a valid MyKad or NRIC number. For business, you must specify a `businessRegistrationNumber` in `MalaysiaAdditionalInfo` with a TIN type and tax identification number. For business resellers, you must specify a `businessRegistrationNumber` and `taxInformationNumber` in `MalaysiaAdditionalInfo` with a sales and service tax (SST) type and a valid SST number.
     *
     * For business resellers with service codes, you must specify `businessRegistrationNumber`, `taxInformationNumber`, and distinct `serviceTaxCodes` in `MalaysiaAdditionalInfo` with a SST type and valid sales and service tax (SST) number. By using this API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
     */
    public val businessRegistrationNumber: kotlin.String? = builder.businessRegistrationNumber
    /**
     * List of service tax codes for your TRN in Malaysia.
     */
    public val serviceTaxCodes: List<MalaysiaServiceTaxCode> = builder.serviceTaxCodes
    /**
     * The tax information number in Malaysia.
     *
     * For individual, you can specify the `taxInformationNumber` in `MalaysiaAdditionalInfo` with NRIC type, and a valid MyKad or NRIC number. For business resellers, you must specify a `businessRegistrationNumber` and `taxInformationNumber` in `MalaysiaAdditionalInfo` with a sales and service tax (SST) type and a valid SST number.
     *
     * For business resellers with service codes, you must specify `businessRegistrationNumber`, `taxInformationNumber`, and distinct `serviceTaxCodes` in `MalaysiaAdditionalInfo` with a SST type and valid sales and service tax (SST) number. By using this API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
     */
    public val taxInformationNumber: kotlin.String? = builder.taxInformationNumber

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.taxsettings.model.MalaysiaAdditionalInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MalaysiaAdditionalInfo(")
        append("businessRegistrationNumber=$businessRegistrationNumber,")
        append("serviceTaxCodes=$serviceTaxCodes,")
        append("taxInformationNumber=$taxInformationNumber")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = businessRegistrationNumber?.hashCode() ?: 0
        result = 31 * result + (this.serviceTaxCodes.hashCode())
        result = 31 * result + (this.taxInformationNumber?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MalaysiaAdditionalInfo

        if (businessRegistrationNumber != other.businessRegistrationNumber) return false
        if (serviceTaxCodes != other.serviceTaxCodes) return false
        if (taxInformationNumber != other.taxInformationNumber) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.taxsettings.model.MalaysiaAdditionalInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The tax registration number (TRN) in Malaysia.
         *
         * For individual, you can specify the `taxInformationNumber` in `MalaysiaAdditionalInfo` with NRIC type, and a valid MyKad or NRIC number. For business, you must specify a `businessRegistrationNumber` in `MalaysiaAdditionalInfo` with a TIN type and tax identification number. For business resellers, you must specify a `businessRegistrationNumber` and `taxInformationNumber` in `MalaysiaAdditionalInfo` with a sales and service tax (SST) type and a valid SST number.
         *
         * For business resellers with service codes, you must specify `businessRegistrationNumber`, `taxInformationNumber`, and distinct `serviceTaxCodes` in `MalaysiaAdditionalInfo` with a SST type and valid sales and service tax (SST) number. By using this API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
         */
        public var businessRegistrationNumber: kotlin.String? = null
        /**
         * List of service tax codes for your TRN in Malaysia.
         */
        public var serviceTaxCodes: List<MalaysiaServiceTaxCode> = listOf()
        /**
         * The tax information number in Malaysia.
         *
         * For individual, you can specify the `taxInformationNumber` in `MalaysiaAdditionalInfo` with NRIC type, and a valid MyKad or NRIC number. For business resellers, you must specify a `businessRegistrationNumber` and `taxInformationNumber` in `MalaysiaAdditionalInfo` with a sales and service tax (SST) type and a valid SST number.
         *
         * For business resellers with service codes, you must specify `businessRegistrationNumber`, `taxInformationNumber`, and distinct `serviceTaxCodes` in `MalaysiaAdditionalInfo` with a SST type and valid sales and service tax (SST) number. By using this API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
         */
        public var taxInformationNumber: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.taxsettings.model.MalaysiaAdditionalInfo) : this() {
            this.businessRegistrationNumber = x.businessRegistrationNumber
            this.serviceTaxCodes = x.serviceTaxCodes
            this.taxInformationNumber = x.taxInformationNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.taxsettings.model.MalaysiaAdditionalInfo = MalaysiaAdditionalInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
