// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The location of the Amazon S3 bucket that you specify to download your tax documents to.
 */
public class DestinationS3Location private constructor(builder: Builder) {
    /**
     * The name of your Amazon S3 bucket that you specify to download your tax documents to.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * The Amazon S3 object prefix that you specify for your tax document file.
     */
    public val prefix: kotlin.String? = builder.prefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.taxsettings.model.DestinationS3Location = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DestinationS3Location(")
        append("bucket=$bucket,")
        append("prefix=$prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (this.prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DestinationS3Location

        if (bucket != other.bucket) return false
        if (prefix != other.prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.taxsettings.model.DestinationS3Location = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of your Amazon S3 bucket that you specify to download your tax documents to.
         */
        public var bucket: kotlin.String? = null
        /**
         * The Amazon S3 object prefix that you specify for your tax document file.
         */
        public var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.taxsettings.model.DestinationS3Location) : this() {
            this.bucket = x.bucket
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.taxsettings.model.DestinationS3Location = DestinationS3Location(this)

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            return this
        }
    }
}
