// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Additional tax information associated with your TRN in Canada .
 */
public class CanadaAdditionalInfo private constructor(builder: Builder) {
    /**
     * The Quebec Sales Tax ID number. Leave blank if you do not have a Quebec Sales Tax ID number.
     */
    public val canadaQuebecSalesTaxNumber: kotlin.String? = builder.canadaQuebecSalesTaxNumber
    /**
     * Manitoba Retail Sales Tax ID number. Customers purchasing Amazon Web Services services for resale in Manitoba must provide a valid Retail Sales Tax ID number for Manitoba. Leave this blank if you do not have a Retail Sales Tax ID number in Manitoba or are not purchasing Amazon Web Services services for resale.
     */
    public val canadaRetailSalesTaxNumber: kotlin.String? = builder.canadaRetailSalesTaxNumber
    /**
     * The value for this parameter must be `true` if the `provincialSalesTaxId` value is provided for a TRN in British Columbia, Saskatchewan, or Manitoba provinces.
     *
     * To claim a provincial sales tax (PST) and retail sales tax (RST) reseller exemption, you must confirm that purchases from this account were made for resale. Otherwise, remove the PST or RST number from the `provincialSalesTaxId` parameter from your request.
     */
    public val isResellerAccount: kotlin.Boolean? = builder.isResellerAccount
    /**
     * The provincial sales tax ID for your TRN in Canada. This parameter can represent the following:
     * + Provincial sales tax ID number for British Columbia and Saskatchewan provinces
     * + Manitoba retail sales tax ID number for Manitoba province
     * + Quebec sales tax ID number for Quebec province
     *
     * The Tax Setting API only accepts this parameter if the TRN is specified for the previous provinces. For other provinces, the Tax Settings API doesn't accept this parameter.
     */
    public val provincialSalesTaxId: kotlin.String? = builder.provincialSalesTaxId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.taxsettings.model.CanadaAdditionalInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CanadaAdditionalInfo(")
        append("canadaQuebecSalesTaxNumber=$canadaQuebecSalesTaxNumber,")
        append("canadaRetailSalesTaxNumber=$canadaRetailSalesTaxNumber,")
        append("isResellerAccount=$isResellerAccount,")
        append("provincialSalesTaxId=$provincialSalesTaxId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = canadaQuebecSalesTaxNumber?.hashCode() ?: 0
        result = 31 * result + (this.canadaRetailSalesTaxNumber?.hashCode() ?: 0)
        result = 31 * result + (this.isResellerAccount?.hashCode() ?: 0)
        result = 31 * result + (this.provincialSalesTaxId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CanadaAdditionalInfo

        if (canadaQuebecSalesTaxNumber != other.canadaQuebecSalesTaxNumber) return false
        if (canadaRetailSalesTaxNumber != other.canadaRetailSalesTaxNumber) return false
        if (isResellerAccount != other.isResellerAccount) return false
        if (provincialSalesTaxId != other.provincialSalesTaxId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.taxsettings.model.CanadaAdditionalInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Quebec Sales Tax ID number. Leave blank if you do not have a Quebec Sales Tax ID number.
         */
        public var canadaQuebecSalesTaxNumber: kotlin.String? = null
        /**
         * Manitoba Retail Sales Tax ID number. Customers purchasing Amazon Web Services services for resale in Manitoba must provide a valid Retail Sales Tax ID number for Manitoba. Leave this blank if you do not have a Retail Sales Tax ID number in Manitoba or are not purchasing Amazon Web Services services for resale.
         */
        public var canadaRetailSalesTaxNumber: kotlin.String? = null
        /**
         * The value for this parameter must be `true` if the `provincialSalesTaxId` value is provided for a TRN in British Columbia, Saskatchewan, or Manitoba provinces.
         *
         * To claim a provincial sales tax (PST) and retail sales tax (RST) reseller exemption, you must confirm that purchases from this account were made for resale. Otherwise, remove the PST or RST number from the `provincialSalesTaxId` parameter from your request.
         */
        public var isResellerAccount: kotlin.Boolean? = null
        /**
         * The provincial sales tax ID for your TRN in Canada. This parameter can represent the following:
         * + Provincial sales tax ID number for British Columbia and Saskatchewan provinces
         * + Manitoba retail sales tax ID number for Manitoba province
         * + Quebec sales tax ID number for Quebec province
         *
         * The Tax Setting API only accepts this parameter if the TRN is specified for the previous provinces. For other provinces, the Tax Settings API doesn't accept this parameter.
         */
        public var provincialSalesTaxId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.taxsettings.model.CanadaAdditionalInfo) : this() {
            this.canadaQuebecSalesTaxNumber = x.canadaQuebecSalesTaxNumber
            this.canadaRetailSalesTaxNumber = x.canadaRetailSalesTaxNumber
            this.isResellerAccount = x.isResellerAccount
            this.provincialSalesTaxId = x.provincialSalesTaxId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.taxsettings.model.CanadaAdditionalInfo = CanadaAdditionalInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
