// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The details of the address associated with the TRN information.
 */
public class Address private constructor(builder: Builder) {
    /**
     * The first line of the address.
     */
    public val addressLine1: kotlin.String = requireNotNull(builder.addressLine1) { "A non-null value must be provided for addressLine1" }
    /**
     * The second line of the address, if applicable.
     */
    public val addressLine2: kotlin.String? = builder.addressLine2
    /**
     * The third line of the address, if applicable. Currently, the Tax Settings API accepts the `addressLine3` parameter only for Saudi Arabia. When you specify a TRN in Saudi Arabia, you must enter the `addressLine3` and specify the building number for the address. For example, you might enter `1234`.
     */
    public val addressLine3: kotlin.String? = builder.addressLine3
    /**
     * The city that the address is in.
     */
    public val city: kotlin.String = requireNotNull(builder.city) { "A non-null value must be provided for city" }
    /**
     * The country code for the country that the address is in.
     */
    public val countryCode: kotlin.String = requireNotNull(builder.countryCode) { "A non-null value must be provided for countryCode" }
    /**
     * The district or county the address is located.
     *
     * For addresses in Brazil, this parameter uses the name of the neighborhood. When you set a TRN in Brazil, use `districtOrCounty` for the neighborhood name.
     */
    public val districtOrCounty: kotlin.String? = builder.districtOrCounty
    /**
     * The postal code associated with the address.
     */
    public val postalCode: kotlin.String = requireNotNull(builder.postalCode) { "A non-null value must be provided for postalCode" }
    /**
     * The state, region, or province that the address is located. This field is only required for Canada, India, United Arab Emirates, Romania, and Brazil (CPF). It is optional for all other countries.
     *
     * If this is required for tax settings, use the same name as shown on the **Tax Settings** page.
     */
    public val stateOrRegion: kotlin.String? = builder.stateOrRegion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.taxsettings.model.Address = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Address(")
        append("addressLine1=$addressLine1,")
        append("addressLine2=$addressLine2,")
        append("addressLine3=$addressLine3,")
        append("city=$city,")
        append("countryCode=$countryCode,")
        append("districtOrCounty=$districtOrCounty,")
        append("postalCode=$postalCode,")
        append("stateOrRegion=$stateOrRegion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressLine1.hashCode()
        result = 31 * result + (this.addressLine2?.hashCode() ?: 0)
        result = 31 * result + (this.addressLine3?.hashCode() ?: 0)
        result = 31 * result + (this.city.hashCode())
        result = 31 * result + (this.countryCode.hashCode())
        result = 31 * result + (this.districtOrCounty?.hashCode() ?: 0)
        result = 31 * result + (this.postalCode.hashCode())
        result = 31 * result + (this.stateOrRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Address

        if (addressLine1 != other.addressLine1) return false
        if (addressLine2 != other.addressLine2) return false
        if (addressLine3 != other.addressLine3) return false
        if (city != other.city) return false
        if (countryCode != other.countryCode) return false
        if (districtOrCounty != other.districtOrCounty) return false
        if (postalCode != other.postalCode) return false
        if (stateOrRegion != other.stateOrRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.taxsettings.model.Address = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The first line of the address.
         */
        public var addressLine1: kotlin.String? = null
        /**
         * The second line of the address, if applicable.
         */
        public var addressLine2: kotlin.String? = null
        /**
         * The third line of the address, if applicable. Currently, the Tax Settings API accepts the `addressLine3` parameter only for Saudi Arabia. When you specify a TRN in Saudi Arabia, you must enter the `addressLine3` and specify the building number for the address. For example, you might enter `1234`.
         */
        public var addressLine3: kotlin.String? = null
        /**
         * The city that the address is in.
         */
        public var city: kotlin.String? = null
        /**
         * The country code for the country that the address is in.
         */
        public var countryCode: kotlin.String? = null
        /**
         * The district or county the address is located.
         *
         * For addresses in Brazil, this parameter uses the name of the neighborhood. When you set a TRN in Brazil, use `districtOrCounty` for the neighborhood name.
         */
        public var districtOrCounty: kotlin.String? = null
        /**
         * The postal code associated with the address.
         */
        public var postalCode: kotlin.String? = null
        /**
         * The state, region, or province that the address is located. This field is only required for Canada, India, United Arab Emirates, Romania, and Brazil (CPF). It is optional for all other countries.
         *
         * If this is required for tax settings, use the same name as shown on the **Tax Settings** page.
         */
        public var stateOrRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.taxsettings.model.Address) : this() {
            this.addressLine1 = x.addressLine1
            this.addressLine2 = x.addressLine2
            this.addressLine3 = x.addressLine3
            this.city = x.city
            this.countryCode = x.countryCode
            this.districtOrCounty = x.districtOrCounty
            this.postalCode = x.postalCode
            this.stateOrRegion = x.stateOrRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.taxsettings.model.Address = Address(this)

        internal fun correctErrors(): Builder {
            if (addressLine1 == null) addressLine1 = ""
            if (city == null) city = ""
            if (countryCode == null) countryCode = ""
            if (postalCode == null) postalCode = ""
            return this
        }
    }
}
