// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings

import aws.sdk.kotlin.runtime.auth.credentials.StaticCredentialsProvider
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.AwsBusinessMetric
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.taxsettings.auth.TaxSettingsAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.taxsettings.auth.TaxSettingsIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.taxsettings.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.taxsettings.model.*
import aws.sdk.kotlin.services.taxsettings.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.businessmetrics.emitBusinessMetric
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultTaxSettingsClient(override val config: TaxSettingsClient.Config) : TaxSettingsClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = TaxSettingsIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "tax")
        }
        toMap()
    }
    private val authSchemeAdapter = TaxSettingsAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.taxsettings"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Deletes tax registration for multiple accounts in batch. This can be used to delete tax registrations for up to five accounts in one batch.
     *
     * This API operation can't be used to delete your tax registration in Brazil. Use the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console instead.
     */
    override suspend fun batchDeleteTaxRegistration(input: BatchDeleteTaxRegistrationRequest): BatchDeleteTaxRegistrationResponse {
        val op = SdkHttpOperation.build<BatchDeleteTaxRegistrationRequest, BatchDeleteTaxRegistrationResponse> {
            serializeWith = BatchDeleteTaxRegistrationOperationSerializer()
            deserializeWith = BatchDeleteTaxRegistrationOperationDeserializer()
            operationName = "BatchDeleteTaxRegistration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the active tax exemptions for a given list of accounts. The IAM action is `tax:GetExemptions`.
     */
    override suspend fun batchGetTaxExemptions(input: BatchGetTaxExemptionsRequest): BatchGetTaxExemptionsResponse {
        val op = SdkHttpOperation.build<BatchGetTaxExemptionsRequest, BatchGetTaxExemptionsResponse> {
            serializeWith = BatchGetTaxExemptionsOperationSerializer()
            deserializeWith = BatchGetTaxExemptionsOperationDeserializer()
            operationName = "BatchGetTaxExemptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates tax registration for multiple accounts in batch. This can be used to add or update tax registrations for up to five accounts in one batch. You can't set a TRN if there's a pending TRN. You'll need to delete the pending TRN first.
     *
     * To call this API operation for specific countries, see the following country-specific requirements.
     *
     * **Bangladesh**
     * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Brazil**
     * + You must complete the tax registration process in the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call this API operation.
     * + For Amazon Web Services accounts created through Organizations, you can call this API operation when you don't have a billing address.
     *
     * **Georgia**
     * + The valid `personType` values are `Physical Person` and `Business`.
     *
     * **Indonesia**
     * + `PutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022.
     * + `BatchPutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022, through our third-party partner PT Achilles Advanced Management (OnlinePajak).
     * + You must specify the `taxRegistrationNumberType` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If you specify `decisionNumber`, you must specify the `ppnExceptionDesignationCode` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object. If the `taxRegistrationNumberType` is set to NPWP or NITKU, valid values for `ppnExceptionDesignationCode` are either `01`, `02`, `03`, `07`, or `08`.For other `taxRegistrationNumberType` values, `ppnExceptionDesignationCode` must be either `01`, `07`, or `08`.
     * + If `ppnExceptionDesignationCode` is `07`, you must specify the `decisionNumber` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
     *
     * **Kenya**
     * + You must specify the `personType` in the `kenyaAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If the `personType` is `Physical Person`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Malaysia**
     * + The sector valid values are `Business` and `Individual`.
     * + `RegistrationType` valid values are `NRIC` for individual, and TIN and sales and service tax (SST) for Business.
     * + For individual, you can specify the `taxInformationNumber` in `MalaysiaAdditionalInfo` with NRIC type, and a valid `MyKad` or NRIC number.
     * + For business, you must specify a `businessRegistrationNumber` in `MalaysiaAdditionalInfo` with a TIN type and tax identification number.
     * + For business resellers, you must specify a `businessRegistrationNumber` and `taxInformationNumber` in `MalaysiaAdditionalInfo` with a sales and service tax (SST) type and a valid SST number.
     * + For business resellers with service codes, you must specify `businessRegistrationNumber`, `taxInformationNumber`, and distinct `serviceTaxCodes` in `MalaysiaAdditionalInfo` with a SST type and valid sales and service tax (SST) number. By using this API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
     * + Amazon Web Services reserves the right to seek additional information and/or take other actions to support your self-declaration as appropriate.
     * + Amazon Web Services is currently registered under the following service tax codes. You must include at least one of the service tax codes in the service tax code strings to declare yourself as an authorized registered business reseller.Taxable service and service tax codes:Consultancy - 9907061674Training or coaching service - 9907071685IT service - 9907101676Digital services and electronic medium - 9907121690
     *
     * **Nepal**
     * + The sector valid values are `Business` and `Individual`.
     *
     * **Saudi Arabia**
     * + For `address`, you must specify `addressLine3`.
     *
     * **South Korea**
     * + You must specify the `certifiedEmailId` and `legalName` in the `TaxRegistrationEntry` object. Use Korean characters for `legalName`.
     * + You must specify the `businessRepresentativeName`, `itemOfBusiness`, and `lineOfBusiness` in the `southKoreaAdditionalInfo` field of the `additionalTaxInformation` object. Use Korean characters for these fields.
     * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     * + For the `address` object, use Korean characters for `addressLine1`, `addressLine2``city`, `postalCode`, and `stateOrRegion`.
     *
     * **Spain**
     * + You must specify the `registrationType` in the `spainAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If the `registrationType` is `Local`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Turkey**
     * + You must specify the `sector` in the `taxRegistrationEntry` object.
     * + If your `sector` is `Business`, `Individual`, or `Government`:
     *    + Specify the `taxOffice`. If your `sector` is `Individual`, don't enter this value.
     *    + (Optional) Specify the `kepEmailId`. If your `sector` is `Individual`, don't enter this value.
     *    + **Note:** In the **Tax Settings** page of the Billing console, `Government` appears as **Public institutions**
     * + If your `sector` is `Business` and you're subject to KDV tax, you must specify your industry in the `industries` field.
     * + For `address`, you must specify `districtOrCounty`.
     *
     * **Ukraine**
     * + The sector valid values are `Business` and `Individual`.
     */
    override suspend fun batchPutTaxRegistration(input: BatchPutTaxRegistrationRequest): BatchPutTaxRegistrationResponse {
        val op = SdkHttpOperation.build<BatchPutTaxRegistrationRequest, BatchPutTaxRegistrationResponse> {
            serializeWith = BatchPutTaxRegistrationOperationSerializer()
            deserializeWith = BatchPutTaxRegistrationOperationDeserializer()
            operationName = "BatchPutTaxRegistration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a supplemental tax registration for a single account.
     */
    override suspend fun deleteSupplementalTaxRegistration(input: DeleteSupplementalTaxRegistrationRequest): DeleteSupplementalTaxRegistrationResponse {
        val op = SdkHttpOperation.build<DeleteSupplementalTaxRegistrationRequest, DeleteSupplementalTaxRegistrationResponse> {
            serializeWith = DeleteSupplementalTaxRegistrationOperationSerializer()
            deserializeWith = DeleteSupplementalTaxRegistrationOperationDeserializer()
            operationName = "DeleteSupplementalTaxRegistration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes tax registration for a single account.
     *
     * This API operation can't be used to delete your tax registration in Brazil. Use the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console instead.
     */
    override suspend fun deleteTaxRegistration(input: DeleteTaxRegistrationRequest): DeleteTaxRegistrationResponse {
        val op = SdkHttpOperation.build<DeleteTaxRegistrationRequest, DeleteTaxRegistrationResponse> {
            serializeWith = DeleteTaxRegistrationOperationSerializer()
            deserializeWith = DeleteTaxRegistrationOperationDeserializer()
            operationName = "DeleteTaxRegistration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get supported tax exemption types. The IAM action is `tax:GetExemptions`.
     */
    override suspend fun getTaxExemptionTypes(input: GetTaxExemptionTypesRequest): GetTaxExemptionTypesResponse {
        val op = SdkHttpOperation.build<GetTaxExemptionTypesRequest, GetTaxExemptionTypesResponse> {
            serializeWith = GetTaxExemptionTypesOperationSerializer()
            deserializeWith = GetTaxExemptionTypesOperationDeserializer()
            operationName = "GetTaxExemptionTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The get account tax inheritance status.
     */
    override suspend fun getTaxInheritance(input: GetTaxInheritanceRequest): GetTaxInheritanceResponse {
        val op = SdkHttpOperation.build<GetTaxInheritanceRequest, GetTaxInheritanceResponse> {
            serializeWith = GetTaxInheritanceOperationSerializer()
            deserializeWith = GetTaxInheritanceOperationDeserializer()
            operationName = "GetTaxInheritance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves tax registration for a single account.
     */
    override suspend fun getTaxRegistration(input: GetTaxRegistrationRequest): GetTaxRegistrationResponse {
        val op = SdkHttpOperation.build<GetTaxRegistrationRequest, GetTaxRegistrationResponse> {
            serializeWith = GetTaxRegistrationOperationSerializer()
            deserializeWith = GetTaxRegistrationOperationDeserializer()
            operationName = "GetTaxRegistration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Downloads your tax documents to the Amazon S3 bucket that you specify in your request.
     */
    override suspend fun getTaxRegistrationDocument(input: GetTaxRegistrationDocumentRequest): GetTaxRegistrationDocumentResponse {
        val op = SdkHttpOperation.build<GetTaxRegistrationDocumentRequest, GetTaxRegistrationDocumentResponse> {
            serializeWith = GetTaxRegistrationDocumentOperationSerializer()
            deserializeWith = GetTaxRegistrationDocumentOperationDeserializer()
            operationName = "GetTaxRegistrationDocument"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves supplemental tax registrations for a single account.
     */
    override suspend fun listSupplementalTaxRegistrations(input: ListSupplementalTaxRegistrationsRequest): ListSupplementalTaxRegistrationsResponse {
        val op = SdkHttpOperation.build<ListSupplementalTaxRegistrationsRequest, ListSupplementalTaxRegistrationsResponse> {
            serializeWith = ListSupplementalTaxRegistrationsOperationSerializer()
            deserializeWith = ListSupplementalTaxRegistrationsOperationDeserializer()
            operationName = "ListSupplementalTaxRegistrations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the tax exemption of accounts listed in a consolidated billing family. The IAM action is `tax:GetExemptions`.
     */
    override suspend fun listTaxExemptions(input: ListTaxExemptionsRequest): ListTaxExemptionsResponse {
        val op = SdkHttpOperation.build<ListTaxExemptionsRequest, ListTaxExemptionsResponse> {
            serializeWith = ListTaxExemptionsOperationSerializer()
            deserializeWith = ListTaxExemptionsOperationDeserializer()
            operationName = "ListTaxExemptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the tax registration of accounts listed in a consolidated billing family. This can be used to retrieve up to 100 accounts' tax registrations in one call (default 50).
     */
    override suspend fun listTaxRegistrations(input: ListTaxRegistrationsRequest): ListTaxRegistrationsResponse {
        val op = SdkHttpOperation.build<ListTaxRegistrationsRequest, ListTaxRegistrationsResponse> {
            serializeWith = ListTaxRegistrationsOperationSerializer()
            deserializeWith = ListTaxRegistrationsOperationDeserializer()
            operationName = "ListTaxRegistrations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stores supplemental tax registration for a single account.
     */
    override suspend fun putSupplementalTaxRegistration(input: PutSupplementalTaxRegistrationRequest): PutSupplementalTaxRegistrationResponse {
        val op = SdkHttpOperation.build<PutSupplementalTaxRegistrationRequest, PutSupplementalTaxRegistrationResponse> {
            serializeWith = PutSupplementalTaxRegistrationOperationSerializer()
            deserializeWith = PutSupplementalTaxRegistrationOperationDeserializer()
            operationName = "PutSupplementalTaxRegistration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds the tax exemption for a single account or all accounts listed in a consolidated billing family. The IAM action is `tax:UpdateExemptions`.
     */
    override suspend fun putTaxExemption(input: PutTaxExemptionRequest): PutTaxExemptionResponse {
        val op = SdkHttpOperation.build<PutTaxExemptionRequest, PutTaxExemptionResponse> {
            serializeWith = PutTaxExemptionOperationSerializer()
            deserializeWith = PutTaxExemptionOperationDeserializer()
            operationName = "PutTaxExemption"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The updated tax inheritance status.
     */
    override suspend fun putTaxInheritance(input: PutTaxInheritanceRequest): PutTaxInheritanceResponse {
        val op = SdkHttpOperation.build<PutTaxInheritanceRequest, PutTaxInheritanceResponse> {
            serializeWith = PutTaxInheritanceOperationSerializer()
            deserializeWith = PutTaxInheritanceOperationDeserializer()
            operationName = "PutTaxInheritance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates tax registration for a single account. You can't set a TRN if there's a pending TRN. You'll need to delete the pending TRN first.
     *
     * To call this API operation for specific countries, see the following country-specific requirements.
     *
     * **Bangladesh**
     * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Brazil**
     * + You must complete the tax registration process in the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call this API operation.
     * + For Amazon Web Services accounts created through Organizations, you can call this API operation when you don't have a billing address.
     *
     * **Georgia**
     * + The valid `personType` values are `Physical Person` and `Business`.
     *
     * **Indonesia**
     * + `PutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022.
     * + `BatchPutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022, through our third-party partner PT Achilles Advanced Management (OnlinePajak).
     * + You must specify the `taxRegistrationNumberType` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If you specify `decisionNumber`, you must specify the `ppnExceptionDesignationCode` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object. If the `taxRegistrationNumberType` is set to NPWP or NITKU, valid values for `ppnExceptionDesignationCode` are either `01`, `02`, `03`, `07`, or `08`.For other `taxRegistrationNumberType` values, `ppnExceptionDesignationCode` must be either `01`, `07`, or `08`.
     * + If `ppnExceptionDesignationCode` is `07`, you must specify the `decisionNumber` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
     *
     * **Kenya**
     * + You must specify the `personType` in the `kenyaAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If the `personType` is `Physical Person`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Malaysia**
     * + The sector valid values are `Business` and `Individual`.
     * + `RegistrationType` valid values are `NRIC` for individual, and TIN and sales and service tax (SST) for Business.
     * + For individual, you can specify the `taxInformationNumber` in `MalaysiaAdditionalInfo` with NRIC type, and a valid `MyKad` or NRIC number.
     * + For business, you must specify a `businessRegistrationNumber` in `MalaysiaAdditionalInfo` with a TIN type and tax identification number.
     * + For business resellers, you must specify a `businessRegistrationNumber` and `taxInformationNumber` in `MalaysiaAdditionalInfo` with a sales and service tax (SST) type and a valid SST number.
     * + For business resellers with service codes, you must specify `businessRegistrationNumber`, `taxInformationNumber`, and distinct `serviceTaxCodes` in `MalaysiaAdditionalInfo` with a SST type and valid sales and service tax (SST) number. By using this API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
     * + Amazon Web Services reserves the right to seek additional information and/or take other actions to support your self-declaration as appropriate.
     * + Amazon Web Services is currently registered under the following service tax codes. You must include at least one of the service tax codes in the service tax code strings to declare yourself as an authorized registered business reseller.Taxable service and service tax codes:Consultancy - 9907061674Training or coaching service - 9907071685IT service - 9907101676Digital services and electronic medium - 9907121690
     *
     * **Nepal**
     * + The sector valid values are `Business` and `Individual`.
     *
     * **Saudi Arabia**
     * + For `address`, you must specify `addressLine3`.
     *
     * **South Korea**
     * + You must specify the `certifiedEmailId` and `legalName` in the `TaxRegistrationEntry` object. Use Korean characters for `legalName`.
     * + You must specify the `businessRepresentativeName`, `itemOfBusiness`, and `lineOfBusiness` in the `southKoreaAdditionalInfo` field of the `additionalTaxInformation` object. Use Korean characters for these fields.
     * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     * + For the `address` object, use Korean characters for `addressLine1`, `addressLine2``city`, `postalCode`, and `stateOrRegion`.
     *
     * **Spain**
     * + You must specify the `registrationType` in the `spainAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If the `registrationType` is `Local`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Turkey**
     * + You must specify the `sector` in the `taxRegistrationEntry` object.
     * + If your `sector` is `Business`, `Individual`, or `Government`:
     *    + Specify the `taxOffice`. If your `sector` is `Individual`, don't enter this value.
     *    + (Optional) Specify the `kepEmailId`. If your `sector` is `Individual`, don't enter this value.
     *    + **Note:** In the **Tax Settings** page of the Billing console, `Government` appears as **Public institutions**
     * + If your `sector` is `Business` and you're subject to KDV tax, you must specify your industry in the `industries` field.
     * + For `address`, you must specify `districtOrCounty`.
     *
     * **Ukraine**
     * + The sector valid values are `Business` and `Individual`.
     */
    override suspend fun putTaxRegistration(input: PutTaxRegistrationRequest): PutTaxRegistrationResponse {
        val op = SdkHttpOperation.build<PutTaxRegistrationRequest, PutTaxRegistrationResponse> {
            serializeWith = PutTaxRegistrationOperationSerializer()
            deserializeWith = PutTaxRegistrationOperationDeserializer()
            operationName = "PutTaxRegistration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsentNotNull(HttpOperationContext.AttemptTimeout, config.attemptTimeout)
        ctx.putIfAbsentNotNull(HttpOperationContext.CallTimeout, config.callTimeout)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "tax")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
