// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.serde

import aws.sdk.kotlin.services.taxsettings.model.BatchGetTaxExemptionsResponse
import aws.sdk.kotlin.services.taxsettings.model.TaxExemptionDetails
import aws.sdk.kotlin.services.taxsettings.model.TaxSettingsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class BatchGetTaxExemptionsOperationDeserializer: HttpDeserializer.NonStreaming<BatchGetTaxExemptionsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchGetTaxExemptionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetTaxExemptionsError(context, call, payload)
        }
        val builder = BatchGetTaxExemptionsResponse.Builder()

        if (payload != null) {
            deserializeBatchGetTaxExemptionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchGetTaxExemptionsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TaxSettingsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TaxSettingsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetTaxExemptionsOperationBody(builder: BatchGetTaxExemptionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDACCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failedAccounts"))
    val TAXEXEMPTIONDETAILSMAP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("taxExemptionDetailsMap"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDACCOUNTS_DESCRIPTOR)
        field(TAXEXEMPTIONDETAILSMAP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDACCOUNTS_DESCRIPTOR.index -> builder.failedAccounts =
                    deserializer.deserializeList(FAILEDACCOUNTS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAXEXEMPTIONDETAILSMAP_DESCRIPTOR.index -> builder.taxExemptionDetailsMap =
                    deserializer.deserializeMap(TAXEXEMPTIONDETAILSMAP_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, TaxExemptionDetails>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeTaxExemptionDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
