// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.taxsettings.auth.DefaultTaxSettingsAuthSchemeProvider
import aws.sdk.kotlin.services.taxsettings.auth.TaxSettingsAuthSchemeProvider
import aws.sdk.kotlin.services.taxsettings.endpoints.DefaultTaxSettingsEndpointProvider
import aws.sdk.kotlin.services.taxsettings.endpoints.TaxSettingsEndpointParameters
import aws.sdk.kotlin.services.taxsettings.endpoints.TaxSettingsEndpointProvider
import aws.sdk.kotlin.services.taxsettings.model.BatchDeleteTaxRegistrationRequest
import aws.sdk.kotlin.services.taxsettings.model.BatchDeleteTaxRegistrationResponse
import aws.sdk.kotlin.services.taxsettings.model.BatchGetTaxExemptionsRequest
import aws.sdk.kotlin.services.taxsettings.model.BatchGetTaxExemptionsResponse
import aws.sdk.kotlin.services.taxsettings.model.BatchPutTaxRegistrationRequest
import aws.sdk.kotlin.services.taxsettings.model.BatchPutTaxRegistrationResponse
import aws.sdk.kotlin.services.taxsettings.model.DeleteSupplementalTaxRegistrationRequest
import aws.sdk.kotlin.services.taxsettings.model.DeleteSupplementalTaxRegistrationResponse
import aws.sdk.kotlin.services.taxsettings.model.DeleteTaxRegistrationRequest
import aws.sdk.kotlin.services.taxsettings.model.DeleteTaxRegistrationResponse
import aws.sdk.kotlin.services.taxsettings.model.GetTaxExemptionTypesRequest
import aws.sdk.kotlin.services.taxsettings.model.GetTaxExemptionTypesResponse
import aws.sdk.kotlin.services.taxsettings.model.GetTaxInheritanceRequest
import aws.sdk.kotlin.services.taxsettings.model.GetTaxInheritanceResponse
import aws.sdk.kotlin.services.taxsettings.model.GetTaxRegistrationDocumentRequest
import aws.sdk.kotlin.services.taxsettings.model.GetTaxRegistrationDocumentResponse
import aws.sdk.kotlin.services.taxsettings.model.GetTaxRegistrationRequest
import aws.sdk.kotlin.services.taxsettings.model.GetTaxRegistrationResponse
import aws.sdk.kotlin.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest
import aws.sdk.kotlin.services.taxsettings.model.ListSupplementalTaxRegistrationsResponse
import aws.sdk.kotlin.services.taxsettings.model.ListTaxExemptionsRequest
import aws.sdk.kotlin.services.taxsettings.model.ListTaxExemptionsResponse
import aws.sdk.kotlin.services.taxsettings.model.ListTaxRegistrationsRequest
import aws.sdk.kotlin.services.taxsettings.model.ListTaxRegistrationsResponse
import aws.sdk.kotlin.services.taxsettings.model.PutSupplementalTaxRegistrationRequest
import aws.sdk.kotlin.services.taxsettings.model.PutSupplementalTaxRegistrationResponse
import aws.sdk.kotlin.services.taxsettings.model.PutTaxExemptionRequest
import aws.sdk.kotlin.services.taxsettings.model.PutTaxExemptionResponse
import aws.sdk.kotlin.services.taxsettings.model.PutTaxInheritanceRequest
import aws.sdk.kotlin.services.taxsettings.model.PutTaxInheritanceResponse
import aws.sdk.kotlin.services.taxsettings.model.PutTaxRegistrationRequest
import aws.sdk.kotlin.services.taxsettings.model.PutTaxRegistrationResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "TaxSettings"
public const val SdkVersion: String = "1.5.45"
public const val ServiceApiVersion: String = "2018-05-10"

/**
 * You can use the tax setting API to programmatically set, modify, and delete the tax registration number (TRN), associated business legal name, and address (Collectively referred to as "TRN information"). You can also programmatically view TRN information and tax addresses ("Tax profiles").
 *
 * You can use this API to automate your TRN information settings instead of manually using the console.
 *
 * Service Endpoint
 * + https://tax.us-east-1.amazonaws.com
 */
public interface TaxSettingsClient : SdkClient {
    /**
     * TaxSettingsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, TaxSettingsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "TaxSettings",
                "TAXSETTINGS",
                "taxsettings",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, TaxSettingsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): TaxSettingsClient = DefaultTaxSettingsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: TaxSettingsEndpointProvider = builder.endpointProvider ?: DefaultTaxSettingsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: TaxSettingsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultTaxSettingsAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "TaxSettings"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: TaxSettingsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: TaxSettingsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes tax registration for multiple accounts in batch. This can be used to delete tax registrations for up to five accounts in one batch.
     *
     * This API operation can't be used to delete your tax registration in Brazil. Use the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console instead.
     */
    public suspend fun batchDeleteTaxRegistration(input: BatchDeleteTaxRegistrationRequest): BatchDeleteTaxRegistrationResponse

    /**
     * Get the active tax exemptions for a given list of accounts. The IAM action is `tax:GetExemptions`.
     */
    public suspend fun batchGetTaxExemptions(input: BatchGetTaxExemptionsRequest): BatchGetTaxExemptionsResponse

    /**
     * Adds or updates tax registration for multiple accounts in batch. This can be used to add or update tax registrations for up to five accounts in one batch. You can't set a TRN if there's a pending TRN. You'll need to delete the pending TRN first.
     *
     * To call this API operation for specific countries, see the following country-specific requirements.
     *
     * **Bangladesh**
     * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Brazil**
     * + You must complete the tax registration process in the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call this API operation.
     * + For Amazon Web Services accounts created through Organizations, you can call this API operation when you don't have a billing address.
     *
     * **Georgia**
     * + The valid `personType` values are `Physical Person` and `Business`.
     *
     * **Indonesia**
     * + `PutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022.
     * + `BatchPutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022, through our third-party partner PT Achilles Advanced Management (OnlinePajak).
     * + You must specify the `taxRegistrationNumberType` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If you specify `decisionNumber`, you must specify the `ppnExceptionDesignationCode` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object. If the `taxRegistrationNumberType` is set to NPWP or NITKU, valid values for `ppnExceptionDesignationCode` are either `01`, `02`, `03`, `07`, or `08`.For other `taxRegistrationNumberType` values, `ppnExceptionDesignationCode` must be either `01`, `07`, or `08`.
     * + If `ppnExceptionDesignationCode` is `07`, you must specify the `decisionNumber` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
     *
     * **Kenya**
     * + You must specify the `personType` in the `kenyaAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If the `personType` is `Physical Person`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Malaysia**
     * + The sector valid values are `Business` and `Individual`.
     * + `RegistrationType` valid values are `NRIC` for individual, and TIN and sales and service tax (SST) for Business.
     * + For individual, you can specify the `taxInformationNumber` in `MalaysiaAdditionalInfo` with NRIC type, and a valid `MyKad` or NRIC number.
     * + For business, you must specify a `businessRegistrationNumber` in `MalaysiaAdditionalInfo` with a TIN type and tax identification number.
     * + For business resellers, you must specify a `businessRegistrationNumber` and `taxInformationNumber` in `MalaysiaAdditionalInfo` with a sales and service tax (SST) type and a valid SST number.
     * + For business resellers with service codes, you must specify `businessRegistrationNumber`, `taxInformationNumber`, and distinct `serviceTaxCodes` in `MalaysiaAdditionalInfo` with a SST type and valid sales and service tax (SST) number. By using this API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
     * + Amazon Web Services reserves the right to seek additional information and/or take other actions to support your self-declaration as appropriate.
     * + Amazon Web Services is currently registered under the following service tax codes. You must include at least one of the service tax codes in the service tax code strings to declare yourself as an authorized registered business reseller.Taxable service and service tax codes:Consultancy - 9907061674Training or coaching service - 9907071685IT service - 9907101676Digital services and electronic medium - 9907121690
     *
     * **Nepal**
     * + The sector valid values are `Business` and `Individual`.
     *
     * **Saudi Arabia**
     * + For `address`, you must specify `addressLine3`.
     *
     * **South Korea**
     * + You must specify the `certifiedEmailId` and `legalName` in the `TaxRegistrationEntry` object. Use Korean characters for `legalName`.
     * + You must specify the `businessRepresentativeName`, `itemOfBusiness`, and `lineOfBusiness` in the `southKoreaAdditionalInfo` field of the `additionalTaxInformation` object. Use Korean characters for these fields.
     * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     * + For the `address` object, use Korean characters for `addressLine1`, `addressLine2``city`, `postalCode`, and `stateOrRegion`.
     *
     * **Spain**
     * + You must specify the `registrationType` in the `spainAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If the `registrationType` is `Local`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Turkey**
     * + You must specify the `sector` in the `taxRegistrationEntry` object.
     * + If your `sector` is `Business`, `Individual`, or `Government`:
     *    + Specify the `taxOffice`. If your `sector` is `Individual`, don't enter this value.
     *    + (Optional) Specify the `kepEmailId`. If your `sector` is `Individual`, don't enter this value.
     *    + **Note:** In the **Tax Settings** page of the Billing console, `Government` appears as **Public institutions**
     * + If your `sector` is `Business` and you're subject to KDV tax, you must specify your industry in the `industries` field.
     * + For `address`, you must specify `districtOrCounty`.
     *
     * **Ukraine**
     * + The sector valid values are `Business` and `Individual`.
     */
    public suspend fun batchPutTaxRegistration(input: BatchPutTaxRegistrationRequest): BatchPutTaxRegistrationResponse

    /**
     * Deletes a supplemental tax registration for a single account.
     */
    public suspend fun deleteSupplementalTaxRegistration(input: DeleteSupplementalTaxRegistrationRequest): DeleteSupplementalTaxRegistrationResponse

    /**
     * Deletes tax registration for a single account.
     *
     * This API operation can't be used to delete your tax registration in Brazil. Use the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console instead.
     */
    public suspend fun deleteTaxRegistration(input: DeleteTaxRegistrationRequest = DeleteTaxRegistrationRequest { }): DeleteTaxRegistrationResponse

    /**
     * Get supported tax exemption types. The IAM action is `tax:GetExemptions`.
     */
    public suspend fun getTaxExemptionTypes(input: GetTaxExemptionTypesRequest = GetTaxExemptionTypesRequest { }): GetTaxExemptionTypesResponse

    /**
     * The get account tax inheritance status.
     */
    public suspend fun getTaxInheritance(input: GetTaxInheritanceRequest = GetTaxInheritanceRequest { }): GetTaxInheritanceResponse

    /**
     * Retrieves tax registration for a single account.
     */
    public suspend fun getTaxRegistration(input: GetTaxRegistrationRequest = GetTaxRegistrationRequest { }): GetTaxRegistrationResponse

    /**
     * Downloads your tax documents to the Amazon S3 bucket that you specify in your request.
     */
    public suspend fun getTaxRegistrationDocument(input: GetTaxRegistrationDocumentRequest): GetTaxRegistrationDocumentResponse

    /**
     * Retrieves supplemental tax registrations for a single account.
     */
    public suspend fun listSupplementalTaxRegistrations(input: ListSupplementalTaxRegistrationsRequest = ListSupplementalTaxRegistrationsRequest { }): ListSupplementalTaxRegistrationsResponse

    /**
     * Retrieves the tax exemption of accounts listed in a consolidated billing family. The IAM action is `tax:GetExemptions`.
     */
    public suspend fun listTaxExemptions(input: ListTaxExemptionsRequest = ListTaxExemptionsRequest { }): ListTaxExemptionsResponse

    /**
     * Retrieves the tax registration of accounts listed in a consolidated billing family. This can be used to retrieve up to 100 accounts' tax registrations in one call (default 50).
     */
    public suspend fun listTaxRegistrations(input: ListTaxRegistrationsRequest = ListTaxRegistrationsRequest { }): ListTaxRegistrationsResponse

    /**
     * Stores supplemental tax registration for a single account.
     */
    public suspend fun putSupplementalTaxRegistration(input: PutSupplementalTaxRegistrationRequest): PutSupplementalTaxRegistrationResponse

    /**
     * Adds the tax exemption for a single account or all accounts listed in a consolidated billing family. The IAM action is `tax:UpdateExemptions`.
     */
    public suspend fun putTaxExemption(input: PutTaxExemptionRequest): PutTaxExemptionResponse

    /**
     * The updated tax inheritance status.
     */
    public suspend fun putTaxInheritance(input: PutTaxInheritanceRequest = PutTaxInheritanceRequest { }): PutTaxInheritanceResponse

    /**
     * Adds or updates tax registration for a single account. You can't set a TRN if there's a pending TRN. You'll need to delete the pending TRN first.
     *
     * To call this API operation for specific countries, see the following country-specific requirements.
     *
     * **Bangladesh**
     * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Brazil**
     * + You must complete the tax registration process in the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call this API operation.
     * + For Amazon Web Services accounts created through Organizations, you can call this API operation when you don't have a billing address.
     *
     * **Georgia**
     * + The valid `personType` values are `Physical Person` and `Business`.
     *
     * **Indonesia**
     * + `PutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022.
     * + `BatchPutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022, through our third-party partner PT Achilles Advanced Management (OnlinePajak).
     * + You must specify the `taxRegistrationNumberType` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If you specify `decisionNumber`, you must specify the `ppnExceptionDesignationCode` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object. If the `taxRegistrationNumberType` is set to NPWP or NITKU, valid values for `ppnExceptionDesignationCode` are either `01`, `02`, `03`, `07`, or `08`.For other `taxRegistrationNumberType` values, `ppnExceptionDesignationCode` must be either `01`, `07`, or `08`.
     * + If `ppnExceptionDesignationCode` is `07`, you must specify the `decisionNumber` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
     *
     * **Kenya**
     * + You must specify the `personType` in the `kenyaAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If the `personType` is `Physical Person`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Malaysia**
     * + The sector valid values are `Business` and `Individual`.
     * + `RegistrationType` valid values are `NRIC` for individual, and TIN and sales and service tax (SST) for Business.
     * + For individual, you can specify the `taxInformationNumber` in `MalaysiaAdditionalInfo` with NRIC type, and a valid `MyKad` or NRIC number.
     * + For business, you must specify a `businessRegistrationNumber` in `MalaysiaAdditionalInfo` with a TIN type and tax identification number.
     * + For business resellers, you must specify a `businessRegistrationNumber` and `taxInformationNumber` in `MalaysiaAdditionalInfo` with a sales and service tax (SST) type and a valid SST number.
     * + For business resellers with service codes, you must specify `businessRegistrationNumber`, `taxInformationNumber`, and distinct `serviceTaxCodes` in `MalaysiaAdditionalInfo` with a SST type and valid sales and service tax (SST) number. By using this API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
     * + Amazon Web Services reserves the right to seek additional information and/or take other actions to support your self-declaration as appropriate.
     * + Amazon Web Services is currently registered under the following service tax codes. You must include at least one of the service tax codes in the service tax code strings to declare yourself as an authorized registered business reseller.Taxable service and service tax codes:Consultancy - 9907061674Training or coaching service - 9907071685IT service - 9907101676Digital services and electronic medium - 9907121690
     *
     * **Nepal**
     * + The sector valid values are `Business` and `Individual`.
     *
     * **Saudi Arabia**
     * + For `address`, you must specify `addressLine3`.
     *
     * **South Korea**
     * + You must specify the `certifiedEmailId` and `legalName` in the `TaxRegistrationEntry` object. Use Korean characters for `legalName`.
     * + You must specify the `businessRepresentativeName`, `itemOfBusiness`, and `lineOfBusiness` in the `southKoreaAdditionalInfo` field of the `additionalTaxInformation` object. Use Korean characters for these fields.
     * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     * + For the `address` object, use Korean characters for `addressLine1`, `addressLine2``city`, `postalCode`, and `stateOrRegion`.
     *
     * **Spain**
     * + You must specify the `registrationType` in the `spainAdditionalInfo` field of the `additionalTaxInformation` object.
     * + If the `registrationType` is `Local`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
     *
     * **Turkey**
     * + You must specify the `sector` in the `taxRegistrationEntry` object.
     * + If your `sector` is `Business`, `Individual`, or `Government`:
     *    + Specify the `taxOffice`. If your `sector` is `Individual`, don't enter this value.
     *    + (Optional) Specify the `kepEmailId`. If your `sector` is `Individual`, don't enter this value.
     *    + **Note:** In the **Tax Settings** page of the Billing console, `Government` appears as **Public institutions**
     * + If your `sector` is `Business` and you're subject to KDV tax, you must specify your industry in the `industries` field.
     * + For `address`, you must specify `districtOrCounty`.
     *
     * **Ukraine**
     * + The sector valid values are `Business` and `Individual`.
     */
    public suspend fun putTaxRegistration(input: PutTaxRegistrationRequest): PutTaxRegistrationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun TaxSettingsClient.withConfig(block: TaxSettingsClient.Config.Builder.() -> Unit): TaxSettingsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultTaxSettingsClient(newConfig)
}

/**
 * Deletes tax registration for multiple accounts in batch. This can be used to delete tax registrations for up to five accounts in one batch.
 *
 * This API operation can't be used to delete your tax registration in Brazil. Use the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console instead.
 */
public suspend inline fun TaxSettingsClient.batchDeleteTaxRegistration(crossinline block: BatchDeleteTaxRegistrationRequest.Builder.() -> Unit): BatchDeleteTaxRegistrationResponse = batchDeleteTaxRegistration(BatchDeleteTaxRegistrationRequest.Builder().apply(block).build())

/**
 * Get the active tax exemptions for a given list of accounts. The IAM action is `tax:GetExemptions`.
 */
public suspend inline fun TaxSettingsClient.batchGetTaxExemptions(crossinline block: BatchGetTaxExemptionsRequest.Builder.() -> Unit): BatchGetTaxExemptionsResponse = batchGetTaxExemptions(BatchGetTaxExemptionsRequest.Builder().apply(block).build())

/**
 * Adds or updates tax registration for multiple accounts in batch. This can be used to add or update tax registrations for up to five accounts in one batch. You can't set a TRN if there's a pending TRN. You'll need to delete the pending TRN first.
 *
 * To call this API operation for specific countries, see the following country-specific requirements.
 *
 * **Bangladesh**
 * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
 *
 * **Brazil**
 * + You must complete the tax registration process in the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call this API operation.
 * + For Amazon Web Services accounts created through Organizations, you can call this API operation when you don't have a billing address.
 *
 * **Georgia**
 * + The valid `personType` values are `Physical Person` and `Business`.
 *
 * **Indonesia**
 * + `PutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022.
 * + `BatchPutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022, through our third-party partner PT Achilles Advanced Management (OnlinePajak).
 * + You must specify the `taxRegistrationNumberType` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
 * + If you specify `decisionNumber`, you must specify the `ppnExceptionDesignationCode` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object. If the `taxRegistrationNumberType` is set to NPWP or NITKU, valid values for `ppnExceptionDesignationCode` are either `01`, `02`, `03`, `07`, or `08`.For other `taxRegistrationNumberType` values, `ppnExceptionDesignationCode` must be either `01`, `07`, or `08`.
 * + If `ppnExceptionDesignationCode` is `07`, you must specify the `decisionNumber` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
 *
 * **Kenya**
 * + You must specify the `personType` in the `kenyaAdditionalInfo` field of the `additionalTaxInformation` object.
 * + If the `personType` is `Physical Person`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
 *
 * **Malaysia**
 * + The sector valid values are `Business` and `Individual`.
 * + `RegistrationType` valid values are `NRIC` for individual, and TIN and sales and service tax (SST) for Business.
 * + For individual, you can specify the `taxInformationNumber` in `MalaysiaAdditionalInfo` with NRIC type, and a valid `MyKad` or NRIC number.
 * + For business, you must specify a `businessRegistrationNumber` in `MalaysiaAdditionalInfo` with a TIN type and tax identification number.
 * + For business resellers, you must specify a `businessRegistrationNumber` and `taxInformationNumber` in `MalaysiaAdditionalInfo` with a sales and service tax (SST) type and a valid SST number.
 * + For business resellers with service codes, you must specify `businessRegistrationNumber`, `taxInformationNumber`, and distinct `serviceTaxCodes` in `MalaysiaAdditionalInfo` with a SST type and valid sales and service tax (SST) number. By using this API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
 * + Amazon Web Services reserves the right to seek additional information and/or take other actions to support your self-declaration as appropriate.
 * + Amazon Web Services is currently registered under the following service tax codes. You must include at least one of the service tax codes in the service tax code strings to declare yourself as an authorized registered business reseller.Taxable service and service tax codes:Consultancy - 9907061674Training or coaching service - 9907071685IT service - 9907101676Digital services and electronic medium - 9907121690
 *
 * **Nepal**
 * + The sector valid values are `Business` and `Individual`.
 *
 * **Saudi Arabia**
 * + For `address`, you must specify `addressLine3`.
 *
 * **South Korea**
 * + You must specify the `certifiedEmailId` and `legalName` in the `TaxRegistrationEntry` object. Use Korean characters for `legalName`.
 * + You must specify the `businessRepresentativeName`, `itemOfBusiness`, and `lineOfBusiness` in the `southKoreaAdditionalInfo` field of the `additionalTaxInformation` object. Use Korean characters for these fields.
 * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
 * + For the `address` object, use Korean characters for `addressLine1`, `addressLine2``city`, `postalCode`, and `stateOrRegion`.
 *
 * **Spain**
 * + You must specify the `registrationType` in the `spainAdditionalInfo` field of the `additionalTaxInformation` object.
 * + If the `registrationType` is `Local`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
 *
 * **Turkey**
 * + You must specify the `sector` in the `taxRegistrationEntry` object.
 * + If your `sector` is `Business`, `Individual`, or `Government`:
 *    + Specify the `taxOffice`. If your `sector` is `Individual`, don't enter this value.
 *    + (Optional) Specify the `kepEmailId`. If your `sector` is `Individual`, don't enter this value.
 *    + **Note:** In the **Tax Settings** page of the Billing console, `Government` appears as **Public institutions**
 * + If your `sector` is `Business` and you're subject to KDV tax, you must specify your industry in the `industries` field.
 * + For `address`, you must specify `districtOrCounty`.
 *
 * **Ukraine**
 * + The sector valid values are `Business` and `Individual`.
 */
public suspend inline fun TaxSettingsClient.batchPutTaxRegistration(crossinline block: BatchPutTaxRegistrationRequest.Builder.() -> Unit): BatchPutTaxRegistrationResponse = batchPutTaxRegistration(BatchPutTaxRegistrationRequest.Builder().apply(block).build())

/**
 * Deletes a supplemental tax registration for a single account.
 */
public suspend inline fun TaxSettingsClient.deleteSupplementalTaxRegistration(crossinline block: DeleteSupplementalTaxRegistrationRequest.Builder.() -> Unit): DeleteSupplementalTaxRegistrationResponse = deleteSupplementalTaxRegistration(DeleteSupplementalTaxRegistrationRequest.Builder().apply(block).build())

/**
 * Deletes tax registration for a single account.
 *
 * This API operation can't be used to delete your tax registration in Brazil. Use the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console instead.
 */
public suspend inline fun TaxSettingsClient.deleteTaxRegistration(crossinline block: DeleteTaxRegistrationRequest.Builder.() -> Unit): DeleteTaxRegistrationResponse = deleteTaxRegistration(DeleteTaxRegistrationRequest.Builder().apply(block).build())

/**
 * Get supported tax exemption types. The IAM action is `tax:GetExemptions`.
 */
public suspend inline fun TaxSettingsClient.getTaxExemptionTypes(crossinline block: GetTaxExemptionTypesRequest.Builder.() -> Unit): GetTaxExemptionTypesResponse = getTaxExemptionTypes(GetTaxExemptionTypesRequest.Builder().apply(block).build())

/**
 * The get account tax inheritance status.
 */
public suspend inline fun TaxSettingsClient.getTaxInheritance(crossinline block: GetTaxInheritanceRequest.Builder.() -> Unit): GetTaxInheritanceResponse = getTaxInheritance(GetTaxInheritanceRequest.Builder().apply(block).build())

/**
 * Retrieves tax registration for a single account.
 */
public suspend inline fun TaxSettingsClient.getTaxRegistration(crossinline block: GetTaxRegistrationRequest.Builder.() -> Unit): GetTaxRegistrationResponse = getTaxRegistration(GetTaxRegistrationRequest.Builder().apply(block).build())

/**
 * Downloads your tax documents to the Amazon S3 bucket that you specify in your request.
 */
public suspend inline fun TaxSettingsClient.getTaxRegistrationDocument(crossinline block: GetTaxRegistrationDocumentRequest.Builder.() -> Unit): GetTaxRegistrationDocumentResponse = getTaxRegistrationDocument(GetTaxRegistrationDocumentRequest.Builder().apply(block).build())

/**
 * Retrieves supplemental tax registrations for a single account.
 */
public suspend inline fun TaxSettingsClient.listSupplementalTaxRegistrations(crossinline block: ListSupplementalTaxRegistrationsRequest.Builder.() -> Unit): ListSupplementalTaxRegistrationsResponse = listSupplementalTaxRegistrations(ListSupplementalTaxRegistrationsRequest.Builder().apply(block).build())

/**
 * Retrieves the tax exemption of accounts listed in a consolidated billing family. The IAM action is `tax:GetExemptions`.
 */
public suspend inline fun TaxSettingsClient.listTaxExemptions(crossinline block: ListTaxExemptionsRequest.Builder.() -> Unit): ListTaxExemptionsResponse = listTaxExemptions(ListTaxExemptionsRequest.Builder().apply(block).build())

/**
 * Retrieves the tax registration of accounts listed in a consolidated billing family. This can be used to retrieve up to 100 accounts' tax registrations in one call (default 50).
 */
public suspend inline fun TaxSettingsClient.listTaxRegistrations(crossinline block: ListTaxRegistrationsRequest.Builder.() -> Unit): ListTaxRegistrationsResponse = listTaxRegistrations(ListTaxRegistrationsRequest.Builder().apply(block).build())

/**
 * Stores supplemental tax registration for a single account.
 */
public suspend inline fun TaxSettingsClient.putSupplementalTaxRegistration(crossinline block: PutSupplementalTaxRegistrationRequest.Builder.() -> Unit): PutSupplementalTaxRegistrationResponse = putSupplementalTaxRegistration(PutSupplementalTaxRegistrationRequest.Builder().apply(block).build())

/**
 * Adds the tax exemption for a single account or all accounts listed in a consolidated billing family. The IAM action is `tax:UpdateExemptions`.
 */
public suspend inline fun TaxSettingsClient.putTaxExemption(crossinline block: PutTaxExemptionRequest.Builder.() -> Unit): PutTaxExemptionResponse = putTaxExemption(PutTaxExemptionRequest.Builder().apply(block).build())

/**
 * The updated tax inheritance status.
 */
public suspend inline fun TaxSettingsClient.putTaxInheritance(crossinline block: PutTaxInheritanceRequest.Builder.() -> Unit): PutTaxInheritanceResponse = putTaxInheritance(PutTaxInheritanceRequest.Builder().apply(block).build())

/**
 * Adds or updates tax registration for a single account. You can't set a TRN if there's a pending TRN. You'll need to delete the pending TRN first.
 *
 * To call this API operation for specific countries, see the following country-specific requirements.
 *
 * **Bangladesh**
 * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
 *
 * **Brazil**
 * + You must complete the tax registration process in the [Payment preferences](https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods) page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call this API operation.
 * + For Amazon Web Services accounts created through Organizations, you can call this API operation when you don't have a billing address.
 *
 * **Georgia**
 * + The valid `personType` values are `Physical Person` and `Business`.
 *
 * **Indonesia**
 * + `PutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022.
 * + `BatchPutTaxRegistration`: The use of this operation to submit tax information is subject to the [Amazon Web Services service terms](http://aws.amazon.com/service-terms/). By submitting, you’re providing consent for Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with the Directorate General of Taxes of Indonesia in accordance with the Minister of Finance Regulation (PMK) Number 112/PMK.03/2022, through our third-party partner PT Achilles Advanced Management (OnlinePajak).
 * + You must specify the `taxRegistrationNumberType` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
 * + If you specify `decisionNumber`, you must specify the `ppnExceptionDesignationCode` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object. If the `taxRegistrationNumberType` is set to NPWP or NITKU, valid values for `ppnExceptionDesignationCode` are either `01`, `02`, `03`, `07`, or `08`.For other `taxRegistrationNumberType` values, `ppnExceptionDesignationCode` must be either `01`, `07`, or `08`.
 * + If `ppnExceptionDesignationCode` is `07`, you must specify the `decisionNumber` in the `indonesiaAdditionalInfo` field of the `additionalTaxInformation` object.
 *
 * **Kenya**
 * + You must specify the `personType` in the `kenyaAdditionalInfo` field of the `additionalTaxInformation` object.
 * + If the `personType` is `Physical Person`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
 *
 * **Malaysia**
 * + The sector valid values are `Business` and `Individual`.
 * + `RegistrationType` valid values are `NRIC` for individual, and TIN and sales and service tax (SST) for Business.
 * + For individual, you can specify the `taxInformationNumber` in `MalaysiaAdditionalInfo` with NRIC type, and a valid `MyKad` or NRIC number.
 * + For business, you must specify a `businessRegistrationNumber` in `MalaysiaAdditionalInfo` with a TIN type and tax identification number.
 * + For business resellers, you must specify a `businessRegistrationNumber` and `taxInformationNumber` in `MalaysiaAdditionalInfo` with a sales and service tax (SST) type and a valid SST number.
 * + For business resellers with service codes, you must specify `businessRegistrationNumber`, `taxInformationNumber`, and distinct `serviceTaxCodes` in `MalaysiaAdditionalInfo` with a SST type and valid sales and service tax (SST) number. By using this API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
 * + Amazon Web Services reserves the right to seek additional information and/or take other actions to support your self-declaration as appropriate.
 * + Amazon Web Services is currently registered under the following service tax codes. You must include at least one of the service tax codes in the service tax code strings to declare yourself as an authorized registered business reseller.Taxable service and service tax codes:Consultancy - 9907061674Training or coaching service - 9907071685IT service - 9907101676Digital services and electronic medium - 9907121690
 *
 * **Nepal**
 * + The sector valid values are `Business` and `Individual`.
 *
 * **Saudi Arabia**
 * + For `address`, you must specify `addressLine3`.
 *
 * **South Korea**
 * + You must specify the `certifiedEmailId` and `legalName` in the `TaxRegistrationEntry` object. Use Korean characters for `legalName`.
 * + You must specify the `businessRepresentativeName`, `itemOfBusiness`, and `lineOfBusiness` in the `southKoreaAdditionalInfo` field of the `additionalTaxInformation` object. Use Korean characters for these fields.
 * + You must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
 * + For the `address` object, use Korean characters for `addressLine1`, `addressLine2``city`, `postalCode`, and `stateOrRegion`.
 *
 * **Spain**
 * + You must specify the `registrationType` in the `spainAdditionalInfo` field of the `additionalTaxInformation` object.
 * + If the `registrationType` is `Local`, you must specify the tax registration certificate document in the `taxRegistrationDocuments` field of the `VerificationDetails` object.
 *
 * **Turkey**
 * + You must specify the `sector` in the `taxRegistrationEntry` object.
 * + If your `sector` is `Business`, `Individual`, or `Government`:
 *    + Specify the `taxOffice`. If your `sector` is `Individual`, don't enter this value.
 *    + (Optional) Specify the `kepEmailId`. If your `sector` is `Individual`, don't enter this value.
 *    + **Note:** In the **Tax Settings** page of the Billing console, `Government` appears as **Public institutions**
 * + If your `sector` is `Business` and you're subject to KDV tax, you must specify your industry in the `industries` field.
 * + For `address`, you must specify `districtOrCounty`.
 *
 * **Ukraine**
 * + The sector valid values are `Business` and `Individual`.
 */
public suspend inline fun TaxSettingsClient.putTaxRegistration(crossinline block: PutTaxRegistrationRequest.Builder.() -> Unit): PutTaxRegistrationResponse = putTaxRegistration(PutTaxRegistrationRequest.Builder().apply(block).build())
