// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.serde

import aws.sdk.kotlin.services.taxsettings.model.GetTaxRegistrationDocumentResponse
import aws.sdk.kotlin.services.taxsettings.model.TaxSettingsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetTaxRegistrationDocumentOperationDeserializer: HttpDeserializer.NonStreaming<GetTaxRegistrationDocumentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTaxRegistrationDocumentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTaxRegistrationDocumentError(context, call, payload)
        }
        val builder = GetTaxRegistrationDocumentResponse.Builder()

        if (payload != null) {
            deserializeGetTaxRegistrationDocumentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTaxRegistrationDocumentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TaxSettingsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TaxSettingsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTaxRegistrationDocumentOperationBody(builder: GetTaxRegistrationDocumentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESTINATIONFILEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("destinationFilePath"))
    val PRESIGNEDS3URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("presignedS3Url"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESTINATIONFILEPATH_DESCRIPTOR)
        field(PRESIGNEDS3URL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESTINATIONFILEPATH_DESCRIPTOR.index -> builder.destinationFilePath = deserializeString()
                PRESIGNEDS3URL_DESCRIPTOR.index -> builder.presignedS3Url = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
