// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.taxsettings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The supplemental TRN information to provide when adding or updating a supplemental TRN.
 */
public class SupplementalTaxRegistrationEntry private constructor(builder: Builder) {
    /**
     * The details of the address associated with the TRN information.
     */
    public val address: aws.sdk.kotlin.services.taxsettings.model.Address? = builder.address
    /**
     * The legal name associated with your TRN registration.
     */
    public val legalName: kotlin.String = requireNotNull(builder.legalName) { "A non-null value must be provided for legalName" }
    /**
     * The supplemental TRN unique identifier.
     */
    public val registrationId: kotlin.String = requireNotNull(builder.registrationId) { "A non-null value must be provided for registrationId" }
    /**
     * Type of supplemental TRN. Currently, this can only be VAT.
     */
    public val registrationType: aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistrationType = requireNotNull(builder.registrationType) { "A non-null value must be provided for registrationType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistrationEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SupplementalTaxRegistrationEntry(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (legalName.hashCode())
        result = 31 * result + (registrationId.hashCode())
        result = 31 * result + (registrationType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SupplementalTaxRegistrationEntry

        if (address != other.address) return false
        if (legalName != other.legalName) return false
        if (registrationId != other.registrationId) return false
        if (registrationType != other.registrationType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistrationEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The details of the address associated with the TRN information.
         */
        public var address: aws.sdk.kotlin.services.taxsettings.model.Address? = null
        /**
         * The legal name associated with your TRN registration.
         */
        public var legalName: kotlin.String? = null
        /**
         * The supplemental TRN unique identifier.
         */
        public var registrationId: kotlin.String? = null
        /**
         * Type of supplemental TRN. Currently, this can only be VAT.
         */
        public var registrationType: aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistrationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistrationEntry) : this() {
            this.address = x.address
            this.legalName = x.legalName
            this.registrationId = x.registrationId
            this.registrationType = x.registrationType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.taxsettings.model.SupplementalTaxRegistrationEntry = SupplementalTaxRegistrationEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.taxsettings.model.Address] inside the given [block]
         */
        public fun address(block: aws.sdk.kotlin.services.taxsettings.model.Address.Builder.() -> kotlin.Unit) {
            this.address = aws.sdk.kotlin.services.taxsettings.model.Address.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (legalName == null) legalName = ""
            if (registrationId == null) registrationId = ""
            if (registrationType == null) registrationType = SupplementalTaxRegistrationType.SdkUnknown("no value provided")
            return this
        }
    }
}
