// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * If this canary is to test an endpoint in a VPC, this structure contains information about the subnets and security groups of the VPC endpoint. For more information, see [ Running a Canary in a VPC](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
 */
public class VpcConfigOutput private constructor(builder: Builder) {
    /**
     * The IDs of the security groups for this canary.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The IDs of the subnets where this canary is to run.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The IDs of the VPC where this canary is to run.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.VpcConfigOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConfigOutput(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds?.hashCode() ?: 0
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConfigOutput

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.VpcConfigOutput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The IDs of the security groups for this canary.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The IDs of the subnets where this canary is to run.
         */
        public var subnetIds: List<String>? = null
        /**
         * The IDs of the VPC where this canary is to run.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.VpcConfigOutput) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.VpcConfigOutput = VpcConfigOutput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
