// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run that is used as the baseline for screenshots, and the coordinates of any parts of those screenshots that are ignored during visual monitoring comparison.
 *
 * Visual monitoring is supported only on canaries running the **syn-puppeteer-node-3.2** runtime or later.
 */
public class VisualReferenceOutput private constructor(builder: Builder) {
    /**
     * The ID of the canary run that produced the baseline screenshots that are used for visual monitoring comparisons by this canary.
     */
    public val baseCanaryRunId: kotlin.String? = builder.baseCanaryRunId
    /**
     * An array of screenshots that are used as the baseline for comparisons during visual monitoring.
     */
    public val baseScreenshots: List<BaseScreenshot>? = builder.baseScreenshots

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.VisualReferenceOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VisualReferenceOutput(")
        append("baseCanaryRunId=$baseCanaryRunId,")
        append("baseScreenshots=$baseScreenshots")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseCanaryRunId?.hashCode() ?: 0
        result = 31 * result + (baseScreenshots?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VisualReferenceOutput

        if (baseCanaryRunId != other.baseCanaryRunId) return false
        if (baseScreenshots != other.baseScreenshots) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.VisualReferenceOutput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the canary run that produced the baseline screenshots that are used for visual monitoring comparisons by this canary.
         */
        public var baseCanaryRunId: kotlin.String? = null
        /**
         * An array of screenshots that are used as the baseline for comparisons during visual monitoring.
         */
        public var baseScreenshots: List<BaseScreenshot>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.VisualReferenceOutput) : this() {
            this.baseCanaryRunId = x.baseCanaryRunId
            this.baseScreenshots = x.baseScreenshots
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.VisualReferenceOutput = VisualReferenceOutput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
