// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that specifies what screenshots to use as a baseline for visual monitoring by this canary. It can optionally also specify parts of the screenshots to ignore during the visual monitoring comparison.
 *
 * Visual monitoring is supported only on canaries running the **syn-puppeteer-node-3.2** runtime or later. For more information, see [ Visual monitoring](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html) and [ Visual monitoring blueprint](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html)
 */
public class VisualReferenceInput private constructor(builder: Builder) {
    /**
     * Specifies which canary run to use the screenshots from as the baseline for future visual monitoring with this canary. Valid values are `nextrun` to use the screenshots from the next run after this update is made, `lastrun` to use the screenshots from the most recent run before this update was made, or the value of `Id` in the [ CanaryRun](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html) from any past run of this canary.
     */
    public val baseCanaryRunId: kotlin.String = requireNotNull(builder.baseCanaryRunId) { "A non-null value must be provided for baseCanaryRunId" }
    /**
     * An array of screenshots that will be used as the baseline for visual monitoring in future runs of this canary. If there is a screenshot that you don't want to be used for visual monitoring, remove it from this array.
     */
    public val baseScreenshots: List<BaseScreenshot>? = builder.baseScreenshots

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.VisualReferenceInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VisualReferenceInput(")
        append("baseCanaryRunId=$baseCanaryRunId,")
        append("baseScreenshots=$baseScreenshots")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseCanaryRunId.hashCode()
        result = 31 * result + (baseScreenshots?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VisualReferenceInput

        if (baseCanaryRunId != other.baseCanaryRunId) return false
        if (baseScreenshots != other.baseScreenshots) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.VisualReferenceInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies which canary run to use the screenshots from as the baseline for future visual monitoring with this canary. Valid values are `nextrun` to use the screenshots from the next run after this update is made, `lastrun` to use the screenshots from the most recent run before this update was made, or the value of `Id` in the [ CanaryRun](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html) from any past run of this canary.
         */
        public var baseCanaryRunId: kotlin.String? = null
        /**
         * An array of screenshots that will be used as the baseline for visual monitoring in future runs of this canary. If there is a screenshot that you don't want to be used for visual monitoring, remove it from this array.
         */
        public var baseScreenshots: List<BaseScreenshot>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.VisualReferenceInput) : this() {
            this.baseCanaryRunId = x.baseCanaryRunId
            this.baseScreenshots = x.baseScreenshots
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.VisualReferenceInput = VisualReferenceInput(this)

        internal fun correctErrors(): Builder {
            if (baseCanaryRunId == null) baseCanaryRunId = ""
            return this
        }
    }
}
