// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that contains the configuration of encryption-at-rest settings for canary artifacts that the canary uploads to Amazon S3.
 *
 * For more information, see [Encrypting canary artifacts](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html)
 */
public class S3EncryptionConfig private constructor(builder: Builder) {
    /**
     * The encryption method to use for artifacts created by this canary. Specify `SSE_S3` to use server-side encryption (SSE) with an Amazon S3-managed key. Specify `SSE-KMS` to use server-side encryption with a customer-managed KMS key.
     *
     * If you omit this parameter, an Amazon Web Services-managed KMS key is used.
     */
    public val encryptionMode: aws.sdk.kotlin.services.synthetics.model.EncryptionMode? = builder.encryptionMode
    /**
     * The ARN of the customer-managed KMS key to use, if you specify `SSE-KMS` for `EncryptionMode`
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.S3EncryptionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3EncryptionConfig(")
        append("encryptionMode=$encryptionMode,")
        append("kmsKeyArn=$kmsKeyArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionMode?.hashCode() ?: 0
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3EncryptionConfig

        if (encryptionMode != other.encryptionMode) return false
        if (kmsKeyArn != other.kmsKeyArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.S3EncryptionConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The encryption method to use for artifacts created by this canary. Specify `SSE_S3` to use server-side encryption (SSE) with an Amazon S3-managed key. Specify `SSE-KMS` to use server-side encryption with a customer-managed KMS key.
         *
         * If you omit this parameter, an Amazon Web Services-managed KMS key is used.
         */
        public var encryptionMode: aws.sdk.kotlin.services.synthetics.model.EncryptionMode? = null
        /**
         * The ARN of the customer-managed KMS key to use, if you specify `SSE-KMS` for `EncryptionMode`
         */
        public var kmsKeyArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.S3EncryptionConfig) : this() {
            this.encryptionMode = x.encryptionMode
            this.kmsKeyArn = x.kmsKeyArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.S3EncryptionConfig = S3EncryptionConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
