// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateCanaryRequest private constructor(builder: Builder) {
    /**
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
     */
    public val artifactConfig: aws.sdk.kotlin.services.synthetics.model.ArtifactConfigInput? = builder.artifactConfig
    /**
     * The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary. Artifacts include the log file, screenshots, and HAR files. The name of the S3 bucket can't include a period (.).
     */
    public val artifactS3Location: kotlin.String? = builder.artifactS3Location
    /**
     * A structure that includes the entry point from which the canary should start running your script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included.
     */
    public val code: aws.sdk.kotlin.services.synthetics.model.CanaryCodeInput? = builder.code
    /**
     * The ARN of the IAM role to be used to run the canary. This role must already exist, and must include `lambda.amazonaws.com` as a principal in the trust policy. The role must also have the following permissions:
     * + `s3:PutObject`
     * + `s3:GetBucketLocation`
     * + `s3:ListAllMyBuckets`
     * + `cloudwatch:PutMetricData`
     * + `logs:CreateLogGroup`
     * + `logs:CreateLogStream`
     * + `logs:PutLogEvents`
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    public val failureRetentionPeriodInDays: kotlin.Int? = builder.failureRetentionPeriodInDays
    /**
     * The name for this canary. Be sure to give it a descriptive name that distinguishes it from other canaries in your account.
     *
     * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the canary ARN, and the ARN is included in outbound calls over the internet. For more information, see [Security Considerations for Synthetics Canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html).
     */
    public val name: kotlin.String? = builder.name
    /**
     * To have the tags that you apply to this canary also be applied to the Lambda function that the canary uses, specify this parameter with the value `lambda-function`.
     *
     * If you specify this parameter and don't specify any tags in the `Tags` parameter, the canary creation fails.
     */
    public val resourcesToReplicateTags: List<ResourceToTag>? = builder.resourcesToReplicateTags
    /**
     * A structure that contains the configuration for individual canary runs, such as timeout value and environment variables.
     *
     * The environment variables keys and values are not encrypted. Do not store sensitive information in this field.
     */
    public val runConfig: aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigInput? = builder.runConfig
    /**
     * Specifies the runtime version to use for the canary. For a list of valid runtime versions and more information about runtime versions, see [ Canary Runtime Versions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
     */
    public val runtimeVersion: kotlin.String? = builder.runtimeVersion
    /**
     * A structure that contains information about how often the canary is to run and when these test runs are to stop.
     */
    public val schedule: aws.sdk.kotlin.services.synthetics.model.CanaryScheduleInput? = builder.schedule
    /**
     * The number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    public val successRetentionPeriodInDays: kotlin.Int? = builder.successRetentionPeriodInDays
    /**
     * A list of key-value pairs to associate with the canary. You can associate as many as 50 tags with a canary.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only the resources that have certain tag values.
     *
     * To have the tags that you apply to this canary also be applied to the Lambda function that the canary uses, specify this parameter with the value `lambda-function`.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint. For more information, see [ Running a Canary in a VPC](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.synthetics.model.VpcConfigInput? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.CreateCanaryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCanaryRequest(")
        append("artifactConfig=$artifactConfig,")
        append("artifactS3Location=$artifactS3Location,")
        append("code=$code,")
        append("executionRoleArn=$executionRoleArn,")
        append("failureRetentionPeriodInDays=$failureRetentionPeriodInDays,")
        append("name=$name,")
        append("resourcesToReplicateTags=$resourcesToReplicateTags,")
        append("runConfig=$runConfig,")
        append("runtimeVersion=$runtimeVersion,")
        append("schedule=$schedule,")
        append("successRetentionPeriodInDays=$successRetentionPeriodInDays,")
        append("tags=$tags,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactConfig?.hashCode() ?: 0
        result = 31 * result + (artifactS3Location?.hashCode() ?: 0)
        result = 31 * result + (code?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (failureRetentionPeriodInDays ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourcesToReplicateTags?.hashCode() ?: 0)
        result = 31 * result + (runConfig?.hashCode() ?: 0)
        result = 31 * result + (runtimeVersion?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (successRetentionPeriodInDays ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCanaryRequest

        if (artifactConfig != other.artifactConfig) return false
        if (artifactS3Location != other.artifactS3Location) return false
        if (code != other.code) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (failureRetentionPeriodInDays != other.failureRetentionPeriodInDays) return false
        if (name != other.name) return false
        if (resourcesToReplicateTags != other.resourcesToReplicateTags) return false
        if (runConfig != other.runConfig) return false
        if (runtimeVersion != other.runtimeVersion) return false
        if (schedule != other.schedule) return false
        if (successRetentionPeriodInDays != other.successRetentionPeriodInDays) return false
        if (tags != other.tags) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.CreateCanaryRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
         */
        public var artifactConfig: aws.sdk.kotlin.services.synthetics.model.ArtifactConfigInput? = null
        /**
         * The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary. Artifacts include the log file, screenshots, and HAR files. The name of the S3 bucket can't include a period (.).
         */
        public var artifactS3Location: kotlin.String? = null
        /**
         * A structure that includes the entry point from which the canary should start running your script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included.
         */
        public var code: aws.sdk.kotlin.services.synthetics.model.CanaryCodeInput? = null
        /**
         * The ARN of the IAM role to be used to run the canary. This role must already exist, and must include `lambda.amazonaws.com` as a principal in the trust policy. The role must also have the following permissions:
         * + `s3:PutObject`
         * + `s3:GetBucketLocation`
         * + `s3:ListAllMyBuckets`
         * + `cloudwatch:PutMetricData`
         * + `logs:CreateLogGroup`
         * + `logs:CreateLogStream`
         * + `logs:PutLogEvents`
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
         */
        public var failureRetentionPeriodInDays: kotlin.Int? = null
        /**
         * The name for this canary. Be sure to give it a descriptive name that distinguishes it from other canaries in your account.
         *
         * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the canary ARN, and the ARN is included in outbound calls over the internet. For more information, see [Security Considerations for Synthetics Canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html).
         */
        public var name: kotlin.String? = null
        /**
         * To have the tags that you apply to this canary also be applied to the Lambda function that the canary uses, specify this parameter with the value `lambda-function`.
         *
         * If you specify this parameter and don't specify any tags in the `Tags` parameter, the canary creation fails.
         */
        public var resourcesToReplicateTags: List<ResourceToTag>? = null
        /**
         * A structure that contains the configuration for individual canary runs, such as timeout value and environment variables.
         *
         * The environment variables keys and values are not encrypted. Do not store sensitive information in this field.
         */
        public var runConfig: aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigInput? = null
        /**
         * Specifies the runtime version to use for the canary. For a list of valid runtime versions and more information about runtime versions, see [ Canary Runtime Versions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
         */
        public var runtimeVersion: kotlin.String? = null
        /**
         * A structure that contains information about how often the canary is to run and when these test runs are to stop.
         */
        public var schedule: aws.sdk.kotlin.services.synthetics.model.CanaryScheduleInput? = null
        /**
         * The number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
         */
        public var successRetentionPeriodInDays: kotlin.Int? = null
        /**
         * A list of key-value pairs to associate with the canary. You can associate as many as 50 tags with a canary.
         *
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only the resources that have certain tag values.
         *
         * To have the tags that you apply to this canary also be applied to the Lambda function that the canary uses, specify this parameter with the value `lambda-function`.
         */
        public var tags: Map<String, String>? = null
        /**
         * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint. For more information, see [ Running a Canary in a VPC](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.synthetics.model.VpcConfigInput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.CreateCanaryRequest) : this() {
            this.artifactConfig = x.artifactConfig
            this.artifactS3Location = x.artifactS3Location
            this.code = x.code
            this.executionRoleArn = x.executionRoleArn
            this.failureRetentionPeriodInDays = x.failureRetentionPeriodInDays
            this.name = x.name
            this.resourcesToReplicateTags = x.resourcesToReplicateTags
            this.runConfig = x.runConfig
            this.runtimeVersion = x.runtimeVersion
            this.schedule = x.schedule
            this.successRetentionPeriodInDays = x.successRetentionPeriodInDays
            this.tags = x.tags
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.CreateCanaryRequest = CreateCanaryRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.ArtifactConfigInput] inside the given [block]
         */
        public fun artifactConfig(block: aws.sdk.kotlin.services.synthetics.model.ArtifactConfigInput.Builder.() -> kotlin.Unit) {
            this.artifactConfig = aws.sdk.kotlin.services.synthetics.model.ArtifactConfigInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.CanaryCodeInput] inside the given [block]
         */
        public fun code(block: aws.sdk.kotlin.services.synthetics.model.CanaryCodeInput.Builder.() -> kotlin.Unit) {
            this.code = aws.sdk.kotlin.services.synthetics.model.CanaryCodeInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigInput] inside the given [block]
         */
        public fun runConfig(block: aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigInput.Builder.() -> kotlin.Unit) {
            this.runConfig = aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.CanaryScheduleInput] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.synthetics.model.CanaryScheduleInput.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.synthetics.model.CanaryScheduleInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.VpcConfigInput] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.synthetics.model.VpcConfigInput.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.synthetics.model.VpcConfigInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
