// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that contains information about a canary run.
 */
public class CanaryRunConfigOutput private constructor(builder: Builder) {
    /**
     * Displays whether this canary run used active X-Ray tracing.
     */
    public val activeTracing: kotlin.Boolean? = builder.activeTracing
    /**
     * The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.
     */
    public val memoryInMb: kotlin.Int? = builder.memoryInMb
    /**
     * How long the canary is allowed to run before it must stop.
     */
    public val timeoutInSeconds: kotlin.Int? = builder.timeoutInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CanaryRunConfigOutput(")
        append("activeTracing=$activeTracing,")
        append("memoryInMb=$memoryInMb,")
        append("timeoutInSeconds=$timeoutInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeTracing?.hashCode() ?: 0
        result = 31 * result + (memoryInMb ?: 0)
        result = 31 * result + (timeoutInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CanaryRunConfigOutput

        if (activeTracing != other.activeTracing) return false
        if (memoryInMb != other.memoryInMb) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigOutput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Displays whether this canary run used active X-Ray tracing.
         */
        public var activeTracing: kotlin.Boolean? = null
        /**
         * The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.
         */
        public var memoryInMb: kotlin.Int? = null
        /**
         * How long the canary is allowed to run before it must stop.
         */
        public var timeoutInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigOutput) : this() {
            this.activeTracing = x.activeTracing
            this.memoryInMb = x.memoryInMb
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigOutput = CanaryRunConfigOutput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
