// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains all information about one canary in your account.
 */
public class Canary private constructor(builder: Builder) {
    /**
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
     */
    public val artifactConfig: aws.sdk.kotlin.services.synthetics.model.ArtifactConfigOutput? = builder.artifactConfig
    /**
     * The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. Artifacts include the log file, screenshots, and HAR files.
     */
    public val artifactS3Location: kotlin.String? = builder.artifactS3Location
    /**
     * This structure contains information about the canary's Lambda handler and where its code is stored by CloudWatch Synthetics.
     */
    public val code: aws.sdk.kotlin.services.synthetics.model.CanaryCodeOutput? = builder.code
    /**
     * The ARN of the Lambda function that is used as your canary's engine. For more information about Lambda ARN format, see [Resources and Conditions for Lambda Actions](https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html).
     */
    public val engineArn: kotlin.String? = builder.engineArn
    /**
     * The ARN of the IAM role used to run the canary. This role must include `lambda.amazonaws.com` as a principal in the trust policy.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The number of days to retain data about failed runs of this canary.
     */
    public val failureRetentionPeriodInDays: kotlin.Int? = builder.failureRetentionPeriodInDays
    /**
     * The unique ID of this canary.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the canary.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A structure that contains information about a canary run.
     */
    public val runConfig: aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigOutput? = builder.runConfig
    /**
     * Specifies the runtime version to use for the canary. For more information about runtime versions, see [ Canary Runtime Versions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
     */
    public val runtimeVersion: kotlin.String? = builder.runtimeVersion
    /**
     * A structure that contains information about how often the canary is to run, and when these runs are to stop.
     */
    public val schedule: aws.sdk.kotlin.services.synthetics.model.CanaryScheduleOutput? = builder.schedule
    /**
     * A structure that contains information about the canary's status.
     */
    public val status: aws.sdk.kotlin.services.synthetics.model.CanaryStatus? = builder.status
    /**
     * The number of days to retain data about successful runs of this canary.
     */
    public val successRetentionPeriodInDays: kotlin.Int? = builder.successRetentionPeriodInDays
    /**
     * The list of key-value pairs that are associated with the canary.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A structure that contains information about when the canary was created, modified, and most recently run.
     */
    public val timeline: aws.sdk.kotlin.services.synthetics.model.CanaryTimeline? = builder.timeline
    /**
     * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.
     */
    public val visualReference: aws.sdk.kotlin.services.synthetics.model.VisualReferenceOutput? = builder.visualReference
    /**
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnets and security groups of the VPC endpoint. For more information, see [ Running a Canary in a VPC](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.synthetics.model.VpcConfigOutput? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.Canary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Canary(")
        append("artifactConfig=$artifactConfig,")
        append("artifactS3Location=$artifactS3Location,")
        append("code=$code,")
        append("engineArn=$engineArn,")
        append("executionRoleArn=$executionRoleArn,")
        append("failureRetentionPeriodInDays=$failureRetentionPeriodInDays,")
        append("id=$id,")
        append("name=$name,")
        append("runConfig=$runConfig,")
        append("runtimeVersion=$runtimeVersion,")
        append("schedule=$schedule,")
        append("status=$status,")
        append("successRetentionPeriodInDays=$successRetentionPeriodInDays,")
        append("tags=$tags,")
        append("timeline=$timeline,")
        append("visualReference=$visualReference,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactConfig?.hashCode() ?: 0
        result = 31 * result + (artifactS3Location?.hashCode() ?: 0)
        result = 31 * result + (code?.hashCode() ?: 0)
        result = 31 * result + (engineArn?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (failureRetentionPeriodInDays ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (runConfig?.hashCode() ?: 0)
        result = 31 * result + (runtimeVersion?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (successRetentionPeriodInDays ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeline?.hashCode() ?: 0)
        result = 31 * result + (visualReference?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Canary

        if (artifactConfig != other.artifactConfig) return false
        if (artifactS3Location != other.artifactS3Location) return false
        if (code != other.code) return false
        if (engineArn != other.engineArn) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (failureRetentionPeriodInDays != other.failureRetentionPeriodInDays) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (runConfig != other.runConfig) return false
        if (runtimeVersion != other.runtimeVersion) return false
        if (schedule != other.schedule) return false
        if (status != other.status) return false
        if (successRetentionPeriodInDays != other.successRetentionPeriodInDays) return false
        if (tags != other.tags) return false
        if (timeline != other.timeline) return false
        if (visualReference != other.visualReference) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.Canary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
         */
        public var artifactConfig: aws.sdk.kotlin.services.synthetics.model.ArtifactConfigOutput? = null
        /**
         * The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. Artifacts include the log file, screenshots, and HAR files.
         */
        public var artifactS3Location: kotlin.String? = null
        /**
         * This structure contains information about the canary's Lambda handler and where its code is stored by CloudWatch Synthetics.
         */
        public var code: aws.sdk.kotlin.services.synthetics.model.CanaryCodeOutput? = null
        /**
         * The ARN of the Lambda function that is used as your canary's engine. For more information about Lambda ARN format, see [Resources and Conditions for Lambda Actions](https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html).
         */
        public var engineArn: kotlin.String? = null
        /**
         * The ARN of the IAM role used to run the canary. This role must include `lambda.amazonaws.com` as a principal in the trust policy.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The number of days to retain data about failed runs of this canary.
         */
        public var failureRetentionPeriodInDays: kotlin.Int? = null
        /**
         * The unique ID of this canary.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the canary.
         */
        public var name: kotlin.String? = null
        /**
         * A structure that contains information about a canary run.
         */
        public var runConfig: aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigOutput? = null
        /**
         * Specifies the runtime version to use for the canary. For more information about runtime versions, see [ Canary Runtime Versions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
         */
        public var runtimeVersion: kotlin.String? = null
        /**
         * A structure that contains information about how often the canary is to run, and when these runs are to stop.
         */
        public var schedule: aws.sdk.kotlin.services.synthetics.model.CanaryScheduleOutput? = null
        /**
         * A structure that contains information about the canary's status.
         */
        public var status: aws.sdk.kotlin.services.synthetics.model.CanaryStatus? = null
        /**
         * The number of days to retain data about successful runs of this canary.
         */
        public var successRetentionPeriodInDays: kotlin.Int? = null
        /**
         * The list of key-value pairs that are associated with the canary.
         */
        public var tags: Map<String, String>? = null
        /**
         * A structure that contains information about when the canary was created, modified, and most recently run.
         */
        public var timeline: aws.sdk.kotlin.services.synthetics.model.CanaryTimeline? = null
        /**
         * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.
         */
        public var visualReference: aws.sdk.kotlin.services.synthetics.model.VisualReferenceOutput? = null
        /**
         * If this canary is to test an endpoint in a VPC, this structure contains information about the subnets and security groups of the VPC endpoint. For more information, see [ Running a Canary in a VPC](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.synthetics.model.VpcConfigOutput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.Canary) : this() {
            this.artifactConfig = x.artifactConfig
            this.artifactS3Location = x.artifactS3Location
            this.code = x.code
            this.engineArn = x.engineArn
            this.executionRoleArn = x.executionRoleArn
            this.failureRetentionPeriodInDays = x.failureRetentionPeriodInDays
            this.id = x.id
            this.name = x.name
            this.runConfig = x.runConfig
            this.runtimeVersion = x.runtimeVersion
            this.schedule = x.schedule
            this.status = x.status
            this.successRetentionPeriodInDays = x.successRetentionPeriodInDays
            this.tags = x.tags
            this.timeline = x.timeline
            this.visualReference = x.visualReference
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.Canary = Canary(this)

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.ArtifactConfigOutput] inside the given [block]
         */
        public fun artifactConfig(block: aws.sdk.kotlin.services.synthetics.model.ArtifactConfigOutput.Builder.() -> kotlin.Unit) {
            this.artifactConfig = aws.sdk.kotlin.services.synthetics.model.ArtifactConfigOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.CanaryCodeOutput] inside the given [block]
         */
        public fun code(block: aws.sdk.kotlin.services.synthetics.model.CanaryCodeOutput.Builder.() -> kotlin.Unit) {
            this.code = aws.sdk.kotlin.services.synthetics.model.CanaryCodeOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigOutput] inside the given [block]
         */
        public fun runConfig(block: aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigOutput.Builder.() -> kotlin.Unit) {
            this.runConfig = aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.CanaryScheduleOutput] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.synthetics.model.CanaryScheduleOutput.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.synthetics.model.CanaryScheduleOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.CanaryStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.synthetics.model.CanaryStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.synthetics.model.CanaryStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.CanaryTimeline] inside the given [block]
         */
        public fun timeline(block: aws.sdk.kotlin.services.synthetics.model.CanaryTimeline.Builder.() -> kotlin.Unit) {
            this.timeline = aws.sdk.kotlin.services.synthetics.model.CanaryTimeline.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.VisualReferenceOutput] inside the given [block]
         */
        public fun visualReference(block: aws.sdk.kotlin.services.synthetics.model.VisualReferenceOutput.Builder.() -> kotlin.Unit) {
            this.visualReference = aws.sdk.kotlin.services.synthetics.model.VisualReferenceOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.synthetics.model.VpcConfigOutput] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.synthetics.model.VpcConfigOutput.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.synthetics.model.VpcConfigOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
