// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure representing a screenshot that is used as a baseline during visual monitoring comparisons made by the canary.
 */
public class BaseScreenshot private constructor(builder: Builder) {
    /**
     * Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the coordinates to use here, use the CloudWatch console to draw the boundaries on the screen. For more information, see [ Editing or deleting a canary](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/synthetics_canaries_deletion.html)
     */
    public val ignoreCoordinates: List<String>? = builder.ignoreCoordinates
    /**
     * The name of the screenshot. This is generated the first time the canary is run after the `UpdateCanary` operation that specified for this canary to perform visual monitoring.
     */
    public val screenshotName: kotlin.String = requireNotNull(builder.screenshotName) { "A non-null value must be provided for screenshotName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.BaseScreenshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BaseScreenshot(")
        append("ignoreCoordinates=$ignoreCoordinates,")
        append("screenshotName=$screenshotName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ignoreCoordinates?.hashCode() ?: 0
        result = 31 * result + (screenshotName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BaseScreenshot

        if (ignoreCoordinates != other.ignoreCoordinates) return false
        if (screenshotName != other.screenshotName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.BaseScreenshot = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the coordinates to use here, use the CloudWatch console to draw the boundaries on the screen. For more information, see [ Editing or deleting a canary](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/synthetics_canaries_deletion.html)
         */
        public var ignoreCoordinates: List<String>? = null
        /**
         * The name of the screenshot. This is generated the first time the canary is run after the `UpdateCanary` operation that specified for this canary to perform visual monitoring.
         */
        public var screenshotName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.BaseScreenshot) : this() {
            this.ignoreCoordinates = x.ignoreCoordinates
            this.screenshotName = x.screenshotName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.BaseScreenshot = BaseScreenshot(this)

        internal fun correctErrors(): Builder {
            if (screenshotName == null) screenshotName = ""
            return this
        }
    }
}
