// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.synthetics.auth.DefaultSyntheticsAuthSchemeProvider
import aws.sdk.kotlin.services.synthetics.auth.SyntheticsAuthSchemeProvider
import aws.sdk.kotlin.services.synthetics.endpoints.DefaultSyntheticsEndpointProvider
import aws.sdk.kotlin.services.synthetics.endpoints.SyntheticsEndpointParameters
import aws.sdk.kotlin.services.synthetics.endpoints.SyntheticsEndpointProvider
import aws.sdk.kotlin.services.synthetics.model.AssociateResourceRequest
import aws.sdk.kotlin.services.synthetics.model.AssociateResourceResponse
import aws.sdk.kotlin.services.synthetics.model.CreateCanaryRequest
import aws.sdk.kotlin.services.synthetics.model.CreateCanaryResponse
import aws.sdk.kotlin.services.synthetics.model.CreateGroupRequest
import aws.sdk.kotlin.services.synthetics.model.CreateGroupResponse
import aws.sdk.kotlin.services.synthetics.model.DeleteCanaryRequest
import aws.sdk.kotlin.services.synthetics.model.DeleteCanaryResponse
import aws.sdk.kotlin.services.synthetics.model.DeleteGroupRequest
import aws.sdk.kotlin.services.synthetics.model.DeleteGroupResponse
import aws.sdk.kotlin.services.synthetics.model.DescribeCanariesLastRunRequest
import aws.sdk.kotlin.services.synthetics.model.DescribeCanariesLastRunResponse
import aws.sdk.kotlin.services.synthetics.model.DescribeCanariesRequest
import aws.sdk.kotlin.services.synthetics.model.DescribeCanariesResponse
import aws.sdk.kotlin.services.synthetics.model.DescribeRuntimeVersionsRequest
import aws.sdk.kotlin.services.synthetics.model.DescribeRuntimeVersionsResponse
import aws.sdk.kotlin.services.synthetics.model.DisassociateResourceRequest
import aws.sdk.kotlin.services.synthetics.model.DisassociateResourceResponse
import aws.sdk.kotlin.services.synthetics.model.GetCanaryRequest
import aws.sdk.kotlin.services.synthetics.model.GetCanaryResponse
import aws.sdk.kotlin.services.synthetics.model.GetCanaryRunsRequest
import aws.sdk.kotlin.services.synthetics.model.GetCanaryRunsResponse
import aws.sdk.kotlin.services.synthetics.model.GetGroupRequest
import aws.sdk.kotlin.services.synthetics.model.GetGroupResponse
import aws.sdk.kotlin.services.synthetics.model.ListAssociatedGroupsRequest
import aws.sdk.kotlin.services.synthetics.model.ListAssociatedGroupsResponse
import aws.sdk.kotlin.services.synthetics.model.ListGroupResourcesRequest
import aws.sdk.kotlin.services.synthetics.model.ListGroupResourcesResponse
import aws.sdk.kotlin.services.synthetics.model.ListGroupsRequest
import aws.sdk.kotlin.services.synthetics.model.ListGroupsResponse
import aws.sdk.kotlin.services.synthetics.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.synthetics.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.synthetics.model.StartCanaryRequest
import aws.sdk.kotlin.services.synthetics.model.StartCanaryResponse
import aws.sdk.kotlin.services.synthetics.model.StopCanaryRequest
import aws.sdk.kotlin.services.synthetics.model.StopCanaryResponse
import aws.sdk.kotlin.services.synthetics.model.TagResourceRequest
import aws.sdk.kotlin.services.synthetics.model.TagResourceResponse
import aws.sdk.kotlin.services.synthetics.model.UntagResourceRequest
import aws.sdk.kotlin.services.synthetics.model.UntagResourceResponse
import aws.sdk.kotlin.services.synthetics.model.UpdateCanaryRequest
import aws.sdk.kotlin.services.synthetics.model.UpdateCanaryResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "synthetics"
public const val SdkVersion: String = "1.3.44"
public const val ServiceApiVersion: String = "2017-10-11"

/**
 * # Amazon CloudWatch Synthetics
 * You can use Amazon CloudWatch Synthetics to continually monitor your services. You can create and manage *canaries*, which are modular, lightweight scripts that monitor your endpoints and APIs from the outside-in. You can set up your canaries to run 24 hours a day, once per minute. The canaries help you check the availability and latency of your web services and troubleshoot anomalies by investigating load time data, screenshots of the UI, logs, and metrics. The canaries seamlessly integrate with CloudWatch ServiceLens to help you trace the causes of impacted nodes in your applications. For more information, see [Using ServiceLens to Monitor the Health of Your Applications](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ServiceLens.html) in the *Amazon CloudWatch User Guide*.
 *
 * Before you create and manage canaries, be aware of the security considerations. For more information, see [Security Considerations for Synthetics Canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html).
 */
public interface SyntheticsClient : SdkClient {
    /**
     * SyntheticsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SyntheticsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Synthetics",
                "SYNTHETICS",
                "synthetics",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SyntheticsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SyntheticsClient = DefaultSyntheticsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SyntheticsEndpointProvider = builder.endpointProvider ?: DefaultSyntheticsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SyntheticsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSyntheticsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "synthetics"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SyntheticsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SyntheticsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a canary with a group. Using groups can help you with managing and automating your canaries, and you can also view aggregated run results and statistics for all canaries in a group.
     *
     * You must run this operation in the Region where the canary exists.
     */
    public suspend fun associateResource(input: AssociateResourceRequest): AssociateResourceResponse

    /**
     * Creates a canary. Canaries are scripts that monitor your endpoints and APIs from the outside-in. Canaries help you check the availability and latency of your web services and troubleshoot anomalies by investigating load time data, screenshots of the UI, logs, and metrics. You can set up a canary to run continuously or just once.
     *
     * Do not use `CreateCanary` to modify an existing canary. Use [UpdateCanary](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_UpdateCanary.html) instead.
     *
     * To create canaries, you must have the `CloudWatchSyntheticsFullAccess` policy. If you are creating a new IAM role for the canary, you also need the `iam:CreateRole`, `iam:CreatePolicy` and `iam:AttachRolePolicy` permissions. For more information, see [Necessary Roles and Permissions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Roles).
     *
     * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the Amazon Resource Name (ARN) for the canary, and the ARN is included in outbound calls over the internet. For more information, see [Security Considerations for Synthetics Canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html).
     */
    public suspend fun createCanary(input: CreateCanaryRequest): CreateCanaryResponse

    /**
     * Creates a group which you can use to associate canaries with each other, including cross-Region canaries. Using groups can help you with managing and automating your canaries, and you can also view aggregated run results and statistics for all canaries in a group.
     *
     * Groups are global resources. When you create a group, it is replicated across Amazon Web Services Regions, and you can view it and add canaries to it from any Region. Although the group ARN format reflects the Region name where it was created, a group is not constrained to any Region. This means that you can put canaries from multiple Regions into the same group, and then use that group to view and manage all of those canaries in a single view.
     *
     * Groups are supported in all Regions except the Regions that are disabled by default. For more information about these Regions, see [Enabling a Region](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable).
     *
     * Each group can contain as many as 10 canaries. You can have as many as 20 groups in your account. Any single canary can be a member of up to 10 groups.
     */
    public suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Permanently deletes the specified canary.
     *
     * If you specify `DeleteLambda` to `true`, CloudWatch Synthetics also deletes the Lambda functions and layers that are used by the canary.
     *
     * Other resources used and created by the canary are not automatically deleted. After you delete a canary that you do not intend to use again, you should also delete the following:
     * + The CloudWatch alarms created for this canary. These alarms have a name of `Synthetics-Alarm-<i>first-198-characters-of-canary-name</i>-<i>canaryId</i>-<i>alarm number</i> `
     * + Amazon S3 objects and buckets, such as the canary's artifact location.
     * + IAM roles created for the canary. If they were created in the console, these roles have the name ` role/service-role/CloudWatchSyntheticsRole-<i>First-21-Characters-of-CanaryName</i> `
     * + CloudWatch Logs log groups created for the canary. These logs groups have the name `/aws/lambda/cwsyn-<i>First-21-Characters-of-CanaryName</i> `
     *
     * Before you delete a canary, you might want to use `GetCanary` to display the information about this canary. Make note of the information returned by this operation so that you can delete these resources after you delete the canary.
     */
    public suspend fun deleteCanary(input: DeleteCanaryRequest): DeleteCanaryResponse

    /**
     * Deletes a group. The group doesn't need to be empty to be deleted. If there are canaries in the group, they are not deleted when you delete the group.
     *
     * Groups are a global resource that appear in all Regions, but the request to delete a group must be made from its home Region. You can find the home Region of a group within its ARN.
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * This operation returns a list of the canaries in your account, along with full details about each canary.
     *
     * This operation supports resource-level authorization using an IAM policy and the `Names` parameter. If you specify the `Names` parameter, the operation is successful only if you have authorization to view all the canaries that you specify in your request. If you do not have permission to view any of the canaries, the request fails with a 403 response.
     *
     * You are required to use the `Names` parameter if you are logged on to a user or role that has an IAM policy that restricts which canaries that you are allowed to view. For more information, see [ Limiting a user to viewing specific canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html).
     */
    public suspend fun describeCanaries(input: DescribeCanariesRequest = DescribeCanariesRequest { }): DescribeCanariesResponse

    /**
     * Use this operation to see information from the most recent run of each canary that you have created.
     *
     * This operation supports resource-level authorization using an IAM policy and the `Names` parameter. If you specify the `Names` parameter, the operation is successful only if you have authorization to view all the canaries that you specify in your request. If you do not have permission to view any of the canaries, the request fails with a 403 response.
     *
     * You are required to use the `Names` parameter if you are logged on to a user or role that has an IAM policy that restricts which canaries that you are allowed to view. For more information, see [ Limiting a user to viewing specific canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html).
     */
    public suspend fun describeCanariesLastRun(input: DescribeCanariesLastRunRequest = DescribeCanariesLastRunRequest { }): DescribeCanariesLastRunResponse

    /**
     * Returns a list of Synthetics canary runtime versions. For more information, see [ Canary Runtime Versions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
     */
    public suspend fun describeRuntimeVersions(input: DescribeRuntimeVersionsRequest = DescribeRuntimeVersionsRequest { }): DescribeRuntimeVersionsResponse

    /**
     * Removes a canary from a group. You must run this operation in the Region where the canary exists.
     */
    public suspend fun disassociateResource(input: DisassociateResourceRequest): DisassociateResourceResponse

    /**
     * Retrieves complete information about one canary. You must specify the name of the canary that you want. To get a list of canaries and their names, use [DescribeCanaries](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html).
     */
    public suspend fun getCanary(input: GetCanaryRequest): GetCanaryResponse

    /**
     * Retrieves a list of runs for a specified canary.
     */
    public suspend fun getCanaryRuns(input: GetCanaryRunsRequest): GetCanaryRunsResponse

    /**
     * Returns information about one group. Groups are a global resource, so you can use this operation from any Region.
     */
    public suspend fun getGroup(input: GetGroupRequest): GetGroupResponse

    /**
     * Returns a list of the groups that the specified canary is associated with. The canary that you specify must be in the current Region.
     */
    public suspend fun listAssociatedGroups(input: ListAssociatedGroupsRequest): ListAssociatedGroupsResponse

    /**
     * This operation returns a list of the ARNs of the canaries that are associated with the specified group.
     */
    public suspend fun listGroupResources(input: ListGroupResourcesRequest): ListGroupResourcesResponse

    /**
     * Returns a list of all groups in the account, displaying their names, unique IDs, and ARNs. The groups from all Regions are returned.
     */
    public suspend fun listGroups(input: ListGroupsRequest = ListGroupsRequest { }): ListGroupsResponse

    /**
     * Displays the tags associated with a canary or group.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Use this operation to run a canary that has already been created. The frequency of the canary runs is determined by the value of the canary's `Schedule`. To see a canary's schedule, use [GetCanary](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanary.html).
     */
    public suspend fun startCanary(input: StartCanaryRequest): StartCanaryResponse

    /**
     * Stops the canary to prevent all future runs. If the canary is currently running,the run that is in progress completes on its own, publishes metrics, and uploads artifacts, but it is not recorded in Synthetics as a completed run.
     *
     * You can use `StartCanary` to start it running again with the canary’s current schedule at any point in the future.
     */
    public suspend fun stopCanary(input: StopCanaryRequest): StopCanaryResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified canary or group.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.
     *
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
     *
     * You can use the `TagResource` action with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate as many as 50 tags with a canary or group.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the configuration of a canary that has already been created.
     *
     * You can't use this operation to update the tags of an existing canary. To change the tags of an existing canary, use [TagResource](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_TagResource.html).
     */
    public suspend fun updateCanary(input: UpdateCanaryRequest): UpdateCanaryResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SyntheticsClient.withConfig(block: SyntheticsClient.Config.Builder.() -> Unit): SyntheticsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSyntheticsClient(newConfig)
}

/**
 * Associates a canary with a group. Using groups can help you with managing and automating your canaries, and you can also view aggregated run results and statistics for all canaries in a group.
 *
 * You must run this operation in the Region where the canary exists.
 */
public suspend inline fun SyntheticsClient.associateResource(crossinline block: AssociateResourceRequest.Builder.() -> Unit): AssociateResourceResponse = associateResource(AssociateResourceRequest.Builder().apply(block).build())

/**
 * Creates a canary. Canaries are scripts that monitor your endpoints and APIs from the outside-in. Canaries help you check the availability and latency of your web services and troubleshoot anomalies by investigating load time data, screenshots of the UI, logs, and metrics. You can set up a canary to run continuously or just once.
 *
 * Do not use `CreateCanary` to modify an existing canary. Use [UpdateCanary](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_UpdateCanary.html) instead.
 *
 * To create canaries, you must have the `CloudWatchSyntheticsFullAccess` policy. If you are creating a new IAM role for the canary, you also need the `iam:CreateRole`, `iam:CreatePolicy` and `iam:AttachRolePolicy` permissions. For more information, see [Necessary Roles and Permissions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Roles).
 *
 * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the Amazon Resource Name (ARN) for the canary, and the ARN is included in outbound calls over the internet. For more information, see [Security Considerations for Synthetics Canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html).
 */
public suspend inline fun SyntheticsClient.createCanary(crossinline block: CreateCanaryRequest.Builder.() -> Unit): CreateCanaryResponse = createCanary(CreateCanaryRequest.Builder().apply(block).build())

/**
 * Creates a group which you can use to associate canaries with each other, including cross-Region canaries. Using groups can help you with managing and automating your canaries, and you can also view aggregated run results and statistics for all canaries in a group.
 *
 * Groups are global resources. When you create a group, it is replicated across Amazon Web Services Regions, and you can view it and add canaries to it from any Region. Although the group ARN format reflects the Region name where it was created, a group is not constrained to any Region. This means that you can put canaries from multiple Regions into the same group, and then use that group to view and manage all of those canaries in a single view.
 *
 * Groups are supported in all Regions except the Regions that are disabled by default. For more information about these Regions, see [Enabling a Region](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable).
 *
 * Each group can contain as many as 10 canaries. You can have as many as 20 groups in your account. Any single canary can be a member of up to 10 groups.
 */
public suspend inline fun SyntheticsClient.createGroup(crossinline block: CreateGroupRequest.Builder.() -> Unit): CreateGroupResponse = createGroup(CreateGroupRequest.Builder().apply(block).build())

/**
 * Permanently deletes the specified canary.
 *
 * If you specify `DeleteLambda` to `true`, CloudWatch Synthetics also deletes the Lambda functions and layers that are used by the canary.
 *
 * Other resources used and created by the canary are not automatically deleted. After you delete a canary that you do not intend to use again, you should also delete the following:
 * + The CloudWatch alarms created for this canary. These alarms have a name of `Synthetics-Alarm-<i>first-198-characters-of-canary-name</i>-<i>canaryId</i>-<i>alarm number</i> `
 * + Amazon S3 objects and buckets, such as the canary's artifact location.
 * + IAM roles created for the canary. If they were created in the console, these roles have the name ` role/service-role/CloudWatchSyntheticsRole-<i>First-21-Characters-of-CanaryName</i> `
 * + CloudWatch Logs log groups created for the canary. These logs groups have the name `/aws/lambda/cwsyn-<i>First-21-Characters-of-CanaryName</i> `
 *
 * Before you delete a canary, you might want to use `GetCanary` to display the information about this canary. Make note of the information returned by this operation so that you can delete these resources after you delete the canary.
 */
public suspend inline fun SyntheticsClient.deleteCanary(crossinline block: DeleteCanaryRequest.Builder.() -> Unit): DeleteCanaryResponse = deleteCanary(DeleteCanaryRequest.Builder().apply(block).build())

/**
 * Deletes a group. The group doesn't need to be empty to be deleted. If there are canaries in the group, they are not deleted when you delete the group.
 *
 * Groups are a global resource that appear in all Regions, but the request to delete a group must be made from its home Region. You can find the home Region of a group within its ARN.
 */
public suspend inline fun SyntheticsClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * This operation returns a list of the canaries in your account, along with full details about each canary.
 *
 * This operation supports resource-level authorization using an IAM policy and the `Names` parameter. If you specify the `Names` parameter, the operation is successful only if you have authorization to view all the canaries that you specify in your request. If you do not have permission to view any of the canaries, the request fails with a 403 response.
 *
 * You are required to use the `Names` parameter if you are logged on to a user or role that has an IAM policy that restricts which canaries that you are allowed to view. For more information, see [ Limiting a user to viewing specific canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html).
 */
public suspend inline fun SyntheticsClient.describeCanaries(crossinline block: DescribeCanariesRequest.Builder.() -> Unit): DescribeCanariesResponse = describeCanaries(DescribeCanariesRequest.Builder().apply(block).build())

/**
 * Use this operation to see information from the most recent run of each canary that you have created.
 *
 * This operation supports resource-level authorization using an IAM policy and the `Names` parameter. If you specify the `Names` parameter, the operation is successful only if you have authorization to view all the canaries that you specify in your request. If you do not have permission to view any of the canaries, the request fails with a 403 response.
 *
 * You are required to use the `Names` parameter if you are logged on to a user or role that has an IAM policy that restricts which canaries that you are allowed to view. For more information, see [ Limiting a user to viewing specific canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html).
 */
public suspend inline fun SyntheticsClient.describeCanariesLastRun(crossinline block: DescribeCanariesLastRunRequest.Builder.() -> Unit): DescribeCanariesLastRunResponse = describeCanariesLastRun(DescribeCanariesLastRunRequest.Builder().apply(block).build())

/**
 * Returns a list of Synthetics canary runtime versions. For more information, see [ Canary Runtime Versions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
 */
public suspend inline fun SyntheticsClient.describeRuntimeVersions(crossinline block: DescribeRuntimeVersionsRequest.Builder.() -> Unit): DescribeRuntimeVersionsResponse = describeRuntimeVersions(DescribeRuntimeVersionsRequest.Builder().apply(block).build())

/**
 * Removes a canary from a group. You must run this operation in the Region where the canary exists.
 */
public suspend inline fun SyntheticsClient.disassociateResource(crossinline block: DisassociateResourceRequest.Builder.() -> Unit): DisassociateResourceResponse = disassociateResource(DisassociateResourceRequest.Builder().apply(block).build())

/**
 * Retrieves complete information about one canary. You must specify the name of the canary that you want. To get a list of canaries and their names, use [DescribeCanaries](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html).
 */
public suspend inline fun SyntheticsClient.getCanary(crossinline block: GetCanaryRequest.Builder.() -> Unit): GetCanaryResponse = getCanary(GetCanaryRequest.Builder().apply(block).build())

/**
 * Retrieves a list of runs for a specified canary.
 */
public suspend inline fun SyntheticsClient.getCanaryRuns(crossinline block: GetCanaryRunsRequest.Builder.() -> Unit): GetCanaryRunsResponse = getCanaryRuns(GetCanaryRunsRequest.Builder().apply(block).build())

/**
 * Returns information about one group. Groups are a global resource, so you can use this operation from any Region.
 */
public suspend inline fun SyntheticsClient.getGroup(crossinline block: GetGroupRequest.Builder.() -> Unit): GetGroupResponse = getGroup(GetGroupRequest.Builder().apply(block).build())

/**
 * Returns a list of the groups that the specified canary is associated with. The canary that you specify must be in the current Region.
 */
public suspend inline fun SyntheticsClient.listAssociatedGroups(crossinline block: ListAssociatedGroupsRequest.Builder.() -> Unit): ListAssociatedGroupsResponse = listAssociatedGroups(ListAssociatedGroupsRequest.Builder().apply(block).build())

/**
 * This operation returns a list of the ARNs of the canaries that are associated with the specified group.
 */
public suspend inline fun SyntheticsClient.listGroupResources(crossinline block: ListGroupResourcesRequest.Builder.() -> Unit): ListGroupResourcesResponse = listGroupResources(ListGroupResourcesRequest.Builder().apply(block).build())

/**
 * Returns a list of all groups in the account, displaying their names, unique IDs, and ARNs. The groups from all Regions are returned.
 */
public suspend inline fun SyntheticsClient.listGroups(crossinline block: ListGroupsRequest.Builder.() -> Unit): ListGroupsResponse = listGroups(ListGroupsRequest.Builder().apply(block).build())

/**
 * Displays the tags associated with a canary or group.
 */
public suspend inline fun SyntheticsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Use this operation to run a canary that has already been created. The frequency of the canary runs is determined by the value of the canary's `Schedule`. To see a canary's schedule, use [GetCanary](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanary.html).
 */
public suspend inline fun SyntheticsClient.startCanary(crossinline block: StartCanaryRequest.Builder.() -> Unit): StartCanaryResponse = startCanary(StartCanaryRequest.Builder().apply(block).build())

/**
 * Stops the canary to prevent all future runs. If the canary is currently running,the run that is in progress completes on its own, publishes metrics, and uploads artifacts, but it is not recorded in Synthetics as a completed run.
 *
 * You can use `StartCanary` to start it running again with the canary’s current schedule at any point in the future.
 */
public suspend inline fun SyntheticsClient.stopCanary(crossinline block: StopCanaryRequest.Builder.() -> Unit): StopCanaryResponse = stopCanary(StopCanaryRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified canary or group.
 *
 * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.
 *
 * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
 *
 * You can use the `TagResource` action with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 *
 * You can associate as many as 50 tags with a canary or group.
 */
public suspend inline fun SyntheticsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource.
 */
public suspend inline fun SyntheticsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the configuration of a canary that has already been created.
 *
 * You can't use this operation to update the tags of an existing canary. To change the tags of an existing canary, use [TagResource](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_TagResource.html).
 */
public suspend inline fun SyntheticsClient.updateCanary(crossinline block: UpdateCanaryRequest.Builder.() -> Unit): UpdateCanaryResponse = updateCanary(UpdateCanaryRequest.Builder().apply(block).build())
