// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.transform

import aws.sdk.kotlin.services.synthetics.model.ArtifactConfigInput
import aws.sdk.kotlin.services.synthetics.model.CanaryCodeInput
import aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigInput
import aws.sdk.kotlin.services.synthetics.model.CanaryScheduleInput
import aws.sdk.kotlin.services.synthetics.model.UpdateCanaryRequest
import aws.sdk.kotlin.services.synthetics.model.VisualReferenceInput
import aws.sdk.kotlin.services.synthetics.model.VpcConfigInput
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateCanaryOperationSerializer: HttpSerialize<UpdateCanaryRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateCanaryRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf<String>(
                "canary",
                "${input.name}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateCanaryOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateCanaryOperationBody(context: ExecutionContext, input: UpdateCanaryRequest): ByteArray {
    val serializer = JsonSerializer()
    val ARTIFACTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ArtifactConfig"))
    val ARTIFACTS3LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArtifactS3Location"))
    val CODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Code"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionRoleArn"))
    val FAILURERETENTIONPERIODINDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("FailureRetentionPeriodInDays"))
    val RUNCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RunConfig"))
    val RUNTIMEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RuntimeVersion"))
    val SCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Schedule"))
    val SUCCESSRETENTIONPERIODINDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("SuccessRetentionPeriodInDays"))
    val VISUALREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VisualReference"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARTIFACTCONFIG_DESCRIPTOR)
        field(ARTIFACTS3LOCATION_DESCRIPTOR)
        field(CODE_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(FAILURERETENTIONPERIODINDAYS_DESCRIPTOR)
        field(RUNCONFIG_DESCRIPTOR)
        field(RUNTIMEVERSION_DESCRIPTOR)
        field(SCHEDULE_DESCRIPTOR)
        field(SUCCESSRETENTIONPERIODINDAYS_DESCRIPTOR)
        field(VISUALREFERENCE_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.artifactConfig?.let { field(ARTIFACTCONFIG_DESCRIPTOR, it, ::serializeArtifactConfigInputDocument) }
        input.artifactS3Location?.let { field(ARTIFACTS3LOCATION_DESCRIPTOR, it) }
        input.code?.let { field(CODE_DESCRIPTOR, it, ::serializeCanaryCodeInputDocument) }
        input.executionRoleArn?.let { field(EXECUTIONROLEARN_DESCRIPTOR, it) }
        input.failureRetentionPeriodInDays?.let { field(FAILURERETENTIONPERIODINDAYS_DESCRIPTOR, it) }
        input.runConfig?.let { field(RUNCONFIG_DESCRIPTOR, it, ::serializeCanaryRunConfigInputDocument) }
        input.runtimeVersion?.let { field(RUNTIMEVERSION_DESCRIPTOR, it) }
        input.schedule?.let { field(SCHEDULE_DESCRIPTOR, it, ::serializeCanaryScheduleInputDocument) }
        input.successRetentionPeriodInDays?.let { field(SUCCESSRETENTIONPERIODINDAYS_DESCRIPTOR, it) }
        input.visualReference?.let { field(VISUALREFERENCE_DESCRIPTOR, it, ::serializeVisualReferenceInputDocument) }
        input.vpcConfig?.let { field(VPCCONFIG_DESCRIPTOR, it, ::serializeVpcConfigInputDocument) }
    }
    return serializer.toByteArray()
}
