// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.transform

import aws.sdk.kotlin.services.synthetics.model.ArtifactConfigInput
import aws.sdk.kotlin.services.synthetics.model.CanaryCodeInput
import aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigInput
import aws.sdk.kotlin.services.synthetics.model.CanaryScheduleInput
import aws.sdk.kotlin.services.synthetics.model.CreateCanaryRequest
import aws.sdk.kotlin.services.synthetics.model.VpcConfigInput
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCanaryOperationSerializer: HttpSerialize<CreateCanaryRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateCanaryRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/canary"
        }

        val payload = serializeCreateCanaryOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateCanaryOperationBody(context: ExecutionContext, input: CreateCanaryRequest): ByteArray {
    val serializer = JsonSerializer()
    val ARTIFACTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ArtifactConfig"))
    val ARTIFACTS3LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArtifactS3Location"))
    val CODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Code"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionRoleArn"))
    val FAILURERETENTIONPERIODINDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("FailureRetentionPeriodInDays"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val RUNCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RunConfig"))
    val RUNTIMEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RuntimeVersion"))
    val SCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Schedule"))
    val SUCCESSRETENTIONPERIODINDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("SuccessRetentionPeriodInDays"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARTIFACTCONFIG_DESCRIPTOR)
        field(ARTIFACTS3LOCATION_DESCRIPTOR)
        field(CODE_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(FAILURERETENTIONPERIODINDAYS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RUNCONFIG_DESCRIPTOR)
        field(RUNTIMEVERSION_DESCRIPTOR)
        field(SCHEDULE_DESCRIPTOR)
        field(SUCCESSRETENTIONPERIODINDAYS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.artifactConfig?.let { field(ARTIFACTCONFIG_DESCRIPTOR, it, ::serializeArtifactConfigInputDocument) }
        input.artifactS3Location?.let { field(ARTIFACTS3LOCATION_DESCRIPTOR, it) }
        input.code?.let { field(CODE_DESCRIPTOR, it, ::serializeCanaryCodeInputDocument) }
        input.executionRoleArn?.let { field(EXECUTIONROLEARN_DESCRIPTOR, it) }
        input.failureRetentionPeriodInDays?.let { field(FAILURERETENTIONPERIODINDAYS_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.runConfig?.let { field(RUNCONFIG_DESCRIPTOR, it, ::serializeCanaryRunConfigInputDocument) }
        input.runtimeVersion?.let { field(RUNTIMEVERSION_DESCRIPTOR, it) }
        input.schedule?.let { field(SCHEDULE_DESCRIPTOR, it, ::serializeCanaryScheduleInputDocument) }
        input.successRetentionPeriodInDays?.let { field(SUCCESSRETENTIONPERIODINDAYS_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.vpcConfig?.let { field(VPCCONFIG_DESCRIPTOR, it, ::serializeVpcConfigInputDocument) }
    }
    return serializer.toByteArray()
}
