// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model



public class DescribeCanariesLastRunRequest private constructor(builder: Builder) {
    /**
     * Specify this parameter to limit how many runs are returned each time you use the `DescribeLastRun` operation. If you omit this parameter, the default of 100 is used.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Use this parameter to return only canaries that match the names that you specify here. You can specify as many as five canary names.
     *
     * If you specify this parameter, the operation is successful only if you have authorization to view all the canaries that you specify in your request. If you do not have permission to view any of the canaries, the request fails with a 403 response.
     *
     * You are required to use the `Names` parameter if you are logged on to a user or role that has an IAM policy that restricts which canaries that you are allowed to view. For more information, see [ Limiting a user to viewing specific canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html).
     */
    public val names: List<String>? = builder.names
    /**
     * A token that indicates that there is more data available. You can use this token in a subsequent `DescribeCanariesLastRun` operation to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.DescribeCanariesLastRunRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeCanariesLastRunRequest(")
        append("maxResults=$maxResults,")
        append("names=$names,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (names?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeCanariesLastRunRequest

        if (maxResults != other.maxResults) return false
        if (names != other.names) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.DescribeCanariesLastRunRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify this parameter to limit how many runs are returned each time you use the `DescribeLastRun` operation. If you omit this parameter, the default of 100 is used.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Use this parameter to return only canaries that match the names that you specify here. You can specify as many as five canary names.
         *
         * If you specify this parameter, the operation is successful only if you have authorization to view all the canaries that you specify in your request. If you do not have permission to view any of the canaries, the request fails with a 403 response.
         *
         * You are required to use the `Names` parameter if you are logged on to a user or role that has an IAM policy that restricts which canaries that you are allowed to view. For more information, see [ Limiting a user to viewing specific canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html).
         */
        public var names: List<String>? = null
        /**
         * A token that indicates that there is more data available. You can use this token in a subsequent `DescribeCanariesLastRun` operation to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.DescribeCanariesLastRunRequest) : this() {
            this.maxResults = x.maxResults
            this.names = x.names
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.DescribeCanariesLastRunRequest = DescribeCanariesLastRunRequest(this)
    }
}
