// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model



/**
 * This structure specifies how often a canary is to make runs and the date and time when it should stop making runs.
 */
public class CanaryScheduleInput private constructor(builder: Builder) {
    /**
     * How long, in seconds, for the canary to continue making regular runs according to the schedule in the `Expression` value. If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.
     */
    public val durationInSeconds: kotlin.Long? = builder.durationInSeconds
    /**
     * A `rate` expression or a `cron` expression that defines how often the canary is to run.
     *
     * For a rate expression, The syntax is `rate(<i>number unit</i>)`. *unit* can be `minute`, `minutes`, or `hour`.
     *
     * For example, `rate(1 minute)` runs the canary once a minute, `rate(10 minutes)` runs it once every 10 minutes, and `rate(1 hour)` runs it once every hour. You can specify a frequency between `rate(1 minute)` and `rate(1 hour)`.
     *
     * Specifying `rate(0 minute)` or `rate(0 hour)` is a special value that causes the canary to run only once when it is started.
     *
     * Use `cron(<i>expression</i>)` to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see [ Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
     */
    public val expression: kotlin.String? = builder.expression

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.CanaryScheduleInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CanaryScheduleInput(")
        append("durationInSeconds=$durationInSeconds,")
        append("expression=$expression")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationInSeconds?.hashCode() ?: 0
        result = 31 * result + (expression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CanaryScheduleInput

        if (durationInSeconds != other.durationInSeconds) return false
        if (expression != other.expression) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.CanaryScheduleInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * How long, in seconds, for the canary to continue making regular runs according to the schedule in the `Expression` value. If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.
         */
        public var durationInSeconds: kotlin.Long? = null
        /**
         * A `rate` expression or a `cron` expression that defines how often the canary is to run.
         *
         * For a rate expression, The syntax is `rate(<i>number unit</i>)`. *unit* can be `minute`, `minutes`, or `hour`.
         *
         * For example, `rate(1 minute)` runs the canary once a minute, `rate(10 minutes)` runs it once every 10 minutes, and `rate(1 hour)` runs it once every hour. You can specify a frequency between `rate(1 minute)` and `rate(1 hour)`.
         *
         * Specifying `rate(0 minute)` or `rate(0 hour)` is a special value that causes the canary to run only once when it is started.
         *
         * Use `cron(<i>expression</i>)` to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see [ Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
         */
        public var expression: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.CanaryScheduleInput) : this() {
            this.durationInSeconds = x.durationInSeconds
            this.expression = x.expression
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.CanaryScheduleInput = CanaryScheduleInput(this)
    }
}
