// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model



/**
 * A structure that contains input information for a canary run.
 */
public class CanaryRunConfigInput private constructor(builder: Builder) {
    /**
     * Specifies whether this canary is to use active X-Ray tracing when it runs. Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see [ Canaries and X-Ray tracing](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html).
     *
     * You can enable active tracing only for canaries that use version `syn-nodejs-2.0` or later for their canary runtime.
     */
    public val activeTracing: kotlin.Boolean? = builder.activeTracing
    /**
     * Specifies the keys and values to use for any environment variables used in the canary script. Use the following format:
     *
     * { "key1" : "value1", "key2" : "value2", ...}
     *
     * Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see [ Runtime environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime).
     *
     * The environment variables keys and values are not encrypted. Do not store sensitive information in this field.
     */
    public val environmentVariables: Map<String, String>? = builder.environmentVariables
    /**
     * The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.
     */
    public val memoryInMb: kotlin.Int? = builder.memoryInMb
    /**
     * How long the canary is allowed to run before it must stop. You can't set this time to be longer than the frequency of the runs of this canary.
     *
     * If you omit this field, the frequency of the canary is used as this value, up to a maximum of 14 minutes.
     */
    public val timeoutInSeconds: kotlin.Int? = builder.timeoutInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CanaryRunConfigInput(")
        append("activeTracing=$activeTracing,")
        append("environmentVariables=$environmentVariables,")
        append("memoryInMb=$memoryInMb,")
        append("timeoutInSeconds=$timeoutInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeTracing?.hashCode() ?: 0
        result = 31 * result + (environmentVariables?.hashCode() ?: 0)
        result = 31 * result + (memoryInMb ?: 0)
        result = 31 * result + (timeoutInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CanaryRunConfigInput

        if (activeTracing != other.activeTracing) return false
        if (environmentVariables != other.environmentVariables) return false
        if (memoryInMb != other.memoryInMb) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether this canary is to use active X-Ray tracing when it runs. Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see [ Canaries and X-Ray tracing](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html).
         *
         * You can enable active tracing only for canaries that use version `syn-nodejs-2.0` or later for their canary runtime.
         */
        public var activeTracing: kotlin.Boolean? = null
        /**
         * Specifies the keys and values to use for any environment variables used in the canary script. Use the following format:
         *
         * { "key1" : "value1", "key2" : "value2", ...}
         *
         * Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see [ Runtime environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime).
         *
         * The environment variables keys and values are not encrypted. Do not store sensitive information in this field.
         */
        public var environmentVariables: Map<String, String>? = null
        /**
         * The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.
         */
        public var memoryInMb: kotlin.Int? = null
        /**
         * How long the canary is allowed to run before it must stop. You can't set this time to be longer than the frequency of the runs of this canary.
         *
         * If you omit this field, the frequency of the canary is used as this value, up to a maximum of 14 minutes.
         */
        public var timeoutInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigInput) : this() {
            this.activeTracing = x.activeTracing
            this.environmentVariables = x.environmentVariables
            this.memoryInMb = x.memoryInMb
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.CanaryRunConfigInput = CanaryRunConfigInput(this)
    }
}
