// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model



/**
 * Use this structure to input your script code for the canary. This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script was passed into the canary directly, the script code is contained in the value of `Zipfile`.
 */
public class CanaryCodeInput private constructor(builder: Builder) {
    /**
     * The entry point to use for the source code when running the canary. For canaries that use the `syn-python-selenium-1.0` runtime or a `syn-nodejs.puppeteer` runtime earlier than `syn-nodejs.puppeteer-3.4`, the handler must be specified as ` <i>fileName</i>.handler`. For `syn-python-selenium-1.1`, `syn-nodejs.puppeteer-3.4`, and later runtimes, the handler can be specified as ` <i>fileName</i>.<i>functionName</i> `, or you can specify a folder where canary scripts reside as ` <i>folder</i>/<i>fileName</i>.<i>functionName</i> `.
     */
    public val handler: kotlin.String? = builder.handler
    /**
     * If your canary script is located in S3, specify the bucket name here. Do not include `s3://` as the start of the bucket name.
     */
    public val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * The S3 key of your script. For more information, see [Working with Amazon S3 Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html).
     */
    public val s3Key: kotlin.String? = builder.s3Key
    /**
     * The S3 version ID of your script.
     */
    public val s3Version: kotlin.String? = builder.s3Version
    /**
     * If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the base64-encoded contents of the .zip file that contains the script. It must be smaller than 225 Kb.
     *
     * For large canary scripts, we recommend that you use an S3 location instead of inputting it directly with this parameter.
     */
    public val zipFile: kotlin.ByteArray? = builder.zipFile

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.CanaryCodeInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CanaryCodeInput(")
        append("handler=$handler,")
        append("s3Bucket=$s3Bucket,")
        append("s3Key=$s3Key,")
        append("s3Version=$s3Version,")
        append("zipFile=$zipFile")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = handler?.hashCode() ?: 0
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3Key?.hashCode() ?: 0)
        result = 31 * result + (s3Version?.hashCode() ?: 0)
        result = 31 * result + (zipFile?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CanaryCodeInput

        if (handler != other.handler) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3Key != other.s3Key) return false
        if (s3Version != other.s3Version) return false
        if (zipFile != null) {
            if (other.zipFile == null) return false
            if (!zipFile.contentEquals(other.zipFile)) return false
        } else if (other.zipFile != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.CanaryCodeInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The entry point to use for the source code when running the canary. For canaries that use the `syn-python-selenium-1.0` runtime or a `syn-nodejs.puppeteer` runtime earlier than `syn-nodejs.puppeteer-3.4`, the handler must be specified as ` <i>fileName</i>.handler`. For `syn-python-selenium-1.1`, `syn-nodejs.puppeteer-3.4`, and later runtimes, the handler can be specified as ` <i>fileName</i>.<i>functionName</i> `, or you can specify a folder where canary scripts reside as ` <i>folder</i>/<i>fileName</i>.<i>functionName</i> `.
         */
        public var handler: kotlin.String? = null
        /**
         * If your canary script is located in S3, specify the bucket name here. Do not include `s3://` as the start of the bucket name.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The S3 key of your script. For more information, see [Working with Amazon S3 Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html).
         */
        public var s3Key: kotlin.String? = null
        /**
         * The S3 version ID of your script.
         */
        public var s3Version: kotlin.String? = null
        /**
         * If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the base64-encoded contents of the .zip file that contains the script. It must be smaller than 225 Kb.
         *
         * For large canary scripts, we recommend that you use an S3 location instead of inputting it directly with this parameter.
         */
        public var zipFile: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.CanaryCodeInput) : this() {
            this.handler = x.handler
            this.s3Bucket = x.s3Bucket
            this.s3Key = x.s3Key
            this.s3Version = x.s3Version
            this.zipFile = x.zipFile
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.CanaryCodeInput = CanaryCodeInput(this)
    }
}
