// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.synthetics.model.Canary
import aws.sdk.kotlin.services.synthetics.model.GetCanaryResponse
import aws.sdk.kotlin.services.synthetics.model.SyntheticsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCanaryOperationDeserializer: HttpDeserialize<GetCanaryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCanaryResponse {
        if (!response.status.isSuccess()) {
            throwGetCanaryError(context, response)
        }
        val builder = GetCanaryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCanaryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetCanaryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SyntheticsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SyntheticsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCanaryOperationBody(builder: GetCanaryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CANARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Canary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CANARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CANARY_DESCRIPTOR.index -> builder.canary = deserializeCanaryDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
