// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.paginators

import aws.sdk.kotlin.services.synthetics.SyntheticsClient
import aws.sdk.kotlin.services.synthetics.model.DescribeCanariesLastRunRequest
import aws.sdk.kotlin.services.synthetics.model.DescribeCanariesLastRunResponse
import aws.sdk.kotlin.services.synthetics.model.DescribeCanariesRequest
import aws.sdk.kotlin.services.synthetics.model.DescribeCanariesResponse
import aws.sdk.kotlin.services.synthetics.model.DescribeRuntimeVersionsRequest
import aws.sdk.kotlin.services.synthetics.model.DescribeRuntimeVersionsResponse
import aws.sdk.kotlin.services.synthetics.model.GetCanaryRunsRequest
import aws.sdk.kotlin.services.synthetics.model.GetCanaryRunsResponse
import aws.sdk.kotlin.services.synthetics.model.ListAssociatedGroupsRequest
import aws.sdk.kotlin.services.synthetics.model.ListAssociatedGroupsResponse
import aws.sdk.kotlin.services.synthetics.model.ListGroupResourcesRequest
import aws.sdk.kotlin.services.synthetics.model.ListGroupResourcesResponse
import aws.sdk.kotlin.services.synthetics.model.ListGroupsRequest
import aws.sdk.kotlin.services.synthetics.model.ListGroupsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeCanariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCanariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCanariesResponse]
 */
public fun SyntheticsClient.describeCanariesPaginated(initialRequest: DescribeCanariesRequest): Flow<DescribeCanariesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeCanariesPaginated.describeCanaries(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCanariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCanariesResponse]
 */
public fun SyntheticsClient.describeCanariesPaginated(block: DescribeCanariesRequest.Builder.() -> Unit): Flow<DescribeCanariesResponse> =
    describeCanariesPaginated(DescribeCanariesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeCanariesLastRunResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCanariesLastRunRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCanariesLastRunResponse]
 */
public fun SyntheticsClient.describeCanariesLastRunPaginated(initialRequest: DescribeCanariesLastRunRequest): Flow<DescribeCanariesLastRunResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeCanariesLastRunPaginated.describeCanariesLastRun(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCanariesLastRunResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCanariesLastRunResponse]
 */
public fun SyntheticsClient.describeCanariesLastRunPaginated(block: DescribeCanariesLastRunRequest.Builder.() -> Unit): Flow<DescribeCanariesLastRunResponse> =
    describeCanariesLastRunPaginated(DescribeCanariesLastRunRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeRuntimeVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeRuntimeVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRuntimeVersionsResponse]
 */
public fun SyntheticsClient.describeRuntimeVersionsPaginated(initialRequest: DescribeRuntimeVersionsRequest): Flow<DescribeRuntimeVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeRuntimeVersionsPaginated.describeRuntimeVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeRuntimeVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRuntimeVersionsResponse]
 */
public fun SyntheticsClient.describeRuntimeVersionsPaginated(block: DescribeRuntimeVersionsRequest.Builder.() -> Unit): Flow<DescribeRuntimeVersionsResponse> =
    describeRuntimeVersionsPaginated(DescribeRuntimeVersionsRequest.Builder().apply(block).build())

/**
 * Paginate over [GetCanaryRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCanaryRunsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCanaryRunsResponse]
 */
public fun SyntheticsClient.getCanaryRunsPaginated(initialRequest: GetCanaryRunsRequest): Flow<GetCanaryRunsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCanaryRunsPaginated.getCanaryRuns(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetCanaryRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCanaryRunsResponse]
 */
public fun SyntheticsClient.getCanaryRunsPaginated(block: GetCanaryRunsRequest.Builder.() -> Unit): Flow<GetCanaryRunsResponse> =
    getCanaryRunsPaginated(GetCanaryRunsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAssociatedGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssociatedGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedGroupsResponse]
 */
public fun SyntheticsClient.listAssociatedGroupsPaginated(initialRequest: ListAssociatedGroupsRequest): Flow<ListAssociatedGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssociatedGroupsPaginated.listAssociatedGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssociatedGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedGroupsResponse]
 */
public fun SyntheticsClient.listAssociatedGroupsPaginated(block: ListAssociatedGroupsRequest.Builder.() -> Unit): Flow<ListAssociatedGroupsResponse> =
    listAssociatedGroupsPaginated(ListAssociatedGroupsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListGroupResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupResourcesResponse]
 */
public fun SyntheticsClient.listGroupResourcesPaginated(initialRequest: ListGroupResourcesRequest): Flow<ListGroupResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupResourcesPaginated.listGroupResources(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupResourcesResponse]
 */
public fun SyntheticsClient.listGroupResourcesPaginated(block: ListGroupResourcesRequest.Builder.() -> Unit): Flow<ListGroupResourcesResponse> =
    listGroupResourcesPaginated(ListGroupResourcesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun SyntheticsClient.listGroupsPaginated(initialRequest: ListGroupsRequest): Flow<ListGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupsPaginated.listGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun SyntheticsClient.listGroupsPaginated(block: ListGroupsRequest.Builder.() -> Unit): Flow<ListGroupsResponse> =
    listGroupsPaginated(ListGroupsRequest.Builder().apply(block).build())
