// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.synthetics.model



/**
 * How long, in seconds, for the canary to continue making regular runs according to the schedule in the `Expression` value.
 */
public class CanaryScheduleOutput private constructor(builder: Builder) {
    /**
     * How long, in seconds, for the canary to continue making regular runs after it was created. The runs are performed according to the schedule in the `Expression` value.
     */
    public val durationInSeconds: kotlin.Long? = builder.durationInSeconds
    /**
     * A `rate` expression or a `cron` expression that defines how often the canary is to run.
     *
     * For a rate expression, The syntax is `rate(<i>number unit</i>)`. *unit* can be `minute`, `minutes`, or `hour`.
     *
     * For example, `rate(1 minute)` runs the canary once a minute, `rate(10 minutes)` runs it once every 10 minutes, and `rate(1 hour)` runs it once every hour. You can specify a frequency between `rate(1 minute)` and `rate(1 hour)`.
     *
     * Specifying `rate(0 minute)` or `rate(0 hour)` is a special value that causes the canary to run only once when it is started.
     *
     * Use `cron(<i>expression</i>)` to specify a cron expression. For information about the syntax for cron expressions, see [ Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
     */
    public val expression: kotlin.String? = builder.expression

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.synthetics.model.CanaryScheduleOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CanaryScheduleOutput(")
        append("durationInSeconds=$durationInSeconds,")
        append("expression=$expression)")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationInSeconds?.hashCode() ?: 0
        result = 31 * result + (expression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CanaryScheduleOutput

        if (durationInSeconds != other.durationInSeconds) return false
        if (expression != other.expression) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.synthetics.model.CanaryScheduleOutput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * How long, in seconds, for the canary to continue making regular runs after it was created. The runs are performed according to the schedule in the `Expression` value.
         */
        public var durationInSeconds: kotlin.Long? = null
        /**
         * A `rate` expression or a `cron` expression that defines how often the canary is to run.
         *
         * For a rate expression, The syntax is `rate(<i>number unit</i>)`. *unit* can be `minute`, `minutes`, or `hour`.
         *
         * For example, `rate(1 minute)` runs the canary once a minute, `rate(10 minutes)` runs it once every 10 minutes, and `rate(1 hour)` runs it once every hour. You can specify a frequency between `rate(1 minute)` and `rate(1 hour)`.
         *
         * Specifying `rate(0 minute)` or `rate(0 hour)` is a special value that causes the canary to run only once when it is started.
         *
         * Use `cron(<i>expression</i>)` to specify a cron expression. For information about the syntax for cron expressions, see [ Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
         */
        public var expression: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.synthetics.model.CanaryScheduleOutput) : this() {
            this.durationInSeconds = x.durationInSeconds
            this.expression = x.expression
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.synthetics.model.CanaryScheduleOutput = CanaryScheduleOutput(this)
    }
}
