// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



public class RegisterActivityTypeRequest private constructor(builder: Builder) {
    /**
     * If set, specifies the default maximum time before which a worker processing a task of this type must report progress by calling RecordActivityTaskHeartbeat. If the timeout is exceeded, the activity task is automatically timed out. This default can be overridden when scheduling an activity task using the `ScheduleActivityTask`Decision. If the activity worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an `UnknownResource` fault. In this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should clean up the activity task.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val defaultTaskHeartbeatTimeout: kotlin.String? = builder.defaultTaskHeartbeatTimeout
    /**
     * If set, specifies the default task list to use for scheduling tasks of this activity type. This default task list is used if a task list isn't provided when a task is scheduled through the `ScheduleActivityTask`Decision.
     */
    public val defaultTaskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.defaultTaskList
    /**
     * The default task priority to assign to the activity type. If not assigned, then `0` is used. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
     *
     * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *in the *Amazon SWF Developer Guide*.*.
     */
    public val defaultTaskPriority: kotlin.String? = builder.defaultTaskPriority
    /**
     * If set, specifies the default maximum duration for a task of this activity type. This default can be overridden when scheduling an activity task using the `ScheduleActivityTask`Decision.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val defaultTaskScheduleToCloseTimeout: kotlin.String? = builder.defaultTaskScheduleToCloseTimeout
    /**
     * If set, specifies the default maximum duration that a task of this activity type can wait before being assigned to a worker. This default can be overridden when scheduling an activity task using the `ScheduleActivityTask`Decision.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val defaultTaskScheduleToStartTimeout: kotlin.String? = builder.defaultTaskScheduleToStartTimeout
    /**
     * If set, specifies the default maximum duration that a worker can take to process tasks of this activity type. This default can be overridden when scheduling an activity task using the `ScheduleActivityTask`Decision.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val defaultTaskStartToCloseTimeout: kotlin.String? = builder.defaultTaskStartToCloseTimeout
    /**
     * A textual description of the activity type.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the domain in which this activity is to be registered.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The name of the activity type within the domain.
     *
     * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The version of the activity type.
     *
     * The activity type consists of the name and version, the combination of which must be unique within the domain.
     *
     * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.RegisterActivityTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterActivityTypeRequest(")
        append("defaultTaskHeartbeatTimeout=$defaultTaskHeartbeatTimeout,")
        append("defaultTaskList=$defaultTaskList,")
        append("defaultTaskPriority=$defaultTaskPriority,")
        append("defaultTaskScheduleToCloseTimeout=$defaultTaskScheduleToCloseTimeout,")
        append("defaultTaskScheduleToStartTimeout=$defaultTaskScheduleToStartTimeout,")
        append("defaultTaskStartToCloseTimeout=$defaultTaskStartToCloseTimeout,")
        append("description=$description,")
        append("domain=$domain,")
        append("name=$name,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultTaskHeartbeatTimeout?.hashCode() ?: 0
        result = 31 * result + (defaultTaskList?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskPriority?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskScheduleToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskScheduleToStartTimeout?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterActivityTypeRequest

        if (defaultTaskHeartbeatTimeout != other.defaultTaskHeartbeatTimeout) return false
        if (defaultTaskList != other.defaultTaskList) return false
        if (defaultTaskPriority != other.defaultTaskPriority) return false
        if (defaultTaskScheduleToCloseTimeout != other.defaultTaskScheduleToCloseTimeout) return false
        if (defaultTaskScheduleToStartTimeout != other.defaultTaskScheduleToStartTimeout) return false
        if (defaultTaskStartToCloseTimeout != other.defaultTaskStartToCloseTimeout) return false
        if (description != other.description) return false
        if (domain != other.domain) return false
        if (name != other.name) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.RegisterActivityTypeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If set, specifies the default maximum time before which a worker processing a task of this type must report progress by calling RecordActivityTaskHeartbeat. If the timeout is exceeded, the activity task is automatically timed out. This default can be overridden when scheduling an activity task using the `ScheduleActivityTask`Decision. If the activity worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an `UnknownResource` fault. In this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should clean up the activity task.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var defaultTaskHeartbeatTimeout: kotlin.String? = null
        /**
         * If set, specifies the default task list to use for scheduling tasks of this activity type. This default task list is used if a task list isn't provided when a task is scheduled through the `ScheduleActivityTask`Decision.
         */
        public var defaultTaskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * The default task priority to assign to the activity type. If not assigned, then `0` is used. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
         *
         * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *in the *Amazon SWF Developer Guide*.*.
         */
        public var defaultTaskPriority: kotlin.String? = null
        /**
         * If set, specifies the default maximum duration for a task of this activity type. This default can be overridden when scheduling an activity task using the `ScheduleActivityTask`Decision.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var defaultTaskScheduleToCloseTimeout: kotlin.String? = null
        /**
         * If set, specifies the default maximum duration that a task of this activity type can wait before being assigned to a worker. This default can be overridden when scheduling an activity task using the `ScheduleActivityTask`Decision.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var defaultTaskScheduleToStartTimeout: kotlin.String? = null
        /**
         * If set, specifies the default maximum duration that a worker can take to process tasks of this activity type. This default can be overridden when scheduling an activity task using the `ScheduleActivityTask`Decision.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var defaultTaskStartToCloseTimeout: kotlin.String? = null
        /**
         * A textual description of the activity type.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the domain in which this activity is to be registered.
         */
        public var domain: kotlin.String? = null
        /**
         * The name of the activity type within the domain.
         *
         * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
         */
        public var name: kotlin.String? = null
        /**
         * The version of the activity type.
         *
         * The activity type consists of the name and version, the combination of which must be unique within the domain.
         *
         * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.RegisterActivityTypeRequest) : this() {
            this.defaultTaskHeartbeatTimeout = x.defaultTaskHeartbeatTimeout
            this.defaultTaskList = x.defaultTaskList
            this.defaultTaskPriority = x.defaultTaskPriority
            this.defaultTaskScheduleToCloseTimeout = x.defaultTaskScheduleToCloseTimeout
            this.defaultTaskScheduleToStartTimeout = x.defaultTaskScheduleToStartTimeout
            this.defaultTaskStartToCloseTimeout = x.defaultTaskStartToCloseTimeout
            this.description = x.description
            this.domain = x.domain
            this.name = x.name
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.RegisterActivityTypeRequest = RegisterActivityTypeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        public fun defaultTaskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.defaultTaskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }
    }
}
