// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `FailWorkflowExecution` decision.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public class FailWorkflowExecutionDecisionAttributes private constructor(builder: Builder) {
    /**
     * Details of the failure.
     */
    public val details: kotlin.String? = builder.details
    /**
     * A descriptive reason for the failure that may help in diagnostics.
     */
    public val reason: kotlin.String? = builder.reason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionDecisionAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FailWorkflowExecutionDecisionAttributes(")
        append("details=$details,")
        append("reason=$reason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = details?.hashCode() ?: 0
        result = 31 * result + (reason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FailWorkflowExecutionDecisionAttributes

        if (details != other.details) return false
        if (reason != other.reason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionDecisionAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Details of the failure.
         */
        public var details: kotlin.String? = null
        /**
         * A descriptive reason for the failure that may help in diagnostics.
         */
        public var reason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionDecisionAttributes) : this() {
            this.details = x.details
            this.reason = x.reason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionDecisionAttributes = FailWorkflowExecutionDecisionAttributes(this)
    }
}
