// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides details of `WorkflowExecutionStarted` event.
 */
public class WorkflowExecutionStartedEventAttributes private constructor(builder: Builder) {
    /**
     * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout.
     *
     * The supported child policies are:
     * + `TERMINATE` – The child executions are terminated.
     * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
     * + `ABANDON` – No action is taken. The child executions continue to run.
     */
    public val childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy = requireNotNull(builder.childPolicy) { "A non-null value must be provided for childPolicy" }
    /**
     * If this workflow execution was started due to a `ContinueAsNewWorkflowExecution` decision, then it contains the `runId` of the previous workflow execution that was closed and continued as this execution.
     */
    public val continuedExecutionRunId: kotlin.String? = builder.continuedExecutionRunId
    /**
     * The maximum duration for this workflow execution.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val executionStartToCloseTimeout: kotlin.String? = builder.executionStartToCloseTimeout
    /**
     * The input provided to the workflow execution.
     */
    public val input: kotlin.String? = builder.input
    /**
     * The IAM role attached to the workflow execution.
     */
    public val lambdaRole: kotlin.String? = builder.lambdaRole
    /**
     * The ID of the `StartChildWorkflowExecutionInitiated` event corresponding to the `StartChildWorkflowExecution`Decision to start this workflow execution. The source event with this ID can be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public val parentInitiatedEventId: kotlin.Long = builder.parentInitiatedEventId
    /**
     * The source workflow execution that started this workflow execution. The member isn't set if the workflow execution was not started by a workflow.
     */
    public val parentWorkflowExecution: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = builder.parentWorkflowExecution
    /**
     * The list of tags associated with this workflow execution. An execution can have up to 5 tags.
     */
    public val tagList: List<String>? = builder.tagList
    /**
     * The name of the task list for scheduling the decision tasks for this workflow execution.
     */
    public val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList
    /**
     * The priority of the decision tasks in the workflow execution.
     */
    public val taskPriority: kotlin.String? = builder.taskPriority
    /**
     * The maximum duration of decision tasks for this workflow type.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val taskStartToCloseTimeout: kotlin.String? = builder.taskStartToCloseTimeout
    /**
     * The workflow type of this execution.
     */
    public val workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = builder.workflowType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.WorkflowExecutionStartedEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkflowExecutionStartedEventAttributes(")
        append("childPolicy=$childPolicy,")
        append("continuedExecutionRunId=$continuedExecutionRunId,")
        append("executionStartToCloseTimeout=$executionStartToCloseTimeout,")
        append("input=$input,")
        append("lambdaRole=$lambdaRole,")
        append("parentInitiatedEventId=$parentInitiatedEventId,")
        append("parentWorkflowExecution=$parentWorkflowExecution,")
        append("tagList=$tagList,")
        append("taskList=$taskList,")
        append("taskPriority=$taskPriority,")
        append("taskStartToCloseTimeout=$taskStartToCloseTimeout,")
        append("workflowType=$workflowType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = childPolicy.hashCode()
        result = 31 * result + (continuedExecutionRunId?.hashCode() ?: 0)
        result = 31 * result + (executionStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (lambdaRole?.hashCode() ?: 0)
        result = 31 * result + (parentInitiatedEventId.hashCode())
        result = 31 * result + (parentWorkflowExecution?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (taskList?.hashCode() ?: 0)
        result = 31 * result + (taskPriority?.hashCode() ?: 0)
        result = 31 * result + (taskStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (workflowType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkflowExecutionStartedEventAttributes

        if (childPolicy != other.childPolicy) return false
        if (continuedExecutionRunId != other.continuedExecutionRunId) return false
        if (executionStartToCloseTimeout != other.executionStartToCloseTimeout) return false
        if (input != other.input) return false
        if (lambdaRole != other.lambdaRole) return false
        if (parentInitiatedEventId != other.parentInitiatedEventId) return false
        if (parentWorkflowExecution != other.parentWorkflowExecution) return false
        if (tagList != other.tagList) return false
        if (taskList != other.taskList) return false
        if (taskPriority != other.taskPriority) return false
        if (taskStartToCloseTimeout != other.taskStartToCloseTimeout) return false
        if (workflowType != other.workflowType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.WorkflowExecutionStartedEventAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout.
         *
         * The supported child policies are:
         * + `TERMINATE` – The child executions are terminated.
         * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
         * + `ABANDON` – No action is taken. The child executions continue to run.
         */
        public var childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = null
        /**
         * If this workflow execution was started due to a `ContinueAsNewWorkflowExecution` decision, then it contains the `runId` of the previous workflow execution that was closed and continued as this execution.
         */
        public var continuedExecutionRunId: kotlin.String? = null
        /**
         * The maximum duration for this workflow execution.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var executionStartToCloseTimeout: kotlin.String? = null
        /**
         * The input provided to the workflow execution.
         */
        public var input: kotlin.String? = null
        /**
         * The IAM role attached to the workflow execution.
         */
        public var lambdaRole: kotlin.String? = null
        /**
         * The ID of the `StartChildWorkflowExecutionInitiated` event corresponding to the `StartChildWorkflowExecution`Decision to start this workflow execution. The source event with this ID can be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        public var parentInitiatedEventId: kotlin.Long = 0L
        /**
         * The source workflow execution that started this workflow execution. The member isn't set if the workflow execution was not started by a workflow.
         */
        public var parentWorkflowExecution: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = null
        /**
         * The list of tags associated with this workflow execution. An execution can have up to 5 tags.
         */
        public var tagList: List<String>? = null
        /**
         * The name of the task list for scheduling the decision tasks for this workflow execution.
         */
        public var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * The priority of the decision tasks in the workflow execution.
         */
        public var taskPriority: kotlin.String? = null
        /**
         * The maximum duration of decision tasks for this workflow type.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var taskStartToCloseTimeout: kotlin.String? = null
        /**
         * The workflow type of this execution.
         */
        public var workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.WorkflowExecutionStartedEventAttributes) : this() {
            this.childPolicy = x.childPolicy
            this.continuedExecutionRunId = x.continuedExecutionRunId
            this.executionStartToCloseTimeout = x.executionStartToCloseTimeout
            this.input = x.input
            this.lambdaRole = x.lambdaRole
            this.parentInitiatedEventId = x.parentInitiatedEventId
            this.parentWorkflowExecution = x.parentWorkflowExecution
            this.tagList = x.tagList
            this.taskList = x.taskList
            this.taskPriority = x.taskPriority
            this.taskStartToCloseTimeout = x.taskStartToCloseTimeout
            this.workflowType = x.workflowType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.WorkflowExecutionStartedEventAttributes = WorkflowExecutionStartedEventAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecution] inside the given [block]
         */
        public fun parentWorkflowExecution(block: aws.sdk.kotlin.services.swf.model.WorkflowExecution.Builder.() -> kotlin.Unit) {
            this.parentWorkflowExecution = aws.sdk.kotlin.services.swf.model.WorkflowExecution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        public fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowType] inside the given [block]
         */
        public fun workflowType(block: aws.sdk.kotlin.services.swf.model.WorkflowType.Builder.() -> kotlin.Unit) {
            this.workflowType = aws.sdk.kotlin.services.swf.model.WorkflowType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (childPolicy == null) childPolicy = ChildPolicy.SdkUnknown("no value provided")
            return this
        }
    }
}
