// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the details of the `StartTimerFailed` event.
 */
public class StartTimerFailedEventAttributes private constructor(builder: Builder) {
    /**
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     *
     * If `cause` is set to `OPERATION_NOT_PERMITTED`, the decision failed because it lacked sufficient permissions. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public val cause: aws.sdk.kotlin.services.swf.model.StartTimerFailedCause = requireNotNull(builder.cause) { "A non-null value must be provided for cause" }
    /**
     * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `StartTimer` decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public val decisionTaskCompletedEventId: kotlin.Long = builder.decisionTaskCompletedEventId
    /**
     * The timerId provided in the `StartTimer` decision that failed.
     */
    public val timerId: kotlin.String = requireNotNull(builder.timerId) { "A non-null value must be provided for timerId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.StartTimerFailedEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartTimerFailedEventAttributes(")
        append("cause=$cause,")
        append("decisionTaskCompletedEventId=$decisionTaskCompletedEventId,")
        append("timerId=$timerId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cause.hashCode()
        result = 31 * result + (decisionTaskCompletedEventId.hashCode())
        result = 31 * result + (timerId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartTimerFailedEventAttributes

        if (cause != other.cause) return false
        if (decisionTaskCompletedEventId != other.decisionTaskCompletedEventId) return false
        if (timerId != other.timerId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.StartTimerFailedEventAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
         *
         * If `cause` is set to `OPERATION_NOT_PERMITTED`, the decision failed because it lacked sufficient permissions. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
         */
        public var cause: aws.sdk.kotlin.services.swf.model.StartTimerFailedCause? = null
        /**
         * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `StartTimer` decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        public var decisionTaskCompletedEventId: kotlin.Long = 0L
        /**
         * The timerId provided in the `StartTimer` decision that failed.
         */
        public var timerId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.StartTimerFailedEventAttributes) : this() {
            this.cause = x.cause
            this.decisionTaskCompletedEventId = x.decisionTaskCompletedEventId
            this.timerId = x.timerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.StartTimerFailedEventAttributes = StartTimerFailedEventAttributes(this)

        internal fun correctErrors(): Builder {
            if (cause == null) cause = StartTimerFailedCause.SdkUnknown("no value provided")
            if (timerId == null) timerId = ""
            return this
        }
    }
}
