// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the details of the `StartChildWorkflowExecutionInitiated` event.
 */
public class StartChildWorkflowExecutionInitiatedEventAttributes private constructor(builder: Builder) {
    /**
     * The policy to use for the child workflow executions if this execution gets terminated by explicitly calling the TerminateWorkflowExecution action or due to an expired timeout.
     *
     * The supported child policies are:
     * + `TERMINATE` – The child executions are terminated.
     * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
     * + `ABANDON` – No action is taken. The child executions continue to run.
     */
    public val childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy = requireNotNull(builder.childPolicy) { "A non-null value must be provided for childPolicy" }
    /**
     * Data attached to the event that can be used by the decider in subsequent decision tasks. This data isn't sent to the activity.
     */
    public val control: kotlin.String? = builder.control
    /**
     * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `StartChildWorkflowExecution`Decision to request this child workflow execution. This information can be useful for diagnosing problems by tracing back the cause of events.
     */
    public val decisionTaskCompletedEventId: kotlin.Long = builder.decisionTaskCompletedEventId
    /**
     * The maximum duration for the child workflow execution. If the workflow execution isn't closed within this duration, it is timed out and force-terminated.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val executionStartToCloseTimeout: kotlin.String? = builder.executionStartToCloseTimeout
    /**
     * The inputs provided to the child workflow execution.
     */
    public val input: kotlin.String? = builder.input
    /**
     * The IAM role to attach to the child workflow execution.
     */
    public val lambdaRole: kotlin.String? = builder.lambdaRole
    /**
     * The list of tags to associated with the child workflow execution.
     */
    public val tagList: List<String>? = builder.tagList
    /**
     * The name of the task list used for the decision tasks of the child workflow execution.
     */
    public val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList
    /**
     * The priority assigned for the decision tasks for this workflow execution. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
     *
     * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
     */
    public val taskPriority: kotlin.String? = builder.taskPriority
    /**
     * The maximum duration allowed for the decision tasks for this workflow execution.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val taskStartToCloseTimeout: kotlin.String? = builder.taskStartToCloseTimeout
    /**
     * The `workflowId` of the child workflow execution.
     */
    public val workflowId: kotlin.String = requireNotNull(builder.workflowId) { "A non-null value must be provided for workflowId" }
    /**
     * The type of the child workflow execution.
     */
    public val workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = builder.workflowType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartChildWorkflowExecutionInitiatedEventAttributes(")
        append("childPolicy=$childPolicy,")
        append("control=$control,")
        append("decisionTaskCompletedEventId=$decisionTaskCompletedEventId,")
        append("executionStartToCloseTimeout=$executionStartToCloseTimeout,")
        append("input=$input,")
        append("lambdaRole=$lambdaRole,")
        append("tagList=$tagList,")
        append("taskList=$taskList,")
        append("taskPriority=$taskPriority,")
        append("taskStartToCloseTimeout=$taskStartToCloseTimeout,")
        append("workflowId=$workflowId,")
        append("workflowType=$workflowType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = childPolicy.hashCode()
        result = 31 * result + (control?.hashCode() ?: 0)
        result = 31 * result + (decisionTaskCompletedEventId.hashCode())
        result = 31 * result + (executionStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (lambdaRole?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (taskList?.hashCode() ?: 0)
        result = 31 * result + (taskPriority?.hashCode() ?: 0)
        result = 31 * result + (taskStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (workflowId.hashCode())
        result = 31 * result + (workflowType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartChildWorkflowExecutionInitiatedEventAttributes

        if (childPolicy != other.childPolicy) return false
        if (control != other.control) return false
        if (decisionTaskCompletedEventId != other.decisionTaskCompletedEventId) return false
        if (executionStartToCloseTimeout != other.executionStartToCloseTimeout) return false
        if (input != other.input) return false
        if (lambdaRole != other.lambdaRole) return false
        if (tagList != other.tagList) return false
        if (taskList != other.taskList) return false
        if (taskPriority != other.taskPriority) return false
        if (taskStartToCloseTimeout != other.taskStartToCloseTimeout) return false
        if (workflowId != other.workflowId) return false
        if (workflowType != other.workflowType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The policy to use for the child workflow executions if this execution gets terminated by explicitly calling the TerminateWorkflowExecution action or due to an expired timeout.
         *
         * The supported child policies are:
         * + `TERMINATE` – The child executions are terminated.
         * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
         * + `ABANDON` – No action is taken. The child executions continue to run.
         */
        public var childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = null
        /**
         * Data attached to the event that can be used by the decider in subsequent decision tasks. This data isn't sent to the activity.
         */
        public var control: kotlin.String? = null
        /**
         * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `StartChildWorkflowExecution`Decision to request this child workflow execution. This information can be useful for diagnosing problems by tracing back the cause of events.
         */
        public var decisionTaskCompletedEventId: kotlin.Long = 0L
        /**
         * The maximum duration for the child workflow execution. If the workflow execution isn't closed within this duration, it is timed out and force-terminated.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var executionStartToCloseTimeout: kotlin.String? = null
        /**
         * The inputs provided to the child workflow execution.
         */
        public var input: kotlin.String? = null
        /**
         * The IAM role to attach to the child workflow execution.
         */
        public var lambdaRole: kotlin.String? = null
        /**
         * The list of tags to associated with the child workflow execution.
         */
        public var tagList: List<String>? = null
        /**
         * The name of the task list used for the decision tasks of the child workflow execution.
         */
        public var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * The priority assigned for the decision tasks for this workflow execution. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
         *
         * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
         */
        public var taskPriority: kotlin.String? = null
        /**
         * The maximum duration allowed for the decision tasks for this workflow execution.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var taskStartToCloseTimeout: kotlin.String? = null
        /**
         * The `workflowId` of the child workflow execution.
         */
        public var workflowId: kotlin.String? = null
        /**
         * The type of the child workflow execution.
         */
        public var workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes) : this() {
            this.childPolicy = x.childPolicy
            this.control = x.control
            this.decisionTaskCompletedEventId = x.decisionTaskCompletedEventId
            this.executionStartToCloseTimeout = x.executionStartToCloseTimeout
            this.input = x.input
            this.lambdaRole = x.lambdaRole
            this.tagList = x.tagList
            this.taskList = x.taskList
            this.taskPriority = x.taskPriority
            this.taskStartToCloseTimeout = x.taskStartToCloseTimeout
            this.workflowId = x.workflowId
            this.workflowType = x.workflowType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes = StartChildWorkflowExecutionInitiatedEventAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        public fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowType] inside the given [block]
         */
        public fun workflowType(block: aws.sdk.kotlin.services.swf.model.WorkflowType.Builder.() -> kotlin.Unit) {
            this.workflowType = aws.sdk.kotlin.services.swf.model.WorkflowType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (childPolicy == null) childPolicy = ChildPolicy.SdkUnknown("no value provided")
            if (workflowId == null) workflowId = ""
            return this
        }
    }
}
