// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.swf.auth.DefaultSwfAuthSchemeProvider
import aws.sdk.kotlin.services.swf.auth.SwfAuthSchemeProvider
import aws.sdk.kotlin.services.swf.endpoints.DefaultSwfEndpointProvider
import aws.sdk.kotlin.services.swf.endpoints.SwfEndpointParameters
import aws.sdk.kotlin.services.swf.endpoints.SwfEndpointProvider
import aws.sdk.kotlin.services.swf.model.CountClosedWorkflowExecutionsRequest
import aws.sdk.kotlin.services.swf.model.CountClosedWorkflowExecutionsResponse
import aws.sdk.kotlin.services.swf.model.CountOpenWorkflowExecutionsRequest
import aws.sdk.kotlin.services.swf.model.CountOpenWorkflowExecutionsResponse
import aws.sdk.kotlin.services.swf.model.CountPendingActivityTasksRequest
import aws.sdk.kotlin.services.swf.model.CountPendingActivityTasksResponse
import aws.sdk.kotlin.services.swf.model.CountPendingDecisionTasksRequest
import aws.sdk.kotlin.services.swf.model.CountPendingDecisionTasksResponse
import aws.sdk.kotlin.services.swf.model.DeleteActivityTypeRequest
import aws.sdk.kotlin.services.swf.model.DeleteActivityTypeResponse
import aws.sdk.kotlin.services.swf.model.DeleteWorkflowTypeRequest
import aws.sdk.kotlin.services.swf.model.DeleteWorkflowTypeResponse
import aws.sdk.kotlin.services.swf.model.DeprecateActivityTypeRequest
import aws.sdk.kotlin.services.swf.model.DeprecateActivityTypeResponse
import aws.sdk.kotlin.services.swf.model.DeprecateDomainRequest
import aws.sdk.kotlin.services.swf.model.DeprecateDomainResponse
import aws.sdk.kotlin.services.swf.model.DeprecateWorkflowTypeRequest
import aws.sdk.kotlin.services.swf.model.DeprecateWorkflowTypeResponse
import aws.sdk.kotlin.services.swf.model.DescribeActivityTypeRequest
import aws.sdk.kotlin.services.swf.model.DescribeActivityTypeResponse
import aws.sdk.kotlin.services.swf.model.DescribeDomainRequest
import aws.sdk.kotlin.services.swf.model.DescribeDomainResponse
import aws.sdk.kotlin.services.swf.model.DescribeWorkflowExecutionRequest
import aws.sdk.kotlin.services.swf.model.DescribeWorkflowExecutionResponse
import aws.sdk.kotlin.services.swf.model.DescribeWorkflowTypeRequest
import aws.sdk.kotlin.services.swf.model.DescribeWorkflowTypeResponse
import aws.sdk.kotlin.services.swf.model.GetWorkflowExecutionHistoryRequest
import aws.sdk.kotlin.services.swf.model.GetWorkflowExecutionHistoryResponse
import aws.sdk.kotlin.services.swf.model.ListActivityTypesRequest
import aws.sdk.kotlin.services.swf.model.ListActivityTypesResponse
import aws.sdk.kotlin.services.swf.model.ListClosedWorkflowExecutionsRequest
import aws.sdk.kotlin.services.swf.model.ListClosedWorkflowExecutionsResponse
import aws.sdk.kotlin.services.swf.model.ListDomainsRequest
import aws.sdk.kotlin.services.swf.model.ListDomainsResponse
import aws.sdk.kotlin.services.swf.model.ListOpenWorkflowExecutionsRequest
import aws.sdk.kotlin.services.swf.model.ListOpenWorkflowExecutionsResponse
import aws.sdk.kotlin.services.swf.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.swf.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.swf.model.ListWorkflowTypesRequest
import aws.sdk.kotlin.services.swf.model.ListWorkflowTypesResponse
import aws.sdk.kotlin.services.swf.model.PollForActivityTaskRequest
import aws.sdk.kotlin.services.swf.model.PollForActivityTaskResponse
import aws.sdk.kotlin.services.swf.model.PollForDecisionTaskRequest
import aws.sdk.kotlin.services.swf.model.PollForDecisionTaskResponse
import aws.sdk.kotlin.services.swf.model.RecordActivityTaskHeartbeatRequest
import aws.sdk.kotlin.services.swf.model.RecordActivityTaskHeartbeatResponse
import aws.sdk.kotlin.services.swf.model.RegisterActivityTypeRequest
import aws.sdk.kotlin.services.swf.model.RegisterActivityTypeResponse
import aws.sdk.kotlin.services.swf.model.RegisterDomainRequest
import aws.sdk.kotlin.services.swf.model.RegisterDomainResponse
import aws.sdk.kotlin.services.swf.model.RegisterWorkflowTypeRequest
import aws.sdk.kotlin.services.swf.model.RegisterWorkflowTypeResponse
import aws.sdk.kotlin.services.swf.model.RequestCancelWorkflowExecutionRequest
import aws.sdk.kotlin.services.swf.model.RequestCancelWorkflowExecutionResponse
import aws.sdk.kotlin.services.swf.model.RespondActivityTaskCanceledRequest
import aws.sdk.kotlin.services.swf.model.RespondActivityTaskCanceledResponse
import aws.sdk.kotlin.services.swf.model.RespondActivityTaskCompletedRequest
import aws.sdk.kotlin.services.swf.model.RespondActivityTaskCompletedResponse
import aws.sdk.kotlin.services.swf.model.RespondActivityTaskFailedRequest
import aws.sdk.kotlin.services.swf.model.RespondActivityTaskFailedResponse
import aws.sdk.kotlin.services.swf.model.RespondDecisionTaskCompletedRequest
import aws.sdk.kotlin.services.swf.model.RespondDecisionTaskCompletedResponse
import aws.sdk.kotlin.services.swf.model.SignalWorkflowExecutionRequest
import aws.sdk.kotlin.services.swf.model.SignalWorkflowExecutionResponse
import aws.sdk.kotlin.services.swf.model.StartWorkflowExecutionRequest
import aws.sdk.kotlin.services.swf.model.StartWorkflowExecutionResponse
import aws.sdk.kotlin.services.swf.model.TagResourceRequest
import aws.sdk.kotlin.services.swf.model.TagResourceResponse
import aws.sdk.kotlin.services.swf.model.TerminateWorkflowExecutionRequest
import aws.sdk.kotlin.services.swf.model.TerminateWorkflowExecutionResponse
import aws.sdk.kotlin.services.swf.model.UndeprecateActivityTypeRequest
import aws.sdk.kotlin.services.swf.model.UndeprecateActivityTypeResponse
import aws.sdk.kotlin.services.swf.model.UndeprecateDomainRequest
import aws.sdk.kotlin.services.swf.model.UndeprecateDomainResponse
import aws.sdk.kotlin.services.swf.model.UndeprecateWorkflowTypeRequest
import aws.sdk.kotlin.services.swf.model.UndeprecateWorkflowTypeResponse
import aws.sdk.kotlin.services.swf.model.UntagResourceRequest
import aws.sdk.kotlin.services.swf.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SWF"
public const val SdkVersion: String = "1.3.71"
public const val ServiceApiVersion: String = "2012-01-25"

/**
 * # Amazon Simple Workflow Service
 * The Amazon Simple Workflow Service (Amazon SWF) makes it easy to build applications that use Amazon's cloud to coordinate work across distributed components. In Amazon SWF, a *task* represents a logical unit of work that is performed by a component of your workflow. Coordinating tasks in a workflow involves managing intertask dependencies, scheduling, and concurrency in accordance with the logical flow of the application.
 *
 * Amazon SWF gives you full control over implementing tasks and coordinating them without worrying about underlying complexities such as tracking their progress and maintaining their state.
 *
 * This documentation serves as reference only. For a broader overview of the Amazon SWF programming model, see the *[Amazon SWF Developer Guide](https://docs.aws.amazon.com/amazonswf/latest/developerguide/)*.
 */
public interface SwfClient : SdkClient {
    /**
     * SwfClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SwfClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Swf",
                "SWF",
                "swf",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SwfClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SwfClient = DefaultSwfClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SwfEndpointProvider = builder.endpointProvider ?: DefaultSwfEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SwfAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSwfAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SWF"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SwfEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SwfAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Returns the number of closed workflow executions within the given domain that meet the specified filtering criteria.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `tagFilter.tag`: String constraint. The key is `swf:tagFilter.tag`.
     *    + `typeFilter.name`: String constraint. The key is `swf:typeFilter.name`.
     *    + `typeFilter.version`: String constraint. The key is `swf:typeFilter.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun countClosedWorkflowExecutions(input: CountClosedWorkflowExecutionsRequest): CountClosedWorkflowExecutionsResponse

    /**
     * Returns the number of open workflow executions within the given domain that meet the specified filtering criteria.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `tagFilter.tag`: String constraint. The key is `swf:tagFilter.tag`.
     *    + `typeFilter.name`: String constraint. The key is `swf:typeFilter.name`.
     *    + `typeFilter.version`: String constraint. The key is `swf:typeFilter.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun countOpenWorkflowExecutions(input: CountOpenWorkflowExecutionsRequest): CountOpenWorkflowExecutionsResponse

    /**
     * Returns the estimated number of activity tasks in the specified task list. The count returned is an approximation and isn't guaranteed to be exact. If you specify a task list that no activity task was ever scheduled in then `0` is returned.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the `taskList.name` parameter by using a `Condition` element with the `swf:taskList.name` key to allow the action to access only certain task lists.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun countPendingActivityTasks(input: CountPendingActivityTasksRequest): CountPendingActivityTasksResponse

    /**
     * Returns the estimated number of decision tasks in the specified task list. The count returned is an approximation and isn't guaranteed to be exact. If you specify a task list that no decision task was ever scheduled in then `0` is returned.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the `taskList.name` parameter by using a `Condition` element with the `swf:taskList.name` key to allow the action to access only certain task lists.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun countPendingDecisionTasks(input: CountPendingDecisionTasksRequest): CountPendingDecisionTasksResponse

    /**
     * Deletes the specified *activity type*.
     *
     * Note: Prior to deletion, activity types must first be **deprecated**.
     *
     *  After an activity type has been deleted, you cannot schedule new activities of that type. Activities that started before the type was deleted will continue to run.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `activityType.name`: String constraint. The key is `swf:activityType.name`.
     *    + `activityType.version`: String constraint. The key is `swf:activityType.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun deleteActivityType(input: DeleteActivityTypeRequest): DeleteActivityTypeResponse

    /**
     * Deletes the specified *workflow type*.
     *
     * Note: Prior to deletion, workflow types must first be **deprecated**.
     *
     *  After a workflow type has been deleted, you cannot create new executions of that type. Executions that started before the type was deleted will continue to run.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `workflowType.name`: String constraint. The key is `swf:workflowType.name`.
     *    + `workflowType.version`: String constraint. The key is `swf:workflowType.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun deleteWorkflowType(input: DeleteWorkflowTypeRequest): DeleteWorkflowTypeResponse

    /**
     * Deprecates the specified *activity type*. After an activity type has been deprecated, you cannot create new tasks of that activity type. Tasks of this type that were scheduled before the type was deprecated continue to run.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `activityType.name`: String constraint. The key is `swf:activityType.name`.
     *    + `activityType.version`: String constraint. The key is `swf:activityType.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun deprecateActivityType(input: DeprecateActivityTypeRequest): DeprecateActivityTypeResponse

    /**
     * Deprecates the specified domain. After a domain has been deprecated it cannot be used to create new workflow executions or register new types. However, you can still use visibility actions on this domain. Deprecating a domain also deprecates all activity and workflow types registered in the domain. Executions that were started before the domain was deprecated continues to run.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun deprecateDomain(input: DeprecateDomainRequest): DeprecateDomainResponse

    /**
     * Deprecates the specified *workflow type*. After a workflow type has been deprecated, you cannot create new executions of that type. Executions that were started before the type was deprecated continues to run. A deprecated workflow type may still be used when calling visibility actions.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `workflowType.name`: String constraint. The key is `swf:workflowType.name`.
     *    + `workflowType.version`: String constraint. The key is `swf:workflowType.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun deprecateWorkflowType(input: DeprecateWorkflowTypeRequest): DeprecateWorkflowTypeResponse

    /**
     * Returns information about the specified activity type. This includes configuration settings provided when the type was registered and other general information about the type.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `activityType.name`: String constraint. The key is `swf:activityType.name`.
     *    + `activityType.version`: String constraint. The key is `swf:activityType.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun describeActivityType(input: DescribeActivityTypeRequest): DescribeActivityTypeResponse

    /**
     * Returns information about the specified domain, including description and status.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse

    /**
     * Returns information about the specified workflow execution including its type and some statistics.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun describeWorkflowExecution(input: DescribeWorkflowExecutionRequest): DescribeWorkflowExecutionResponse

    /**
     * Returns information about the specified *workflow type*. This includes configuration settings specified when the type was registered and other information such as creation date, current status, etc.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `workflowType.name`: String constraint. The key is `swf:workflowType.name`.
     *    + `workflowType.version`: String constraint. The key is `swf:workflowType.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun describeWorkflowType(input: DescribeWorkflowTypeRequest): DescribeWorkflowTypeResponse

    /**
     * Returns the history of the specified workflow execution. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the `nextPageToken` returned by the initial call.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun getWorkflowExecutionHistory(input: GetWorkflowExecutionHistoryRequest): GetWorkflowExecutionHistoryResponse

    /**
     * Returns information about all activities registered in the specified domain that match the specified name and registration status. The result includes information like creation date, current status of the activity, etc. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the `nextPageToken` returned by the initial call.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun listActivityTypes(input: ListActivityTypesRequest): ListActivityTypesResponse

    /**
     * Returns a list of closed workflow executions in the specified domain that meet the filtering criteria. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `tagFilter.tag`: String constraint. The key is `swf:tagFilter.tag`.
     *    + `typeFilter.name`: String constraint. The key is `swf:typeFilter.name`.
     *    + `typeFilter.version`: String constraint. The key is `swf:typeFilter.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun listClosedWorkflowExecutions(input: ListClosedWorkflowExecutionsRequest): ListClosedWorkflowExecutionsResponse

    /**
     * Returns the list of domains registered in the account. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains. The element must be set to `arn:aws:swf::AccountID:domain&#47;*`, where *AccountID* is the account ID, with no dashes.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun listDomains(input: ListDomainsRequest): ListDomainsResponse

    /**
     * Returns a list of open workflow executions in the specified domain that meet the filtering criteria. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `tagFilter.tag`: String constraint. The key is `swf:tagFilter.tag`.
     *    + `typeFilter.name`: String constraint. The key is `swf:typeFilter.name`.
     *    + `typeFilter.version`: String constraint. The key is `swf:typeFilter.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun listOpenWorkflowExecutions(input: ListOpenWorkflowExecutionsRequest): ListOpenWorkflowExecutionsResponse

    /**
     * List tags for a given domain.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns information about workflow types in the specified domain. The results may be split into multiple pages that can be retrieved by making the call repeatedly.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun listWorkflowTypes(input: ListWorkflowTypesRequest): ListWorkflowTypesResponse

    /**
     * Used by workers to get an ActivityTask from the specified activity `taskList`. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available. The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns an empty result. An empty result, in this context, means that an ActivityTask is returned, but that the value of taskToken is an empty string. If a task is returned, the worker should use its type to identify and process it correctly.
     *
     * Workers should set their client side socket timeout to at least 70 seconds (10 seconds higher than the maximum time service may hold the poll request).
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the `taskList.name` parameter by using a `Condition` element with the `swf:taskList.name` key to allow the action to access only certain task lists.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun pollForActivityTask(input: PollForActivityTaskRequest): PollForActivityTaskResponse

    /**
     * Used by deciders to get a DecisionTask from the specified decision `taskList`. A decision task may be returned for any open workflow execution that is using the specified task list. The task includes a paginated view of the history of the workflow execution. The decider should use the workflow type and the history to determine how to properly handle the task.
     *
     * This action initiates a long poll, where the service holds the HTTP connection open and responds as soon a task becomes available. If no decision task is available in the specified task list before the timeout of 60 seconds expires, an empty result is returned. An empty result, in this context, means that a DecisionTask is returned, but that the value of taskToken is an empty string.
     *
     * Deciders should set their client side socket timeout to at least 70 seconds (10 seconds higher than the timeout).
     *
     * Because the number of workflow history events for a single workflow execution might be very large, the result returned might be split up across a number of pages. To retrieve subsequent pages, make additional calls to `PollForDecisionTask` using the `nextPageToken` returned by the initial call. Note that you do *not* call `GetWorkflowExecutionHistory` with this `nextPageToken`. Instead, call `PollForDecisionTask` again.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the `taskList.name` parameter by using a `Condition` element with the `swf:taskList.name` key to allow the action to access only certain task lists.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun pollForDecisionTask(input: PollForDecisionTaskRequest): PollForDecisionTaskResponse

    /**
     * Used by activity workers to report to the service that the ActivityTask represented by the specified `taskToken` is still making progress. The worker can also specify details of the progress, for example percent complete, using the `details` parameter. This action can also be used by the worker as a mechanism to check if cancellation is being requested for the activity task. If a cancellation is being attempted for the specified task, then the boolean `cancelRequested` flag returned by the service is set to `true`.
     *
     * This action resets the `taskHeartbeatTimeout` clock. The `taskHeartbeatTimeout` is specified in RegisterActivityType.
     *
     * This action doesn't in itself create an event in the workflow execution history. However, if the task times out, the workflow execution history contains a `ActivityTaskTimedOut` event that contains the information from the last heartbeat generated by the activity worker.
     *
     * The `taskStartToCloseTimeout` of an activity type is the maximum duration of an activity task, regardless of the number of RecordActivityTaskHeartbeat requests received. The `taskStartToCloseTimeout` is also specified in RegisterActivityType.
     *
     * This operation is only useful for long-lived activities to report liveliness of the task and to determine if a cancellation is being attempted.
     *
     * If the `cancelRequested` flag returns `true`, a cancellation is being attempted. If the worker can cancel the activity, it should respond with RespondActivityTaskCanceled. Otherwise, it should ignore the cancellation request.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun recordActivityTaskHeartbeat(input: RecordActivityTaskHeartbeatRequest): RecordActivityTaskHeartbeatResponse

    /**
     * Registers a new *activity type* along with its configuration settings in the specified domain.
     *
     * A `TypeAlreadyExists` fault is returned if the type already exists in the domain. You cannot change any configuration settings of the type after its registration, and it must be registered as a new version.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `defaultTaskList.name`: String constraint. The key is `swf:defaultTaskList.name`.
     *    + `name`: String constraint. The key is `swf:name`.
     *    + `version`: String constraint. The key is `swf:version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun registerActivityType(input: RegisterActivityTypeRequest): RegisterActivityTypeResponse

    /**
     * Registers a new domain.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + You cannot use an IAM policy to control domain access for this action. The name of the domain being registered is available as the resource of this action.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun registerDomain(input: RegisterDomainRequest): RegisterDomainResponse

    /**
     * Registers a new *workflow type* and its configuration settings in the specified domain.
     *
     * The retention period for the workflow history is set by the RegisterDomain action.
     *
     * If the type already exists, then a `TypeAlreadyExists` fault is returned. You cannot change the configuration settings of a workflow type once it is registered and it must be registered as a new version.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `defaultTaskList.name`: String constraint. The key is `swf:defaultTaskList.name`.
     *    + `name`: String constraint. The key is `swf:name`.
     *    + `version`: String constraint. The key is `swf:version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun registerWorkflowType(input: RegisterWorkflowTypeRequest): RegisterWorkflowTypeResponse

    /**
     * Records a `WorkflowExecutionCancelRequested` event in the currently running workflow execution identified by the given domain, workflowId, and runId. This logically requests the cancellation of the workflow execution as a whole. It is up to the decider to take appropriate actions when it receives an execution history with this event.
     *
     * If the runId isn't specified, the `WorkflowExecutionCancelRequested` event is recorded in the history of the current open workflow execution with the specified workflowId in the domain.
     *
     * Because this action allows the workflow to properly clean up and gracefully close, it should be used instead of TerminateWorkflowExecution when possible.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun requestCancelWorkflowExecution(input: RequestCancelWorkflowExecutionRequest): RequestCancelWorkflowExecutionResponse

    /**
     * Used by workers to tell the service that the ActivityTask identified by the `taskToken` was successfully canceled. Additional `details` can be provided using the `details` argument.
     *
     * These `details` (if provided) appear in the `ActivityTaskCanceled` event added to the workflow history.
     *
     * Only use this operation if the `canceled` flag of a RecordActivityTaskHeartbeat request returns `true` and if the activity can be safely undone or abandoned.
     *
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as open while a worker is processing it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted, RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has [timed out](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun respondActivityTaskCanceled(input: RespondActivityTaskCanceledRequest): RespondActivityTaskCanceledResponse

    /**
     * Used by workers to tell the service that the ActivityTask identified by the `taskToken` completed successfully with a `result` (if provided). The `result` appears in the `ActivityTaskCompleted` event in the workflow history.
     *
     * If the requested task doesn't complete successfully, use RespondActivityTaskFailed instead. If the worker finds that the task is canceled through the `canceled` flag returned by RecordActivityTaskHeartbeat, it should cancel the task, clean up and then call RespondActivityTaskCanceled.
     *
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as open while a worker is processing it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted, RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has [timed out](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun respondActivityTaskCompleted(input: RespondActivityTaskCompletedRequest): RespondActivityTaskCompletedResponse

    /**
     * Used by workers to tell the service that the ActivityTask identified by the `taskToken` has failed with `reason` (if specified). The `reason` and `details` appear in the `ActivityTaskFailed` event added to the workflow history.
     *
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as open while a worker is processing it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted, RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has [timed out](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun respondActivityTaskFailed(input: RespondActivityTaskFailedRequest): RespondActivityTaskFailedResponse

    /**
     * Used by deciders to tell the service that the DecisionTask identified by the `taskToken` has successfully completed. The `decisions` argument specifies the list of decisions made while processing the task.
     *
     * A `DecisionTaskCompleted` event is added to the workflow history. The `executionContext` specified is attached to the event in the workflow execution history.
     *
     * **Access Control**
     *
     * If an IAM policy grants permission to use `RespondDecisionTaskCompleted`, it can express permissions for the list of decisions in the `decisions` parameter. Each of the decisions has one or more parameters, much like a regular API call. To allow for policies to be as readable as possible, you can express permissions on decisions as if they were actual API calls, including applying conditions to some parameters. For more information, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun respondDecisionTaskCompleted(input: RespondDecisionTaskCompletedRequest): RespondDecisionTaskCompletedResponse

    /**
     * Records a `WorkflowExecutionSignaled` event in the workflow execution history and creates a decision task for the workflow execution identified by the given domain, workflowId and runId. The event is recorded with the specified user defined signalName and input (if provided).
     *
     * If a runId isn't specified, then the `WorkflowExecutionSignaled` event is recorded in the history of the current open workflow with the matching workflowId in the domain.
     *
     * If the specified workflow execution isn't open, this method fails with `UnknownResource`.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun signalWorkflowExecution(input: SignalWorkflowExecutionRequest): SignalWorkflowExecutionResponse

    /**
     * Starts an execution of the workflow type in the specified domain using the provided `workflowId` and input data.
     *
     * This action returns the newly started workflow execution.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `tagList.member.0`: The key is `swf:tagList.member.0`.
     *    + `tagList.member.1`: The key is `swf:tagList.member.1`.
     *    + `tagList.member.2`: The key is `swf:tagList.member.2`.
     *    + `tagList.member.3`: The key is `swf:tagList.member.3`.
     *    + `tagList.member.4`: The key is `swf:tagList.member.4`.
     *    + `taskList`: String constraint. The key is `swf:taskList.name`.
     *    + `workflowType.name`: String constraint. The key is `swf:workflowType.name`.
     *    + `workflowType.version`: String constraint. The key is `swf:workflowType.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun startWorkflowExecution(input: StartWorkflowExecutionRequest): StartWorkflowExecutionResponse

    /**
     * Add a tag to a Amazon SWF domain.
     *
     * Amazon SWF supports a maximum of 50 tags per resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Records a `WorkflowExecutionTerminated` event and forces closure of the workflow execution identified by the given domain, runId, and workflowId. The child policy, registered with the workflow type or specified when starting this execution, is applied to any open child workflow executions of this workflow execution.
     *
     * If the identified workflow execution was in progress, it is terminated immediately.
     *
     * If a runId isn't specified, then the `WorkflowExecutionTerminated` event is recorded in the history of the current open workflow with the matching workflowId in the domain.
     *
     * You should consider using RequestCancelWorkflowExecution action instead because it allows the workflow to gracefully close while TerminateWorkflowExecution doesn't.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun terminateWorkflowExecution(input: TerminateWorkflowExecutionRequest): TerminateWorkflowExecutionResponse

    /**
     * Undeprecates a previously deprecated *activity type*. After an activity type has been undeprecated, you can create new tasks of that activity type.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `activityType.name`: String constraint. The key is `swf:activityType.name`.
     *    + `activityType.version`: String constraint. The key is `swf:activityType.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun undeprecateActivityType(input: UndeprecateActivityTypeRequest): UndeprecateActivityTypeResponse

    /**
     * Undeprecates a previously deprecated domain. After a domain has been undeprecated it can be used to create new workflow executions or register new types.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + You cannot use an IAM policy to constrain this action's parameters.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun undeprecateDomain(input: UndeprecateDomainRequest): UndeprecateDomainResponse

    /**
     * Undeprecates a previously deprecated *workflow type*. After a workflow type has been undeprecated, you can create new executions of that type.
     *
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
     *
     * **Access Control**
     *
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * + Use a `Resource` element with the domain name to limit the action to only specified domains.
     * + Use an `Action` element to allow or deny permission to call this action.
     * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
     *    + `workflowType.name`: String constraint. The key is `swf:workflowType.name`.
     *    + `workflowType.version`: String constraint. The key is `swf:workflowType.version`.
     *
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public suspend fun undeprecateWorkflowType(input: UndeprecateWorkflowTypeRequest): UndeprecateWorkflowTypeResponse

    /**
     * Remove a tag from a Amazon SWF domain.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SwfClient.withConfig(block: SwfClient.Config.Builder.() -> Unit): SwfClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSwfClient(newConfig)
}

/**
 * Returns the number of closed workflow executions within the given domain that meet the specified filtering criteria.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `tagFilter.tag`: String constraint. The key is `swf:tagFilter.tag`.
 *    + `typeFilter.name`: String constraint. The key is `swf:typeFilter.name`.
 *    + `typeFilter.version`: String constraint. The key is `swf:typeFilter.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.countClosedWorkflowExecutions(crossinline block: CountClosedWorkflowExecutionsRequest.Builder.() -> Unit): CountClosedWorkflowExecutionsResponse = countClosedWorkflowExecutions(CountClosedWorkflowExecutionsRequest.Builder().apply(block).build())

/**
 * Returns the number of open workflow executions within the given domain that meet the specified filtering criteria.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `tagFilter.tag`: String constraint. The key is `swf:tagFilter.tag`.
 *    + `typeFilter.name`: String constraint. The key is `swf:typeFilter.name`.
 *    + `typeFilter.version`: String constraint. The key is `swf:typeFilter.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.countOpenWorkflowExecutions(crossinline block: CountOpenWorkflowExecutionsRequest.Builder.() -> Unit): CountOpenWorkflowExecutionsResponse = countOpenWorkflowExecutions(CountOpenWorkflowExecutionsRequest.Builder().apply(block).build())

/**
 * Returns the estimated number of activity tasks in the specified task list. The count returned is an approximation and isn't guaranteed to be exact. If you specify a task list that no activity task was ever scheduled in then `0` is returned.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the `taskList.name` parameter by using a `Condition` element with the `swf:taskList.name` key to allow the action to access only certain task lists.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.countPendingActivityTasks(crossinline block: CountPendingActivityTasksRequest.Builder.() -> Unit): CountPendingActivityTasksResponse = countPendingActivityTasks(CountPendingActivityTasksRequest.Builder().apply(block).build())

/**
 * Returns the estimated number of decision tasks in the specified task list. The count returned is an approximation and isn't guaranteed to be exact. If you specify a task list that no decision task was ever scheduled in then `0` is returned.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the `taskList.name` parameter by using a `Condition` element with the `swf:taskList.name` key to allow the action to access only certain task lists.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.countPendingDecisionTasks(crossinline block: CountPendingDecisionTasksRequest.Builder.() -> Unit): CountPendingDecisionTasksResponse = countPendingDecisionTasks(CountPendingDecisionTasksRequest.Builder().apply(block).build())

/**
 * Deletes the specified *activity type*.
 *
 * Note: Prior to deletion, activity types must first be **deprecated**.
 *
 *  After an activity type has been deleted, you cannot schedule new activities of that type. Activities that started before the type was deleted will continue to run.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `activityType.name`: String constraint. The key is `swf:activityType.name`.
 *    + `activityType.version`: String constraint. The key is `swf:activityType.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.deleteActivityType(crossinline block: DeleteActivityTypeRequest.Builder.() -> Unit): DeleteActivityTypeResponse = deleteActivityType(DeleteActivityTypeRequest.Builder().apply(block).build())

/**
 * Deletes the specified *workflow type*.
 *
 * Note: Prior to deletion, workflow types must first be **deprecated**.
 *
 *  After a workflow type has been deleted, you cannot create new executions of that type. Executions that started before the type was deleted will continue to run.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `workflowType.name`: String constraint. The key is `swf:workflowType.name`.
 *    + `workflowType.version`: String constraint. The key is `swf:workflowType.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.deleteWorkflowType(crossinline block: DeleteWorkflowTypeRequest.Builder.() -> Unit): DeleteWorkflowTypeResponse = deleteWorkflowType(DeleteWorkflowTypeRequest.Builder().apply(block).build())

/**
 * Deprecates the specified *activity type*. After an activity type has been deprecated, you cannot create new tasks of that activity type. Tasks of this type that were scheduled before the type was deprecated continue to run.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `activityType.name`: String constraint. The key is `swf:activityType.name`.
 *    + `activityType.version`: String constraint. The key is `swf:activityType.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.deprecateActivityType(crossinline block: DeprecateActivityTypeRequest.Builder.() -> Unit): DeprecateActivityTypeResponse = deprecateActivityType(DeprecateActivityTypeRequest.Builder().apply(block).build())

/**
 * Deprecates the specified domain. After a domain has been deprecated it cannot be used to create new workflow executions or register new types. However, you can still use visibility actions on this domain. Deprecating a domain also deprecates all activity and workflow types registered in the domain. Executions that were started before the domain was deprecated continues to run.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.deprecateDomain(crossinline block: DeprecateDomainRequest.Builder.() -> Unit): DeprecateDomainResponse = deprecateDomain(DeprecateDomainRequest.Builder().apply(block).build())

/**
 * Deprecates the specified *workflow type*. After a workflow type has been deprecated, you cannot create new executions of that type. Executions that were started before the type was deprecated continues to run. A deprecated workflow type may still be used when calling visibility actions.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `workflowType.name`: String constraint. The key is `swf:workflowType.name`.
 *    + `workflowType.version`: String constraint. The key is `swf:workflowType.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.deprecateWorkflowType(crossinline block: DeprecateWorkflowTypeRequest.Builder.() -> Unit): DeprecateWorkflowTypeResponse = deprecateWorkflowType(DeprecateWorkflowTypeRequest.Builder().apply(block).build())

/**
 * Returns information about the specified activity type. This includes configuration settings provided when the type was registered and other general information about the type.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `activityType.name`: String constraint. The key is `swf:activityType.name`.
 *    + `activityType.version`: String constraint. The key is `swf:activityType.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.describeActivityType(crossinline block: DescribeActivityTypeRequest.Builder.() -> Unit): DescribeActivityTypeResponse = describeActivityType(DescribeActivityTypeRequest.Builder().apply(block).build())

/**
 * Returns information about the specified domain, including description and status.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.describeDomain(crossinline block: DescribeDomainRequest.Builder.() -> Unit): DescribeDomainResponse = describeDomain(DescribeDomainRequest.Builder().apply(block).build())

/**
 * Returns information about the specified workflow execution including its type and some statistics.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.describeWorkflowExecution(crossinline block: DescribeWorkflowExecutionRequest.Builder.() -> Unit): DescribeWorkflowExecutionResponse = describeWorkflowExecution(DescribeWorkflowExecutionRequest.Builder().apply(block).build())

/**
 * Returns information about the specified *workflow type*. This includes configuration settings specified when the type was registered and other information such as creation date, current status, etc.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `workflowType.name`: String constraint. The key is `swf:workflowType.name`.
 *    + `workflowType.version`: String constraint. The key is `swf:workflowType.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.describeWorkflowType(crossinline block: DescribeWorkflowTypeRequest.Builder.() -> Unit): DescribeWorkflowTypeResponse = describeWorkflowType(DescribeWorkflowTypeRequest.Builder().apply(block).build())

/**
 * Returns the history of the specified workflow execution. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the `nextPageToken` returned by the initial call.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.getWorkflowExecutionHistory(crossinline block: GetWorkflowExecutionHistoryRequest.Builder.() -> Unit): GetWorkflowExecutionHistoryResponse = getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest.Builder().apply(block).build())

/**
 * Returns information about all activities registered in the specified domain that match the specified name and registration status. The result includes information like creation date, current status of the activity, etc. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the `nextPageToken` returned by the initial call.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.listActivityTypes(crossinline block: ListActivityTypesRequest.Builder.() -> Unit): ListActivityTypesResponse = listActivityTypes(ListActivityTypesRequest.Builder().apply(block).build())

/**
 * Returns a list of closed workflow executions in the specified domain that meet the filtering criteria. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `tagFilter.tag`: String constraint. The key is `swf:tagFilter.tag`.
 *    + `typeFilter.name`: String constraint. The key is `swf:typeFilter.name`.
 *    + `typeFilter.version`: String constraint. The key is `swf:typeFilter.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.listClosedWorkflowExecutions(crossinline block: ListClosedWorkflowExecutionsRequest.Builder.() -> Unit): ListClosedWorkflowExecutionsResponse = listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest.Builder().apply(block).build())

/**
 * Returns the list of domains registered in the account. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains. The element must be set to `arn:aws:swf::AccountID:domain&#47;*`, where *AccountID* is the account ID, with no dashes.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.listDomains(crossinline block: ListDomainsRequest.Builder.() -> Unit): ListDomainsResponse = listDomains(ListDomainsRequest.Builder().apply(block).build())

/**
 * Returns a list of open workflow executions in the specified domain that meet the filtering criteria. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `tagFilter.tag`: String constraint. The key is `swf:tagFilter.tag`.
 *    + `typeFilter.name`: String constraint. The key is `swf:typeFilter.name`.
 *    + `typeFilter.version`: String constraint. The key is `swf:typeFilter.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.listOpenWorkflowExecutions(crossinline block: ListOpenWorkflowExecutionsRequest.Builder.() -> Unit): ListOpenWorkflowExecutionsResponse = listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest.Builder().apply(block).build())

/**
 * List tags for a given domain.
 */
public suspend inline fun SwfClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns information about workflow types in the specified domain. The results may be split into multiple pages that can be retrieved by making the call repeatedly.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.listWorkflowTypes(crossinline block: ListWorkflowTypesRequest.Builder.() -> Unit): ListWorkflowTypesResponse = listWorkflowTypes(ListWorkflowTypesRequest.Builder().apply(block).build())

/**
 * Used by workers to get an ActivityTask from the specified activity `taskList`. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available. The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns an empty result. An empty result, in this context, means that an ActivityTask is returned, but that the value of taskToken is an empty string. If a task is returned, the worker should use its type to identify and process it correctly.
 *
 * Workers should set their client side socket timeout to at least 70 seconds (10 seconds higher than the maximum time service may hold the poll request).
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the `taskList.name` parameter by using a `Condition` element with the `swf:taskList.name` key to allow the action to access only certain task lists.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.pollForActivityTask(crossinline block: PollForActivityTaskRequest.Builder.() -> Unit): PollForActivityTaskResponse = pollForActivityTask(PollForActivityTaskRequest.Builder().apply(block).build())

/**
 * Used by deciders to get a DecisionTask from the specified decision `taskList`. A decision task may be returned for any open workflow execution that is using the specified task list. The task includes a paginated view of the history of the workflow execution. The decider should use the workflow type and the history to determine how to properly handle the task.
 *
 * This action initiates a long poll, where the service holds the HTTP connection open and responds as soon a task becomes available. If no decision task is available in the specified task list before the timeout of 60 seconds expires, an empty result is returned. An empty result, in this context, means that a DecisionTask is returned, but that the value of taskToken is an empty string.
 *
 * Deciders should set their client side socket timeout to at least 70 seconds (10 seconds higher than the timeout).
 *
 * Because the number of workflow history events for a single workflow execution might be very large, the result returned might be split up across a number of pages. To retrieve subsequent pages, make additional calls to `PollForDecisionTask` using the `nextPageToken` returned by the initial call. Note that you do *not* call `GetWorkflowExecutionHistory` with this `nextPageToken`. Instead, call `PollForDecisionTask` again.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the `taskList.name` parameter by using a `Condition` element with the `swf:taskList.name` key to allow the action to access only certain task lists.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.pollForDecisionTask(crossinline block: PollForDecisionTaskRequest.Builder.() -> Unit): PollForDecisionTaskResponse = pollForDecisionTask(PollForDecisionTaskRequest.Builder().apply(block).build())

/**
 * Used by activity workers to report to the service that the ActivityTask represented by the specified `taskToken` is still making progress. The worker can also specify details of the progress, for example percent complete, using the `details` parameter. This action can also be used by the worker as a mechanism to check if cancellation is being requested for the activity task. If a cancellation is being attempted for the specified task, then the boolean `cancelRequested` flag returned by the service is set to `true`.
 *
 * This action resets the `taskHeartbeatTimeout` clock. The `taskHeartbeatTimeout` is specified in RegisterActivityType.
 *
 * This action doesn't in itself create an event in the workflow execution history. However, if the task times out, the workflow execution history contains a `ActivityTaskTimedOut` event that contains the information from the last heartbeat generated by the activity worker.
 *
 * The `taskStartToCloseTimeout` of an activity type is the maximum duration of an activity task, regardless of the number of RecordActivityTaskHeartbeat requests received. The `taskStartToCloseTimeout` is also specified in RegisterActivityType.
 *
 * This operation is only useful for long-lived activities to report liveliness of the task and to determine if a cancellation is being attempted.
 *
 * If the `cancelRequested` flag returns `true`, a cancellation is being attempted. If the worker can cancel the activity, it should respond with RespondActivityTaskCanceled. Otherwise, it should ignore the cancellation request.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.recordActivityTaskHeartbeat(crossinline block: RecordActivityTaskHeartbeatRequest.Builder.() -> Unit): RecordActivityTaskHeartbeatResponse = recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest.Builder().apply(block).build())

/**
 * Registers a new *activity type* along with its configuration settings in the specified domain.
 *
 * A `TypeAlreadyExists` fault is returned if the type already exists in the domain. You cannot change any configuration settings of the type after its registration, and it must be registered as a new version.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `defaultTaskList.name`: String constraint. The key is `swf:defaultTaskList.name`.
 *    + `name`: String constraint. The key is `swf:name`.
 *    + `version`: String constraint. The key is `swf:version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.registerActivityType(crossinline block: RegisterActivityTypeRequest.Builder.() -> Unit): RegisterActivityTypeResponse = registerActivityType(RegisterActivityTypeRequest.Builder().apply(block).build())

/**
 * Registers a new domain.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + You cannot use an IAM policy to control domain access for this action. The name of the domain being registered is available as the resource of this action.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.registerDomain(crossinline block: RegisterDomainRequest.Builder.() -> Unit): RegisterDomainResponse = registerDomain(RegisterDomainRequest.Builder().apply(block).build())

/**
 * Registers a new *workflow type* and its configuration settings in the specified domain.
 *
 * The retention period for the workflow history is set by the RegisterDomain action.
 *
 * If the type already exists, then a `TypeAlreadyExists` fault is returned. You cannot change the configuration settings of a workflow type once it is registered and it must be registered as a new version.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `defaultTaskList.name`: String constraint. The key is `swf:defaultTaskList.name`.
 *    + `name`: String constraint. The key is `swf:name`.
 *    + `version`: String constraint. The key is `swf:version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.registerWorkflowType(crossinline block: RegisterWorkflowTypeRequest.Builder.() -> Unit): RegisterWorkflowTypeResponse = registerWorkflowType(RegisterWorkflowTypeRequest.Builder().apply(block).build())

/**
 * Records a `WorkflowExecutionCancelRequested` event in the currently running workflow execution identified by the given domain, workflowId, and runId. This logically requests the cancellation of the workflow execution as a whole. It is up to the decider to take appropriate actions when it receives an execution history with this event.
 *
 * If the runId isn't specified, the `WorkflowExecutionCancelRequested` event is recorded in the history of the current open workflow execution with the specified workflowId in the domain.
 *
 * Because this action allows the workflow to properly clean up and gracefully close, it should be used instead of TerminateWorkflowExecution when possible.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.requestCancelWorkflowExecution(crossinline block: RequestCancelWorkflowExecutionRequest.Builder.() -> Unit): RequestCancelWorkflowExecutionResponse = requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest.Builder().apply(block).build())

/**
 * Used by workers to tell the service that the ActivityTask identified by the `taskToken` was successfully canceled. Additional `details` can be provided using the `details` argument.
 *
 * These `details` (if provided) appear in the `ActivityTaskCanceled` event added to the workflow history.
 *
 * Only use this operation if the `canceled` flag of a RecordActivityTaskHeartbeat request returns `true` and if the activity can be safely undone or abandoned.
 *
 * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as open while a worker is processing it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted, RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has [timed out](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.respondActivityTaskCanceled(crossinline block: RespondActivityTaskCanceledRequest.Builder.() -> Unit): RespondActivityTaskCanceledResponse = respondActivityTaskCanceled(RespondActivityTaskCanceledRequest.Builder().apply(block).build())

/**
 * Used by workers to tell the service that the ActivityTask identified by the `taskToken` completed successfully with a `result` (if provided). The `result` appears in the `ActivityTaskCompleted` event in the workflow history.
 *
 * If the requested task doesn't complete successfully, use RespondActivityTaskFailed instead. If the worker finds that the task is canceled through the `canceled` flag returned by RecordActivityTaskHeartbeat, it should cancel the task, clean up and then call RespondActivityTaskCanceled.
 *
 * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as open while a worker is processing it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted, RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has [timed out](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.respondActivityTaskCompleted(crossinline block: RespondActivityTaskCompletedRequest.Builder.() -> Unit): RespondActivityTaskCompletedResponse = respondActivityTaskCompleted(RespondActivityTaskCompletedRequest.Builder().apply(block).build())

/**
 * Used by workers to tell the service that the ActivityTask identified by the `taskToken` has failed with `reason` (if specified). The `reason` and `details` appear in the `ActivityTaskFailed` event added to the workflow history.
 *
 * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as open while a worker is processing it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted, RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has [timed out](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.respondActivityTaskFailed(crossinline block: RespondActivityTaskFailedRequest.Builder.() -> Unit): RespondActivityTaskFailedResponse = respondActivityTaskFailed(RespondActivityTaskFailedRequest.Builder().apply(block).build())

/**
 * Used by deciders to tell the service that the DecisionTask identified by the `taskToken` has successfully completed. The `decisions` argument specifies the list of decisions made while processing the task.
 *
 * A `DecisionTaskCompleted` event is added to the workflow history. The `executionContext` specified is attached to the event in the workflow execution history.
 *
 * **Access Control**
 *
 * If an IAM policy grants permission to use `RespondDecisionTaskCompleted`, it can express permissions for the list of decisions in the `decisions` parameter. Each of the decisions has one or more parameters, much like a regular API call. To allow for policies to be as readable as possible, you can express permissions on decisions as if they were actual API calls, including applying conditions to some parameters. For more information, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.respondDecisionTaskCompleted(crossinline block: RespondDecisionTaskCompletedRequest.Builder.() -> Unit): RespondDecisionTaskCompletedResponse = respondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest.Builder().apply(block).build())

/**
 * Records a `WorkflowExecutionSignaled` event in the workflow execution history and creates a decision task for the workflow execution identified by the given domain, workflowId and runId. The event is recorded with the specified user defined signalName and input (if provided).
 *
 * If a runId isn't specified, then the `WorkflowExecutionSignaled` event is recorded in the history of the current open workflow with the matching workflowId in the domain.
 *
 * If the specified workflow execution isn't open, this method fails with `UnknownResource`.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.signalWorkflowExecution(crossinline block: SignalWorkflowExecutionRequest.Builder.() -> Unit): SignalWorkflowExecutionResponse = signalWorkflowExecution(SignalWorkflowExecutionRequest.Builder().apply(block).build())

/**
 * Starts an execution of the workflow type in the specified domain using the provided `workflowId` and input data.
 *
 * This action returns the newly started workflow execution.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `tagList.member.0`: The key is `swf:tagList.member.0`.
 *    + `tagList.member.1`: The key is `swf:tagList.member.1`.
 *    + `tagList.member.2`: The key is `swf:tagList.member.2`.
 *    + `tagList.member.3`: The key is `swf:tagList.member.3`.
 *    + `tagList.member.4`: The key is `swf:tagList.member.4`.
 *    + `taskList`: String constraint. The key is `swf:taskList.name`.
 *    + `workflowType.name`: String constraint. The key is `swf:workflowType.name`.
 *    + `workflowType.version`: String constraint. The key is `swf:workflowType.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.startWorkflowExecution(crossinline block: StartWorkflowExecutionRequest.Builder.() -> Unit): StartWorkflowExecutionResponse = startWorkflowExecution(StartWorkflowExecutionRequest.Builder().apply(block).build())

/**
 * Add a tag to a Amazon SWF domain.
 *
 * Amazon SWF supports a maximum of 50 tags per resource.
 */
public suspend inline fun SwfClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Records a `WorkflowExecutionTerminated` event and forces closure of the workflow execution identified by the given domain, runId, and workflowId. The child policy, registered with the workflow type or specified when starting this execution, is applied to any open child workflow executions of this workflow execution.
 *
 * If the identified workflow execution was in progress, it is terminated immediately.
 *
 * If a runId isn't specified, then the `WorkflowExecutionTerminated` event is recorded in the history of the current open workflow with the matching workflowId in the domain.
 *
 * You should consider using RequestCancelWorkflowExecution action instead because it allows the workflow to gracefully close while TerminateWorkflowExecution doesn't.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.terminateWorkflowExecution(crossinline block: TerminateWorkflowExecutionRequest.Builder.() -> Unit): TerminateWorkflowExecutionResponse = terminateWorkflowExecution(TerminateWorkflowExecutionRequest.Builder().apply(block).build())

/**
 * Undeprecates a previously deprecated *activity type*. After an activity type has been undeprecated, you can create new tasks of that activity type.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `activityType.name`: String constraint. The key is `swf:activityType.name`.
 *    + `activityType.version`: String constraint. The key is `swf:activityType.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.undeprecateActivityType(crossinline block: UndeprecateActivityTypeRequest.Builder.() -> Unit): UndeprecateActivityTypeResponse = undeprecateActivityType(UndeprecateActivityTypeRequest.Builder().apply(block).build())

/**
 * Undeprecates a previously deprecated domain. After a domain has been undeprecated it can be used to create new workflow executions or register new types.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.undeprecateDomain(crossinline block: UndeprecateDomainRequest.Builder.() -> Unit): UndeprecateDomainResponse = undeprecateDomain(UndeprecateDomainRequest.Builder().apply(block).build())

/**
 * Undeprecates a previously deprecated *workflow type*. After a workflow type has been undeprecated, you can create new executions of that type.
 *
 * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `workflowType.name`: String constraint. The key is `swf:workflowType.name`.
 *    + `workflowType.version`: String constraint. The key is `swf:workflowType.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public suspend inline fun SwfClient.undeprecateWorkflowType(crossinline block: UndeprecateWorkflowTypeRequest.Builder.() -> Unit): UndeprecateWorkflowTypeResponse = undeprecateWorkflowType(UndeprecateWorkflowTypeRequest.Builder().apply(block).build())

/**
 * Remove a tag from a Amazon SWF domain.
 */
public suspend inline fun SwfClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
