// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.serde

import aws.sdk.kotlin.services.swf.model.SwfException
import aws.sdk.kotlin.services.swf.model.UndeprecateDomainResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UndeprecateDomainOperationDeserializer: HttpDeserializer.NonStreaming<UndeprecateDomainResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UndeprecateDomainResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUndeprecateDomainError(context, call, payload)
        }
        val builder = UndeprecateDomainResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUndeprecateDomainError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DomainAlreadyExistsFault" -> DomainAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
