// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the details of the `WorkflowExecutionContinuedAsNew` event.
 */
public class WorkflowExecutionContinuedAsNewEventAttributes private constructor(builder: Builder) {
    /**
     * The policy to use for the child workflow executions of the new execution if it is terminated by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout.
     *
     * The supported child policies are:
     * + `TERMINATE` – The child executions are terminated.
     * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
     * + `ABANDON` – No action is taken. The child executions continue to run.
     */
    public val childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy = requireNotNull(builder.childPolicy) { "A non-null value must be provided for childPolicy" }
    /**
     * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `ContinueAsNewWorkflowExecution` decision that started this execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public val decisionTaskCompletedEventId: kotlin.Long = builder.decisionTaskCompletedEventId
    /**
     * The total duration allowed for the new workflow execution.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val executionStartToCloseTimeout: kotlin.String? = builder.executionStartToCloseTimeout
    /**
     * The input provided to the new workflow execution.
     */
    public val input: kotlin.String? = builder.input
    /**
     * The IAM role to attach to the new (continued) workflow execution.
     */
    public val lambdaRole: kotlin.String? = builder.lambdaRole
    /**
     * The `runId` of the new workflow execution.
     */
    public val newExecutionRunId: kotlin.String = requireNotNull(builder.newExecutionRunId) { "A non-null value must be provided for newExecutionRunId" }
    /**
     * The list of tags associated with the new workflow execution.
     */
    public val tagList: List<String>? = builder.tagList
    /**
     * The task list to use for the decisions of the new (continued) workflow execution.
     */
    public val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList
    /**
     * The priority of the task to use for the decisions of the new (continued) workflow execution.
     */
    public val taskPriority: kotlin.String? = builder.taskPriority
    /**
     * The maximum duration of decision tasks for the new workflow execution.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val taskStartToCloseTimeout: kotlin.String? = builder.taskStartToCloseTimeout
    /**
     * The workflow type of this execution.
     */
    public val workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = builder.workflowType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkflowExecutionContinuedAsNewEventAttributes(")
        append("childPolicy=$childPolicy,")
        append("decisionTaskCompletedEventId=$decisionTaskCompletedEventId,")
        append("executionStartToCloseTimeout=$executionStartToCloseTimeout,")
        append("input=$input,")
        append("lambdaRole=$lambdaRole,")
        append("newExecutionRunId=$newExecutionRunId,")
        append("tagList=$tagList,")
        append("taskList=$taskList,")
        append("taskPriority=$taskPriority,")
        append("taskStartToCloseTimeout=$taskStartToCloseTimeout,")
        append("workflowType=$workflowType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = childPolicy.hashCode()
        result = 31 * result + (decisionTaskCompletedEventId.hashCode())
        result = 31 * result + (executionStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (lambdaRole?.hashCode() ?: 0)
        result = 31 * result + (newExecutionRunId.hashCode())
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (taskList?.hashCode() ?: 0)
        result = 31 * result + (taskPriority?.hashCode() ?: 0)
        result = 31 * result + (taskStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (workflowType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkflowExecutionContinuedAsNewEventAttributes

        if (childPolicy != other.childPolicy) return false
        if (decisionTaskCompletedEventId != other.decisionTaskCompletedEventId) return false
        if (executionStartToCloseTimeout != other.executionStartToCloseTimeout) return false
        if (input != other.input) return false
        if (lambdaRole != other.lambdaRole) return false
        if (newExecutionRunId != other.newExecutionRunId) return false
        if (tagList != other.tagList) return false
        if (taskList != other.taskList) return false
        if (taskPriority != other.taskPriority) return false
        if (taskStartToCloseTimeout != other.taskStartToCloseTimeout) return false
        if (workflowType != other.workflowType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The policy to use for the child workflow executions of the new execution if it is terminated by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout.
         *
         * The supported child policies are:
         * + `TERMINATE` – The child executions are terminated.
         * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
         * + `ABANDON` – No action is taken. The child executions continue to run.
         */
        public var childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = null
        /**
         * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `ContinueAsNewWorkflowExecution` decision that started this execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        public var decisionTaskCompletedEventId: kotlin.Long = 0L
        /**
         * The total duration allowed for the new workflow execution.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var executionStartToCloseTimeout: kotlin.String? = null
        /**
         * The input provided to the new workflow execution.
         */
        public var input: kotlin.String? = null
        /**
         * The IAM role to attach to the new (continued) workflow execution.
         */
        public var lambdaRole: kotlin.String? = null
        /**
         * The `runId` of the new workflow execution.
         */
        public var newExecutionRunId: kotlin.String? = null
        /**
         * The list of tags associated with the new workflow execution.
         */
        public var tagList: List<String>? = null
        /**
         * The task list to use for the decisions of the new (continued) workflow execution.
         */
        public var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * The priority of the task to use for the decisions of the new (continued) workflow execution.
         */
        public var taskPriority: kotlin.String? = null
        /**
         * The maximum duration of decision tasks for the new workflow execution.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var taskStartToCloseTimeout: kotlin.String? = null
        /**
         * The workflow type of this execution.
         */
        public var workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes) : this() {
            this.childPolicy = x.childPolicy
            this.decisionTaskCompletedEventId = x.decisionTaskCompletedEventId
            this.executionStartToCloseTimeout = x.executionStartToCloseTimeout
            this.input = x.input
            this.lambdaRole = x.lambdaRole
            this.newExecutionRunId = x.newExecutionRunId
            this.tagList = x.tagList
            this.taskList = x.taskList
            this.taskPriority = x.taskPriority
            this.taskStartToCloseTimeout = x.taskStartToCloseTimeout
            this.workflowType = x.workflowType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes = WorkflowExecutionContinuedAsNewEventAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        public fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowType] inside the given [block]
         */
        public fun workflowType(block: aws.sdk.kotlin.services.swf.model.WorkflowType.Builder.() -> kotlin.Unit) {
            this.workflowType = aws.sdk.kotlin.services.swf.model.WorkflowType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (childPolicy == null) childPolicy = ChildPolicy.SdkUnknown("no value provided")
            if (newExecutionRunId == null) newExecutionRunId = ""
            return this
        }
    }
}
