// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the details of the `ScheduleActivityTaskFailed` event.
 */
public class ScheduleActivityTaskFailedEventAttributes private constructor(builder: Builder) {
    /**
     * The activityId provided in the `ScheduleActivityTask` decision that failed.
     */
    public val activityId: kotlin.String = requireNotNull(builder.activityId) { "A non-null value must be provided for activityId" }
    /**
     * The activity type provided in the `ScheduleActivityTask` decision that failed.
     */
    public val activityType: aws.sdk.kotlin.services.swf.model.ActivityType? = builder.activityType
    /**
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     *
     * If `cause` is set to `OPERATION_NOT_PERMITTED`, the decision failed because it lacked sufficient permissions. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public val cause: aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskFailedCause = requireNotNull(builder.cause) { "A non-null value must be provided for cause" }
    /**
     * The ID of the `DecisionTaskCompleted` event corresponding to the decision that resulted in the scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public val decisionTaskCompletedEventId: kotlin.Long = builder.decisionTaskCompletedEventId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskFailedEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduleActivityTaskFailedEventAttributes(")
        append("activityId=$activityId,")
        append("activityType=$activityType,")
        append("cause=$cause,")
        append("decisionTaskCompletedEventId=$decisionTaskCompletedEventId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityId.hashCode()
        result = 31 * result + (activityType?.hashCode() ?: 0)
        result = 31 * result + (cause.hashCode())
        result = 31 * result + (decisionTaskCompletedEventId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduleActivityTaskFailedEventAttributes

        if (activityId != other.activityId) return false
        if (activityType != other.activityType) return false
        if (cause != other.cause) return false
        if (decisionTaskCompletedEventId != other.decisionTaskCompletedEventId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskFailedEventAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The activityId provided in the `ScheduleActivityTask` decision that failed.
         */
        public var activityId: kotlin.String? = null
        /**
         * The activity type provided in the `ScheduleActivityTask` decision that failed.
         */
        public var activityType: aws.sdk.kotlin.services.swf.model.ActivityType? = null
        /**
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
         *
         * If `cause` is set to `OPERATION_NOT_PERMITTED`, the decision failed because it lacked sufficient permissions. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
         */
        public var cause: aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskFailedCause? = null
        /**
         * The ID of the `DecisionTaskCompleted` event corresponding to the decision that resulted in the scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        public var decisionTaskCompletedEventId: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskFailedEventAttributes) : this() {
            this.activityId = x.activityId
            this.activityType = x.activityType
            this.cause = x.cause
            this.decisionTaskCompletedEventId = x.decisionTaskCompletedEventId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskFailedEventAttributes = ScheduleActivityTaskFailedEventAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ActivityType] inside the given [block]
         */
        public fun activityType(block: aws.sdk.kotlin.services.swf.model.ActivityType.Builder.() -> kotlin.Unit) {
            this.activityType = aws.sdk.kotlin.services.swf.model.ActivityType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (activityId == null) activityId = ""
            if (cause == null) cause = ScheduleActivityTaskFailedCause.SdkUnknown("no value provided")
            return this
        }
    }
}
