// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.paginators

import aws.sdk.kotlin.services.swf.SwfClient
import aws.sdk.kotlin.services.swf.model.ActivityTypeInfo
import aws.sdk.kotlin.services.swf.model.DomainInfo
import aws.sdk.kotlin.services.swf.model.GetWorkflowExecutionHistoryRequest
import aws.sdk.kotlin.services.swf.model.GetWorkflowExecutionHistoryResponse
import aws.sdk.kotlin.services.swf.model.HistoryEvent
import aws.sdk.kotlin.services.swf.model.ListActivityTypesRequest
import aws.sdk.kotlin.services.swf.model.ListActivityTypesResponse
import aws.sdk.kotlin.services.swf.model.ListClosedWorkflowExecutionsRequest
import aws.sdk.kotlin.services.swf.model.ListClosedWorkflowExecutionsResponse
import aws.sdk.kotlin.services.swf.model.ListDomainsRequest
import aws.sdk.kotlin.services.swf.model.ListDomainsResponse
import aws.sdk.kotlin.services.swf.model.ListOpenWorkflowExecutionsRequest
import aws.sdk.kotlin.services.swf.model.ListOpenWorkflowExecutionsResponse
import aws.sdk.kotlin.services.swf.model.ListWorkflowTypesRequest
import aws.sdk.kotlin.services.swf.model.ListWorkflowTypesResponse
import aws.sdk.kotlin.services.swf.model.PollForDecisionTaskRequest
import aws.sdk.kotlin.services.swf.model.PollForDecisionTaskResponse
import aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo
import aws.sdk.kotlin.services.swf.model.WorkflowTypeInfo
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetWorkflowExecutionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetWorkflowExecutionHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetWorkflowExecutionHistoryResponse]
 */
public fun SwfClient.getWorkflowExecutionHistoryPaginated(initialRequest: GetWorkflowExecutionHistoryRequest): Flow<GetWorkflowExecutionHistoryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextPageToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextPageToken = cursor
            }
            val result = this@getWorkflowExecutionHistoryPaginated.getWorkflowExecutionHistory(req)
            cursor = result.nextPageToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetWorkflowExecutionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetWorkflowExecutionHistoryResponse]
 */
public fun SwfClient.getWorkflowExecutionHistoryPaginated(block: GetWorkflowExecutionHistoryRequest.Builder.() -> Unit): Flow<GetWorkflowExecutionHistoryResponse> =
    getWorkflowExecutionHistoryPaginated(GetWorkflowExecutionHistoryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getWorkflowExecutionHistoryPaginated]
 * to access the nested member [HistoryEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HistoryEvent]
 */
@JvmName("getWorkflowExecutionHistoryResponseHistoryEvent")
public fun Flow<GetWorkflowExecutionHistoryResponse>.events(): Flow<HistoryEvent> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListActivityTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListActivityTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListActivityTypesResponse]
 */
public fun SwfClient.listActivityTypesPaginated(initialRequest: ListActivityTypesRequest): Flow<ListActivityTypesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextPageToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextPageToken = cursor
            }
            val result = this@listActivityTypesPaginated.listActivityTypes(req)
            cursor = result.nextPageToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListActivityTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListActivityTypesResponse]
 */
public fun SwfClient.listActivityTypesPaginated(block: ListActivityTypesRequest.Builder.() -> Unit): Flow<ListActivityTypesResponse> =
    listActivityTypesPaginated(ListActivityTypesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listActivityTypesPaginated]
 * to access the nested member [ActivityTypeInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ActivityTypeInfo]
 */
@JvmName("listActivityTypesResponseActivityTypeInfo")
public fun Flow<ListActivityTypesResponse>.typeInfos(): Flow<ActivityTypeInfo> =
    transform() { response ->
        response.typeInfos?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClosedWorkflowExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClosedWorkflowExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClosedWorkflowExecutionsResponse]
 */
public fun SwfClient.listClosedWorkflowExecutionsPaginated(initialRequest: ListClosedWorkflowExecutionsRequest): Flow<ListClosedWorkflowExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextPageToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextPageToken = cursor
            }
            val result = this@listClosedWorkflowExecutionsPaginated.listClosedWorkflowExecutions(req)
            cursor = result.nextPageToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClosedWorkflowExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClosedWorkflowExecutionsResponse]
 */
public fun SwfClient.listClosedWorkflowExecutionsPaginated(block: ListClosedWorkflowExecutionsRequest.Builder.() -> Unit): Flow<ListClosedWorkflowExecutionsResponse> =
    listClosedWorkflowExecutionsPaginated(ListClosedWorkflowExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClosedWorkflowExecutionsPaginated]
 * to access the nested member [WorkflowExecutionInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkflowExecutionInfo]
 */
@JvmName("listClosedWorkflowExecutionsResponseWorkflowExecutionInfo")
public fun Flow<ListClosedWorkflowExecutionsResponse>.executionInfos(): Flow<WorkflowExecutionInfo> =
    transform() { response ->
        response.executionInfos?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
public fun SwfClient.listDomainsPaginated(initialRequest: ListDomainsRequest): Flow<ListDomainsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextPageToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextPageToken = cursor
            }
            val result = this@listDomainsPaginated.listDomains(req)
            cursor = result.nextPageToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
public fun SwfClient.listDomainsPaginated(block: ListDomainsRequest.Builder.() -> Unit): Flow<ListDomainsResponse> =
    listDomainsPaginated(ListDomainsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDomainsPaginated]
 * to access the nested member [DomainInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DomainInfo]
 */
@JvmName("listDomainsResponseDomainInfo")
public fun Flow<ListDomainsResponse>.domainInfos(): Flow<DomainInfo> =
    transform() { response ->
        response.domainInfos?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOpenWorkflowExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOpenWorkflowExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOpenWorkflowExecutionsResponse]
 */
public fun SwfClient.listOpenWorkflowExecutionsPaginated(initialRequest: ListOpenWorkflowExecutionsRequest): Flow<ListOpenWorkflowExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextPageToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextPageToken = cursor
            }
            val result = this@listOpenWorkflowExecutionsPaginated.listOpenWorkflowExecutions(req)
            cursor = result.nextPageToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOpenWorkflowExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOpenWorkflowExecutionsResponse]
 */
public fun SwfClient.listOpenWorkflowExecutionsPaginated(block: ListOpenWorkflowExecutionsRequest.Builder.() -> Unit): Flow<ListOpenWorkflowExecutionsResponse> =
    listOpenWorkflowExecutionsPaginated(ListOpenWorkflowExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOpenWorkflowExecutionsPaginated]
 * to access the nested member [WorkflowExecutionInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkflowExecutionInfo]
 */
@JvmName("listOpenWorkflowExecutionsResponseWorkflowExecutionInfo")
public fun Flow<ListOpenWorkflowExecutionsResponse>.executionInfos(): Flow<WorkflowExecutionInfo> =
    transform() { response ->
        response.executionInfos?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkflowTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkflowTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowTypesResponse]
 */
public fun SwfClient.listWorkflowTypesPaginated(initialRequest: ListWorkflowTypesRequest): Flow<ListWorkflowTypesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextPageToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextPageToken = cursor
            }
            val result = this@listWorkflowTypesPaginated.listWorkflowTypes(req)
            cursor = result.nextPageToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkflowTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowTypesResponse]
 */
public fun SwfClient.listWorkflowTypesPaginated(block: ListWorkflowTypesRequest.Builder.() -> Unit): Flow<ListWorkflowTypesResponse> =
    listWorkflowTypesPaginated(ListWorkflowTypesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkflowTypesPaginated]
 * to access the nested member [WorkflowTypeInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkflowTypeInfo]
 */
@JvmName("listWorkflowTypesResponseWorkflowTypeInfo")
public fun Flow<ListWorkflowTypesResponse>.typeInfos(): Flow<WorkflowTypeInfo> =
    transform() { response ->
        response.typeInfos?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [PollForDecisionTaskResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [PollForDecisionTaskRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PollForDecisionTaskResponse]
 */
public fun SwfClient.pollForDecisionTaskPaginated(initialRequest: PollForDecisionTaskRequest): Flow<PollForDecisionTaskResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextPageToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextPageToken = cursor
            }
            val result = this@pollForDecisionTaskPaginated.pollForDecisionTask(req)
            cursor = result.nextPageToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [PollForDecisionTaskResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PollForDecisionTaskResponse]
 */
public fun SwfClient.pollForDecisionTaskPaginated(block: PollForDecisionTaskRequest.Builder.() -> Unit): Flow<PollForDecisionTaskResponse> =
    pollForDecisionTaskPaginated(PollForDecisionTaskRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [pollForDecisionTaskPaginated]
 * to access the nested member [HistoryEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HistoryEvent]
 */
@JvmName("pollForDecisionTaskResponseHistoryEvent")
public fun Flow<PollForDecisionTaskResponse>.events(): Flow<HistoryEvent> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }
