// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration settings for a workflow execution including timeout values, tasklist etc. These configuration settings are determined from the defaults specified when registering the workflow type and those specified when starting the workflow execution.
 */
public class WorkflowExecutionConfiguration private constructor(builder: Builder) {
    /**
     * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout.
     *
     * The supported child policies are:
     * + `TERMINATE` – The child executions are terminated.
     * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
     * + `ABANDON` – No action is taken. The child executions continue to run.
     */
    public val childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy = requireNotNull(builder.childPolicy) { "A non-null value must be provided for childPolicy" }
    /**
     * The total duration for this workflow execution.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val executionStartToCloseTimeout: kotlin.String = requireNotNull(builder.executionStartToCloseTimeout) { "A non-null value must be provided for executionStartToCloseTimeout" }
    /**
     * The IAM role attached to the child workflow execution.
     */
    public val lambdaRole: kotlin.String? = builder.lambdaRole
    /**
     * The task list used for the decision tasks generated for this workflow execution.
     */
    public val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList
    /**
     * The priority assigned to decision tasks for this workflow execution. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
     *
     * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
     */
    public val taskPriority: kotlin.String? = builder.taskPriority
    /**
     * The maximum duration allowed for decision tasks for this workflow execution.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val taskStartToCloseTimeout: kotlin.String = requireNotNull(builder.taskStartToCloseTimeout) { "A non-null value must be provided for taskStartToCloseTimeout" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.WorkflowExecutionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkflowExecutionConfiguration(")
        append("childPolicy=$childPolicy,")
        append("executionStartToCloseTimeout=$executionStartToCloseTimeout,")
        append("lambdaRole=$lambdaRole,")
        append("taskList=$taskList,")
        append("taskPriority=$taskPriority,")
        append("taskStartToCloseTimeout=$taskStartToCloseTimeout")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = childPolicy.hashCode()
        result = 31 * result + (executionStartToCloseTimeout.hashCode())
        result = 31 * result + (lambdaRole?.hashCode() ?: 0)
        result = 31 * result + (taskList?.hashCode() ?: 0)
        result = 31 * result + (taskPriority?.hashCode() ?: 0)
        result = 31 * result + (taskStartToCloseTimeout.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkflowExecutionConfiguration

        if (childPolicy != other.childPolicy) return false
        if (executionStartToCloseTimeout != other.executionStartToCloseTimeout) return false
        if (lambdaRole != other.lambdaRole) return false
        if (taskList != other.taskList) return false
        if (taskPriority != other.taskPriority) return false
        if (taskStartToCloseTimeout != other.taskStartToCloseTimeout) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.WorkflowExecutionConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout.
         *
         * The supported child policies are:
         * + `TERMINATE` – The child executions are terminated.
         * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
         * + `ABANDON` – No action is taken. The child executions continue to run.
         */
        public var childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = null
        /**
         * The total duration for this workflow execution.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var executionStartToCloseTimeout: kotlin.String? = null
        /**
         * The IAM role attached to the child workflow execution.
         */
        public var lambdaRole: kotlin.String? = null
        /**
         * The task list used for the decision tasks generated for this workflow execution.
         */
        public var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * The priority assigned to decision tasks for this workflow execution. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
         *
         * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
         */
        public var taskPriority: kotlin.String? = null
        /**
         * The maximum duration allowed for decision tasks for this workflow execution.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var taskStartToCloseTimeout: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.WorkflowExecutionConfiguration) : this() {
            this.childPolicy = x.childPolicy
            this.executionStartToCloseTimeout = x.executionStartToCloseTimeout
            this.lambdaRole = x.lambdaRole
            this.taskList = x.taskList
            this.taskPriority = x.taskPriority
            this.taskStartToCloseTimeout = x.taskStartToCloseTimeout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.WorkflowExecutionConfiguration = WorkflowExecutionConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        public fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (childPolicy == null) childPolicy = ChildPolicy.SdkUnknown("no value provided")
            if (executionStartToCloseTimeout == null) executionStartToCloseTimeout = ""
            if (taskStartToCloseTimeout == null) taskStartToCloseTimeout = ""
            return this
        }
    }
}
