// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the details of the `RecordMarker` decision.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public class RecordMarkerDecisionAttributes private constructor(builder: Builder) {
    /**
     * The details of the marker.
     */
    public val details: kotlin.String? = builder.details
    /**
     * The name of the marker.
     */
    public val markerName: kotlin.String = requireNotNull(builder.markerName) { "A non-null value must be provided for markerName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.RecordMarkerDecisionAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecordMarkerDecisionAttributes(")
        append("details=$details,")
        append("markerName=$markerName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = details?.hashCode() ?: 0
        result = 31 * result + (markerName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecordMarkerDecisionAttributes

        if (details != other.details) return false
        if (markerName != other.markerName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.RecordMarkerDecisionAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The details of the marker.
         */
        public var details: kotlin.String? = null
        /**
         * The name of the marker.
         */
        public var markerName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.RecordMarkerDecisionAttributes) : this() {
            this.details = x.details
            this.markerName = x.markerName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.RecordMarkerDecisionAttributes = RecordMarkerDecisionAttributes(this)

        internal fun correctErrors(): Builder {
            if (markerName == null) markerName = ""
            return this
        }
    }
}
