// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that represents a decision task. Decision tasks are sent to deciders in order for them to make decisions.
 */
public class PollForDecisionTaskResponse private constructor(builder: Builder) {
    /**
     * A paginated list of history events of the workflow execution. The decider uses this during the processing of the decision task.
     */
    public val events: List<HistoryEvent> = requireNotNull(builder.events) { "A non-null value must be provided for events" }
    /**
     * If a `NextPageToken` was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in `nextPageToken`. Keep all other arguments unchanged.
     *
     * The configured `maximumPageSize` determines how many results can be returned in a single call.
     */
    public val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * The ID of the DecisionTaskStarted event of the previous decision task of this workflow execution that was processed by the decider. This can be used to determine the events in the history new since the last decision task received by the decider.
     */
    public val previousStartedEventId: kotlin.Long = builder.previousStartedEventId
    /**
     * The ID of the `DecisionTaskStarted` event recorded in the history.
     */
    public val startedEventId: kotlin.Long = builder.startedEventId
    /**
     * The opaque string used as a handle on the task. This token is used by workers to communicate progress and response information back to the system about the task.
     */
    public val taskToken: kotlin.String = requireNotNull(builder.taskToken) { "A non-null value must be provided for taskToken" }
    /**
     * The workflow execution for which this decision task was created.
     */
    public val workflowExecution: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = builder.workflowExecution
    /**
     * The type of the workflow execution for which this decision task was created.
     */
    public val workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = builder.workflowType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.PollForDecisionTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PollForDecisionTaskResponse(")
        append("events=$events,")
        append("nextPageToken=$nextPageToken,")
        append("previousStartedEventId=$previousStartedEventId,")
        append("startedEventId=$startedEventId,")
        append("taskToken=$taskToken,")
        append("workflowExecution=$workflowExecution,")
        append("workflowType=$workflowType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = events.hashCode()
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (previousStartedEventId.hashCode())
        result = 31 * result + (startedEventId.hashCode())
        result = 31 * result + (taskToken.hashCode())
        result = 31 * result + (workflowExecution?.hashCode() ?: 0)
        result = 31 * result + (workflowType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PollForDecisionTaskResponse

        if (events != other.events) return false
        if (nextPageToken != other.nextPageToken) return false
        if (previousStartedEventId != other.previousStartedEventId) return false
        if (startedEventId != other.startedEventId) return false
        if (taskToken != other.taskToken) return false
        if (workflowExecution != other.workflowExecution) return false
        if (workflowType != other.workflowType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.PollForDecisionTaskResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A paginated list of history events of the workflow execution. The decider uses this during the processing of the decision task.
         */
        public var events: List<HistoryEvent>? = null
        /**
         * If a `NextPageToken` was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in `nextPageToken`. Keep all other arguments unchanged.
         *
         * The configured `maximumPageSize` determines how many results can be returned in a single call.
         */
        public var nextPageToken: kotlin.String? = null
        /**
         * The ID of the DecisionTaskStarted event of the previous decision task of this workflow execution that was processed by the decider. This can be used to determine the events in the history new since the last decision task received by the decider.
         */
        public var previousStartedEventId: kotlin.Long = 0L
        /**
         * The ID of the `DecisionTaskStarted` event recorded in the history.
         */
        public var startedEventId: kotlin.Long = 0L
        /**
         * The opaque string used as a handle on the task. This token is used by workers to communicate progress and response information back to the system about the task.
         */
        public var taskToken: kotlin.String? = null
        /**
         * The workflow execution for which this decision task was created.
         */
        public var workflowExecution: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = null
        /**
         * The type of the workflow execution for which this decision task was created.
         */
        public var workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.PollForDecisionTaskResponse) : this() {
            this.events = x.events
            this.nextPageToken = x.nextPageToken
            this.previousStartedEventId = x.previousStartedEventId
            this.startedEventId = x.startedEventId
            this.taskToken = x.taskToken
            this.workflowExecution = x.workflowExecution
            this.workflowType = x.workflowType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.PollForDecisionTaskResponse = PollForDecisionTaskResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecution] inside the given [block]
         */
        public fun workflowExecution(block: aws.sdk.kotlin.services.swf.model.WorkflowExecution.Builder.() -> kotlin.Unit) {
            this.workflowExecution = aws.sdk.kotlin.services.swf.model.WorkflowExecution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowType] inside the given [block]
         */
        public fun workflowType(block: aws.sdk.kotlin.services.swf.model.WorkflowType.Builder.() -> kotlin.Unit) {
            this.workflowType = aws.sdk.kotlin.services.swf.model.WorkflowType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (events == null) events = emptyList()
            if (taskToken == null) taskToken = ""
            return this
        }
    }
}
